/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.workflow;

import org.egov.eis.service.EisCommonService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;

public abstract class WorkflowActionStep {
    protected PropertyImpl propertyModel;
    protected EisCommonService eisCommonService;
    protected Long userId;
    protected PropertyTaxUtil propertyTaxUtil;
    protected String actionName;
    private String comments;

    public WorkflowActionStep() {
    }

    public WorkflowActionStep(PropertyImpl propertyModel, Long userId, String comments) {
        this.propertyModel = propertyModel;
        this.userId = userId;
        this.comments = comments;
    }

    public abstract String getStepName();

    public abstract String getStepValue();

    public Position getPosition() {
        return this.eisCommonService.getPositionByUserId(this.userId);
    }

    public void changeState() {
        this.propertyModel.transition(true);
    }

    public Property getPropertyModel() {
        return this.propertyModel;
    }

    public void setPropertyModel(PropertyImpl propertyModel) {
        this.propertyModel = propertyModel;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }
}

