/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.util;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.DepreciationMaster;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonDetails;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentType;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.handler.TaxCalculationInfoXmlHandler;
import org.egov.ptis.client.model.PenaltyAndRebate;
import org.egov.ptis.client.model.PropertyArrearBean;
import org.egov.ptis.client.model.calculator.APMiscellaneousTax;
import org.egov.ptis.client.model.calculator.APMiscellaneousTaxDetail;
import org.egov.ptis.client.model.calculator.APTaxCalculationInfo;
import org.egov.ptis.client.model.calculator.APUnitTaxCalculationInfo;
import org.egov.ptis.client.model.calculator.DemandNoticeDetailsInfo;
import org.egov.ptis.client.workflow.ActionAmalgmate;
import org.egov.ptis.client.workflow.ActionBifurcate;
import org.egov.ptis.client.workflow.ActionChangeAddress;
import org.egov.ptis.client.workflow.ActionCreate;
import org.egov.ptis.client.workflow.ActionDeactivate;
import org.egov.ptis.client.workflow.ActionModify;
import org.egov.ptis.client.workflow.ActionNameTransfer;
import org.egov.ptis.client.workflow.WorkflowDetails;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.BoundaryCategoryDao;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.egov.ptis.domain.entity.demand.FloorwiseDemandCalculations;
import org.egov.ptis.domain.entity.demand.PTDemandCalculations;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Category;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyArrear;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.RebatePeriod;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionDetails;
import org.egov.ptis.domain.entity.property.WorkflowBean;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.MiscellaneousTaxDetail;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.egov.ptis.domain.service.property.RebatePeriodService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.egov.ptis.wtms.ConsumerConsumption;
import org.egov.ptis.wtms.PropertyWiseConsumptions;
import org.egov.ptis.wtms.WaterChargesIntegrationService;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PropertyTaxUtil {
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(PropertyTaxUtil.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private UserService userService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private BoundaryCategoryDao boundaryCategoryDAO;
    @Autowired
    private DemandGenericHibDao demandGenericDAO;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private PropertyDAO propertyDAO;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    @Qualifier(value="waterChargesIntegrationServiceImpl")
    private WaterChargesIntegrationService waterChargesIntegrationService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private RebatePeriodService rebatePeriodService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @PersistenceContext
    private EntityManager entityManager;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public CFinancialYear getFinancialYearforDate(Date date) {
        return (CFinancialYear)this.persistenceService.getSession().createQuery("from CFinancialYear cfinancialyear where ? between cfinancialyear.startingDate and cfinancialyear.endingDate").setDate(0, date).list().get(0);
    }

    public Category getCategoryForBoundary(Boundary boundary) {
        return this.boundaryCategoryDAO.getCategoryForBoundary(boundary);
    }

    public List<Installment> getInstallmentListByStartDate(Date startDate) {
        return this.persistenceService.findAllByNamedQuery("INSTALLMENTLISTBY_MODULE_AND_STARTYEAR", new Object[]{startDate, startDate, "Property Tax"});
    }

    public List<Installment> getInstallmentListByStartDateToCurrFinYear(Date startDate) {
        return this.persistenceService.findAllByNamedQuery("INSTALLMENTLISTBY_MODULE_AND_FINANCIALYYEAR", new Object[]{"Property Tax", "Property Tax", startDate});
    }

    public List<Installment> getInstallmentListByStartDateToCurrFinYearDesc(Date startDate) {
        return this.persistenceService.findAllByNamedQuery("INSTALLMENTLISTBY_MODULE_AND_FINANCIALYYEAR_DESC", new Object[]{"Property Tax", "Property Tax", startDate});
    }

    public EgDemandReason getDemandReasonByCodeAndInstallment(String demandReasonCode, Installment installment) {
        return (EgDemandReason)this.persistenceService.findByNamedQuery("DEMANDREASONBY_CODE_AND_INSTALLMENTID", new Object[]{demandReasonCode, installment.getId()});
    }

    public EgDemandReasonDetails getDemandReasonDetailsByDemandReasonId(EgDemandReason demandReason, BigDecimal grossAnnualRentAfterDeduction) {
        return (EgDemandReasonDetails)this.persistenceService.findByNamedQuery("DEMANDREASONDETAILBY_DEMANDREASONID", new Object[]{demandReason.getId(), grossAnnualRentAfterDeduction});
    }

    public List<EgDemandReasonDetails> getDemandReasonDetails(String demandReasonCode, BigDecimal grossAnnualRentAfterDeduction, Installment installment) {
        return this.persistenceService.findAllByNamedQuery("DEMANDREASONDETAILS_BY_DEMANDREASON_AND_INSTALLMENT", new Object[]{demandReasonCode, grossAnnualRentAfterDeduction, installment.getFromDate(), installment.getToDate()});
    }

    public String getAppConfigValue(String moduleName, String key, String defaultValue) {
        AppConfigValues appConfigValues = this.appConfigValuesService.getAppConfigValueByDate(moduleName, key, new Date());
        return appConfigValues == null ? defaultValue : appConfigValues.getValue();
    }

    public TaxCalculationInfo getTaxCalInfo(Ptdemand demand) {
        TaxCalculationInfo taxCalInfo = null;
        TaxCalculationInfoXmlHandler handler = new TaxCalculationInfoXmlHandler();
        PTDemandCalculations ptDmdCalc = demand.getDmdCalculations();
        if (ptDmdCalc.getTaxInfo() != null) {
            String xmlString = new String(ptDmdCalc.getTaxInfo());
            LOGGER.debug((Object)("TaxCalculationInfo XML : " + xmlString));
            taxCalInfo = (TaxCalculationInfo)handler.toObject(xmlString);
            if (taxCalInfo.getPropertyId() == null) {
                taxCalInfo.setPropertyId(demand.getEgptProperty().getBasicProperty().getUpicNo());
            }
        }
        return taxCalInfo;
    }

    public static BigDecimal roundOffTax(BigDecimal tax) {
        return MoneyUtils.roundOff((BigDecimal)tax);
    }

    private Map<String, BigDecimal> populateReasonsSum(Object[] data, Map<String, BigDecimal> taxSum) {
        if (data[0].toString().equals("GEN_TAX")) {
            BigDecimal tmpVal = taxSum.get("GEN_TAX");
            taxSum.put("GEN_TAX", tmpVal.add(((BigDecimal)data[2]).subtract((BigDecimal)data[3])));
        } else if (data[0].toString().equals("LIB_CESS")) {
            BigDecimal tmpVal = taxSum.get("LIB_CESS");
            taxSum.put("LIB_CESS", tmpVal.add(((BigDecimal)data[2]).subtract((BigDecimal)data[3])));
        } else if (data[0].toString().equals("EDU_CESS")) {
            BigDecimal tmpVal = taxSum.get("EDU_CESS");
            taxSum.put("EDU_CESS", tmpVal.add(((BigDecimal)data[2]).subtract((BigDecimal)data[3])));
        } else if (data[0].toString().equals("UNAUTH_PENALTY")) {
            BigDecimal tmpVal = taxSum.get("UNAUTH_PENALTY");
            taxSum.put("UNAUTH_PENALTY", tmpVal.add(((BigDecimal)data[2]).subtract((BigDecimal)data[3])));
        } else if (data[0].toString().equals("PENALTY_FINES")) {
            BigDecimal tmpVal = taxSum.get("PENALTY_FINES");
            taxSum.put("PENALTY_FINES", tmpVal.add(((BigDecimal)data[2]).subtract((BigDecimal)data[3])));
        } else if (data[0].toString().equals("CHQ_BUNC_PENALTY")) {
            BigDecimal tmpVal = taxSum.get("CHQ_BUNC_PENALTY");
            taxSum.put("CHQ_BUNC_PENALTY", tmpVal.add(((BigDecimal)data[2]).subtract((BigDecimal)data[3])));
        }
        return taxSum;
    }

    public Map<String, Map<String, BigDecimal>> getDemandDues(String propertyId) {
        HashMap<String, Map<String, BigDecimal>> demandDues = new HashMap<String, Map<String, BigDecimal>>();
        List list = new ArrayList();
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(propertyId);
        Ptdemand egDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(basicProperty.getProperty());
        Module module = this.moduleService.getModuleByName("Property Tax");
        Installment currentInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
        list = this.demandGenericDAO.getReasonWiseDCB((EgDemand)egDemand, module);
        Map<String, BigDecimal> arrTaxSum = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> currTaxSum = new HashMap<String, BigDecimal>();
        arrTaxSum = this.initReasonsMap(arrTaxSum);
        currTaxSum = this.initReasonsMap(currTaxSum);
        for (Object record : list) {
            Object[] data = (Object[])record;
            if (data[1].toString().compareTo(currentInstall.toString()) < 0) {
                arrTaxSum = this.populateReasonsSum(data, arrTaxSum);
                continue;
            }
            currTaxSum = this.populateReasonsSum(data, currTaxSum);
        }
        demandDues.put("ARREARS", arrTaxSum);
        demandDues.put("CURRENT", currTaxSum);
        return demandDues;
    }

    private Map<String, BigDecimal> initReasonsMap(Map<String, BigDecimal> taxSum) {
        taxSum.put("GEN_TAX", BigDecimal.ZERO);
        taxSum.put("LIB_CESS", BigDecimal.ZERO);
        taxSum.put("EDU_CESS", BigDecimal.ZERO);
        taxSum.put("UNAUTH_PENALTY", BigDecimal.ZERO);
        taxSum.put("PENALTY_FINES", BigDecimal.ZERO);
        taxSum.put("CHQ_BUNC_PENALTY", BigDecimal.ZERO);
        return taxSum;
    }

    public User getLoggedInUser(Map<String, Object> sessionMap) {
        return this.userService.getUserByUsername((String)sessionMap.get("username"));
    }

    private Department getDepartmentOfUser(User user) {
        return this.getAssignment(user.getId()).getDepartment();
    }

    private Assignment getAssignment(Long userId) {
        Employee empForUserId = this.employeeService.getEmployeeById(userId);
        Assignment assignmentByEmpAndDate = this.assignmentService.getPrimaryAssignmentForEmployeeByToDate(empForUserId.getId(), new Date());
        return assignmentByEmpAndDate;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, Integer> generateOrderForDemandDetails(Set<EgDemandDetails> demandDetails, PropertyTaxBillable billable, List<Installment> advanceInstallments) {
        TreeMap<Date, String> instReasonMap = new TreeMap<Date, String>();
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        BigDecimal balance = BigDecimal.ZERO;
        Date key = null;
        String reasonMasterCode = null;
        Map<String, Installment> currYearInstMap = this.getInstallmentsForCurrYear(new Date());
        for (EgDemandDetails demandDetail : demandDetails) {
            balance = BigDecimal.ZERO;
            balance = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (balance.compareTo(BigDecimal.ZERO) != 1) continue;
            EgDemandReason egDemandReason = demandDetail.getEgDemandReason();
            Installment installment = egDemandReason.getEgInstallmentMaster();
            DateTime dateTime = new DateTime((Object)installment.getInstallmentYear());
            reasonMasterCode = egDemandReason.getEgDemandReasonMaster().getCode();
            LOGGER.info((Object)reasonMasterCode);
            key = this.getOrder(installment.getInstallmentYear(), PropertyTaxConstants.DEMAND_REASON_ORDER_MAP.get(reasonMasterCode));
            instReasonMap.put(key, dateTime.getMonthOfYear() + "/" + dateTime.getYear() + "-" + reasonMasterCode);
        }
        if (this.isRebatePeriodActive()) {
            Installment currFirstHalf = currYearInstMap.get("Current 1st Half");
            DateTime dateTime = new DateTime((Object)currFirstHalf.getInstallmentYear());
            key = this.getOrder(currFirstHalf.getInstallmentYear(), PropertyTaxConstants.DEMAND_REASON_ORDER_MAP.get("REBATE"));
            instReasonMap.put(key, dateTime.getMonthOfYear() + "/" + dateTime.getYear() + "-" + "REBATE");
        }
        DateTime dateTime = null;
        for (Installment installment : advanceInstallments) {
            dateTime = new DateTime((Object)installment.getInstallmentYear());
            key = this.getOrder(installment.getInstallmentYear(), PropertyTaxConstants.DEMAND_REASON_ORDER_MAP.get("ADVANCE"));
            instReasonMap.put(key, dateTime.getMonthOfYear() + "/" + dateTime.getYear() + "-" + "ADVANCE");
        }
        BigDecimal penaltyAmount = BigDecimal.ZERO;
        for (Map.Entry<Installment, PenaltyAndRebate> entry : billable.getInstTaxBean().entrySet()) {
            penaltyAmount = entry.getValue().getPenalty();
            boolean thereIsPenalty = penaltyAmount != null && penaltyAmount.compareTo(BigDecimal.ZERO) > 0;
            if (!thereIsPenalty) continue;
            dateTime = new DateTime((Object)entry.getKey().getInstallmentYear());
            key = this.getOrder(entry.getKey().getInstallmentYear(), PropertyTaxConstants.DEMAND_REASON_ORDER_MAP.get("PENALTY_FINES"));
            instReasonMap.put(key, dateTime.getMonthOfYear() + "/" + dateTime.getYear() + "-" + "PENALTY_FINES");
        }
        boolean bl = true;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : instReasonMap.entrySet()) {
            String[] split = ((String)entry.getValue()).split("-");
            if (linkedHashMap.get(split[0]) == null) {
                HashMap reason = new HashMap();
                reason.put(split[1], entry.getValue());
                linkedHashMap.put(split[0], reason);
                continue;
            }
            ((Map)linkedHashMap.get(split[0])).put(split[1], entry.getValue());
        }
        for (String installmentYear : linkedHashMap.keySet()) {
            for (String reasonCode : PropertyTaxConstants.ORDERED_DEMAND_RSNS_LIST) {
                void var12_17;
                if (((Map)linkedHashMap.get(installmentYear)).get(reasonCode) == null) continue;
                orderMap.put((String)((Map)linkedHashMap.get(installmentYear)).get(reasonCode), (int)(++var12_17));
            }
        }
        return orderMap;
    }

    public List<Department> getDepartmentsForLoggedInUser(User user) {
        Department dept = this.getDepartmentOfUser(user);
        List departments = this.persistenceService.findAllByNamedQuery("getDepartmentsByDeptCode", new Object[]{dept.getCode()});
        return departments;
    }

    public Designation getDesignationForUser(Long userId) {
        Position position = null;
        Designation designation = null;
        if (userId != null && userId.intValue() != 0 && (position = this.positionMasterService.getPositionByUserId(userId)) != null) {
            designation = position.getDeptDesig().getDesignation();
        }
        return designation;
    }

    public EgBillType getBillTypeByCode(String typeCode) {
        EgBillType billType = this.egBillDAO.getBillTypeByCode(typeCode);
        return billType;
    }

    public Date getOrder(Date date, int reasonOrder) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, reasonOrder);
        return calendar.getTime();
    }

    public Map<Installment, BigDecimal> prepareRsnWiseDemandForProp(Property property) {
        Installment inst = null;
        TreeMap<Installment, BigDecimal> instAmountMap = new TreeMap<Installment, BigDecimal>();
        Ptdemand egDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        String demandReason = "";
        BigDecimal amount = BigDecimal.ZERO;
        List<String> demandReasonExcludeList = Arrays.asList("PENALTY_FINES", "ADVANCE");
        for (EgDemandDetails dmdDet : egDemand.getEgDemandDetails()) {
            amount = BigDecimal.ZERO;
            demandReason = dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode();
            if (demandReasonExcludeList.contains(demandReason)) continue;
            inst = dmdDet.getEgDemandReason().getEgInstallmentMaster();
            if (instAmountMap.get(inst) == null) {
                instAmountMap.put(inst, dmdDet.getAmount());
                continue;
            }
            amount = (BigDecimal)instAmountMap.get(inst);
            amount = amount.add(dmdDet.getAmount());
            instAmountMap.put(inst, amount);
        }
        return instAmountMap;
    }

    public Map<Installment, BigDecimal> prepareRsnWiseCollForProp(Property property) {
        Installment inst = null;
        HashMap<Installment, BigDecimal> instCollMap = new HashMap<Installment, BigDecimal>();
        Ptdemand egDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        String demandReason = "";
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal collection = BigDecimal.ZERO;
        for (EgDemandDetails dmdDet : egDemand.getEgDemandDetails()) {
            amount = BigDecimal.ZERO;
            collection = dmdDet.getAmtCollected();
            demandReason = dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode();
            if (demandReason.equals("PENALTY_FINES")) continue;
            inst = dmdDet.getEgDemandReason().getEgInstallmentMaster();
            if (instCollMap.get(inst) == null) {
                instCollMap.put(inst, collection);
                continue;
            }
            amount = (BigDecimal)instCollMap.get(inst);
            amount = amount.add(collection);
            instCollMap.put(inst, amount);
        }
        return instCollMap;
    }

    public Map<String, BigDecimal> prepareTaxNameAndALV(Map<String, BigDecimal> taxNameAndALV, FloorwiseDemandCalculations floorDmdCalc, Set<String> applicableTaxes) {
        LOGGER.debug((Object)"Entered into prepareTaxNameAndALV");
        LOGGER.debug((Object)("prepareTaxNameAndALV - Inputs: taxNameAndALV: " + taxNameAndALV));
        for (String taxName : applicableTaxes) {
            this.putInTaxNameAndALV(taxNameAndALV, taxName, floorDmdCalc.getAlv());
        }
        LOGGER.debug((Object)("prepareTaxNameAndALV - afterPrepare taxNameAndALV: " + taxNameAndALV));
        LOGGER.debug((Object)"Exiting from prepareTaxNameAndALV");
        return taxNameAndALV;
    }

    private void putInTaxNameAndALV(Map<String, BigDecimal> taxNameAndALV, String taxName, BigDecimal alv) {
        if (taxNameAndALV.get(taxName) == null) {
            taxNameAndALV.put(taxName, alv);
        } else {
            taxNameAndALV.put(taxName, taxNameAndALV.get(taxName).add(alv));
        }
    }

    public UnitTaxCalculationInfo getUnitTaxCalculationInfoClone(UnitTaxCalculationInfo unit) {
        LOGGER.debug((Object)"Entered into getUnitTaxCalculationInfoClone");
        APUnitTaxCalculationInfo clone = new APUnitTaxCalculationInfo();
        clone.setFloorNumber(unit.getFloorNumber());
        clone.setUnitOccupation(unit.getUnitOccupation());
        clone.setUnitUsage(unit.getUnitUsage());
        clone.setBaseRate(unit.getBaseRate());
        clone.setMrv(unit.getMrv());
        clone.setBaseRatePerSqMtPerMonth(unit.getBaseRatePerSqMtPerMonth());
        clone.setBuildingValue(unit.getBuildingValue());
        clone.setTotalTaxPayable(unit.getTotalTaxPayable());
        clone.setSiteValue(unit.getSiteValue());
        clone.setOccpancyDate(new Date(unit.getOccpancyDate().getTime()));
        clone.setEffectiveAssessmentDate(unit.getEffectiveAssessmentDate());
        clone.setUnitOccupier(unit.getUnitOccupier());
        clone.setPropertyCreatedDate(unit.getPropertyCreatedDate());
        this.addMiscellaneousTaxesClone(unit, clone);
        LOGGER.debug((Object)"Exiting from getUnitTaxCalculationInfoClone");
        return clone;
    }

    public TaxCalculationInfo getTaxCalculationInfoClone(TaxCalculationInfo taxCalInfo) {
        APTaxCalculationInfo clone = new APTaxCalculationInfo();
        clone.setBlock(taxCalInfo.getBlock());
        clone.setHouseNumber(taxCalInfo.getHouseNumber());
        clone.setPropertyId(taxCalInfo.getPropertyId());
        clone.setPropertyAddress(taxCalInfo.getPropertyAddress());
        clone.setPropertyArea(taxCalInfo.getPropertyArea());
        clone.setPropertyOwnerName(taxCalInfo.getPropertyOwnerName());
        clone.setPropertyType(taxCalInfo.getPropertyType());
        clone.setTaxCalculationInfoXML(taxCalInfo.getTaxCalculationInfoXML());
        clone.setTotalNetARV(taxCalInfo.getTotalNetARV());
        clone.setTotalTaxPayable(taxCalInfo.getTotalTaxPayable());
        clone.setWard(taxCalInfo.getWard());
        clone.setZone(taxCalInfo.getZone());
        this.addUnitTaxCalculationInfoClone(taxCalInfo, clone);
        return clone;
    }

    private void addUnitTaxCalculationInfoClone(TaxCalculationInfo taxCalInfo, TaxCalculationInfo clone) {
        ArrayList<UnitTaxCalculationInfo> units = new ArrayList<UnitTaxCalculationInfo>();
        ArrayList<UnitTaxCalculationInfo> unitsByDate = new ArrayList<UnitTaxCalculationInfo>();
        for (UnitTaxCalculationInfo unitInfo : taxCalInfo.getUnitTaxCalculationInfos()) {
            UnitTaxCalculationInfo newUnitInfo = this.getUnitTaxCalculationInfoClone(unitInfo);
            unitsByDate.add(newUnitInfo);
        }
        clone.setUnitTaxCalculationInfo(units);
    }

    public void addMiscellaneousTaxesClone(UnitTaxCalculationInfo unit, UnitTaxCalculationInfo clone) {
        LOGGER.debug((Object)"Entered into addMiscellaneousTaxesClone");
        for (MiscellaneousTax miscTax : unit.getMiscellaneousTaxes()) {
            APMiscellaneousTax newMiscTax = new APMiscellaneousTax();
            newMiscTax.setTaxName(miscTax.getTaxName());
            newMiscTax.setTotalActualTax(miscTax.getTotalActualTax());
            newMiscTax.setTotalCalculatedTax(miscTax.getTotalCalculatedTax());
            newMiscTax.setHasChanged(miscTax.getHasChanged());
            for (MiscellaneousTaxDetail miscTaxDetail : miscTax.getTaxDetails()) {
                APMiscellaneousTaxDetail newMiscTaxDetail = new APMiscellaneousTaxDetail();
                newMiscTaxDetail.setTaxValue(miscTaxDetail.getTaxValue());
                newMiscTaxDetail.setActualTaxValue(miscTaxDetail.getActualTaxValue());
                newMiscTaxDetail.setCalculatedTaxValue(miscTaxDetail.getCalculatedTaxValue());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(miscTaxDetail.getFromDate());
                newMiscTaxDetail.setFromDate(calendar.getTime());
                newMiscTaxDetail.setNoOfDays(miscTaxDetail.getNoOfDays());
                newMiscTaxDetail.setIsHistory(miscTaxDetail.getIsHistory());
                newMiscTaxDetail.setHistoryALV(miscTaxDetail.getHistoryALV());
                newMiscTax.addMiscellaneousTaxDetail(newMiscTaxDetail);
            }
            clone.addMiscellaneousTaxes(newMiscTax);
        }
        LOGGER.debug((Object)"Exiting from addMiscellaneousTaxesClone");
    }

    public Date getStartDateOfLowestInstallment() {
        return (Date)this.persistenceService.getSession().createQuery("select min(inst.fromDate) from org.egov.commons.Installment inst where inst.module.name = :moduleName").setString("moduleName", "Property Tax").uniqueResult();
    }

    public static Long getNumberOfDays(Date fromDate, Date toDate) {
        LOGGER.debug((Object)("Entered into getNumberOfDays, fromDate=" + fromDate + ", toDate=" + toDate));
        DateTime startDate = new DateTime((Object)fromDate);
        DateTime endDate = new DateTime((Object)toDate);
        Integer days = Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getDays();
        days = days < 0 ? 0 : days;
        return days.longValue();
    }

    public Boolean between(Date date, Date fromDate, Date toDate) {
        return (date.after(fromDate) || date.equals(fromDate)) && date.before(toDate) || date.equals(toDate);
    }

    public Boolean betweenOrBefore(Date date, Date fromDate, Date toDate) {
        Boolean result = this.between(date, fromDate, toDate) != false || date.before(fromDate);
        return result;
    }

    public static int getMonthsBetweenDates(Date fromDate, Date toDate) {
        LOGGER.debug((Object)("Entered into getMonthsBetweenDates - fromDate: " + fromDate + ", toDate: " + toDate));
        Calendar fromDateCalendar = Calendar.getInstance();
        Calendar toDateCalendar = Calendar.getInstance();
        fromDateCalendar.setTime(fromDate);
        toDateCalendar.setTime(toDate);
        int yearDiff = toDateCalendar.get(1) - fromDateCalendar.get(1);
        int noOfMonths = yearDiff * 12 + toDateCalendar.get(2) - fromDateCalendar.get(2);
        LOGGER.debug((Object)("Exiting from getMonthsBetweenDates - noOfMonths: " + ++noOfMonths));
        return noOfMonths;
    }

    public List<PropertyArrearBean> getPropertyArrears(List<PropertyArrear> arrears) {
        ArrayList<PropertyArrearBean> propArrears = new ArrayList<PropertyArrearBean>();
        PropertyArrearBean propArrBean = null;
        for (PropertyArrear pa : arrears) {
            propArrBean = new PropertyArrearBean();
            String key = pa.getFromDate().toString().concat("-").concat(pa.getToDate().toString());
            BigDecimal value = BigDecimal.ZERO;
            value = value.add(pa.getGeneralTax()).add(pa.getSewerageTax()).add(pa.getFireServiceTax()).add(pa.getLightingTax()).add(pa.getGeneralWaterTax()).add(pa.getEducationCess()).add(pa.getEgCess()).add(pa.getBigResidentailTax()).setScale(2, 4);
            propArrBean.setYear(key);
            propArrBean.setTaxAmount(value);
            propArrears.add(propArrBean);
        }
        return propArrears;
    }

    public String antisamyHackReplace(String str) {
        String replacedStr = str.replaceAll("&amp;", "&");
        return replacedStr;
    }

    public Map<String, BigDecimal> getDemandAndCollection(Property property) {
        LOGGER.debug((Object)"Entered into getDemandAndCollection");
        HashMap<String, BigDecimal> demandCollMap = new HashMap<String, BigDecimal>();
        Installment installment = null;
        Integer instId = null;
        BigDecimal currDmd = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currCollection = BigDecimal.ZERO;
        BigDecimal arrColelection = BigDecimal.ZERO;
        BigDecimal currentRebate = BigDecimal.ZERO;
        BigDecimal arrearRebate = BigDecimal.ZERO;
        String reason = "";
        Ptdemand currDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        List dmdCollList = this.propertyDAO.getDmdCollForAllDmdReasons(currDemand);
        BigDecimal advanceCollection = BigDecimal.ZERO;
        BigDecimal secondHalfTax = BigDecimal.ZERO;
        Map<String, Installment> currYearInstallments = this.getInstallmentsForCurrYear(new Date());
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[0].toString());
            installment = this.installmentDao.findById(instId.intValue(), false);
            reason = listObj[5].toString();
            if (currDemand.getEgInstallmentMaster().equals((Object)installment)) {
                if (listObj[2] != null && !listObj[2].equals(BigDecimal.ZERO)) {
                    currCollection = currCollection.add(new BigDecimal(listObj[2].toString()));
                }
                currentRebate = currentRebate.add(new BigDecimal(listObj[3].toString()));
                currDmd = currDmd.add(new BigDecimal(listObj[1].toString()));
            } else if (currYearInstallments.get("Current 2nd Half").equals((Object)installment)) {
                secondHalfTax = secondHalfTax.add(new BigDecimal(listObj[1].toString()));
            } else {
                arrDmd = arrDmd.add(new BigDecimal((Double)listObj[1]));
                if (listObj[2] != null && !listObj[2].equals(BigDecimal.ZERO)) {
                    arrColelection = arrColelection.add(new BigDecimal(listObj[2].toString()));
                }
                arrearRebate = arrearRebate.add(new BigDecimal(listObj[3].toString()));
            }
            if (!reason.equalsIgnoreCase("ADVANCE")) continue;
            advanceCollection = new BigDecimal(listObj[2].toString());
        }
        demandCollMap.put("CURR_DMD", currDmd);
        demandCollMap.put("ARR_DMD", arrDmd);
        demandCollMap.put("CURR_COLL", currCollection);
        demandCollMap.put("ARR_COLL", arrColelection);
        demandCollMap.put("CURRENT_REBATE", currentRebate);
        demandCollMap.put("ARREAR_REBATE", arrearRebate);
        demandCollMap.put("CURR_SECONDHALF_DMD", secondHalfTax);
        demandCollMap.put("ADVANCECOLLECTION", advanceCollection);
        LOGGER.debug((Object)("getDemandAndCollection - demandCollMap = " + demandCollMap));
        LOGGER.debug((Object)"Exiting from getDemandAndCollection");
        return demandCollMap;
    }

    public static boolean isPropertyModified(Property property) {
        for (PropertyStatusValues psv : property.getBasicProperty().getPropertyStatusValuesSet()) {
            if (!"ADD_OR_ALTER".equalsIgnoreCase(psv.getPropertyStatus().getStatusCode())) continue;
            return true;
        }
        return false;
    }

    public void makeTheEgBillAsHistory(BasicProperty basicProperty) {
        EgBill egBill = (EgBill)this.persistenceService.find("from EgBill where module = ? and consumerId like ? || '%' and is_history = 'N'", new Object[]{this.moduleService.getModuleByName("Property Tax"), basicProperty.getUpicNo()});
        if (egBill != null) {
            egBill.setIs_History("Y");
            egBill.setModifiedDate(new Date());
            this.persistenceService.update((Object)egBill);
        }
    }

    public static String buildAddress(Address address) {
        LOGGER.debug((Object)"Entered into buildAddress");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("buildAddress - Address: " + address));
        }
        StringBuffer strAddress = new StringBuffer();
        strAddress.append(StringUtils.isNotBlank((CharSequence)address.getLandmark()) ? address.getLandmark() : " ").append("|");
        strAddress.append(StringUtils.isNotBlank((CharSequence)address.getHouseNoBldgApt()) ? address.getHouseNoBldgApt() : " ").append("|");
        String tmpPin = address.getPinCode();
        strAddress.append(tmpPin != null && !tmpPin.toString().isEmpty() ? tmpPin : " ").append("|");
        LOGGER.debug((Object)("Exit from buildAddress, Address: " + strAddress.toString()));
        return strAddress.toString();
    }

    public static String getOwnerAddress(List<PropertyOwnerInfo> ownerSet) {
        LOGGER.debug((Object)"Entered into getOwnerAddress");
        String ownerAddress = "";
        for (PropertyOwnerInfo owner : ownerSet) {
            List addresses = owner.getOwner().getAddress();
            Iterator iterator = addresses.iterator();
            if (!iterator.hasNext()) continue;
            Address address = (Address)iterator.next();
            ownerAddress = address.toString();
        }
        LOGGER.debug((Object)"Exiting from getOwnerAddress");
        return ownerAddress;
    }

    public Map<String, Date> getLatestCollRcptDateForProp(String consumerCode) {
        LOGGER.debug((Object)("Entered into getLatestCollRcptDateForProp, consumerCode=" + consumerCode));
        HashMap<String, Date> penaltyDates = new HashMap<String, Date>();
        List rcptHeaderList = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select substr(rd.description, length(rd.description)-6, length(rd.description)), max(rh.createdDate) from org.egov.erpcollection.models.ReceiptHeader rh left join rh.receiptDetails rd where rh.status.code = 'APPROVED' and rd.description is not null and rd.cramount > 0 and rh.consumerCode like '" + consumerCode + "%' group by substr(rd.description, length(rd.description)-6, length(rd.description))").list();
        if (rcptHeaderList != null && !rcptHeaderList.isEmpty()) {
            String instStr = "";
            Date penaltyCollDate = null;
            for (Object object : rcptHeaderList) {
                Object[] penaltyDet = (Object[])object;
                instStr = (String)penaltyDet[0];
                penaltyCollDate = (Date)penaltyDet[1];
                penaltyDates.put(instStr, penaltyCollDate);
            }
        }
        LOGGER.debug((Object)("penaltyDates==>" + penaltyDates));
        LOGGER.debug((Object)"Exiting from getLatestCollRcptDateForProp");
        return penaltyDates;
    }

    public static Property getLatestProperty(BasicProperty basicProperty, Character status) {
        LOGGER.debug((Object)("Entered into getLatestProperty, basicProperty=" + basicProperty));
        TreeMap<Date, Property> propertiesByCreatedDate = new TreeMap<Date, Property>();
        Property latestProperty = null;
        for (Property property : basicProperty.getPropertySet()) {
            if (status == null) {
                propertiesByCreatedDate.put(property.getCreatedDate(), property);
                continue;
            }
            if (!property.getStatus().equals(status)) continue;
            propertiesByCreatedDate.put(property.getCreatedDate(), property);
        }
        if (!propertiesByCreatedDate.isEmpty()) {
            ArrayList properties = new ArrayList(propertiesByCreatedDate.values());
            latestProperty = (Property)properties.get(properties.size() - 1);
            LOGGER.debug((Object)("getLatestProperty, latestProperty=" + latestProperty));
        }
        LOGGER.debug((Object)"Exiting from getLatestHistoryProperty");
        return latestProperty;
    }

    public Map<Installment, TaxCalculationInfo> getTaxCalInfoMap(Set<Ptdemand> ptDmdSet) {
        TreeMap<Installment, TaxCalculationInfo> taxCalInfoMap = new TreeMap<Installment, TaxCalculationInfo>();
        for (Ptdemand ptdmd : ptDmdSet) {
            TaxCalculationInfo taxCalcInfo = this.getTaxCalInfo(ptdmd);
            if (taxCalcInfo == null) continue;
            taxCalInfoMap.put(ptdmd.getEgInstallmentMaster(), taxCalcInfo);
        }
        return taxCalInfoMap;
    }

    public Map<Date, TaxCalculationInfo> getTaxCalInfoMap(Set<Ptdemand> ptDmdSet, Date occupancyDate) {
        TreeMap<Date, TaxCalculationInfo> taxCalInfoMap = new TreeMap<Date, TaxCalculationInfo>();
        Installment installment = null;
        for (Ptdemand ptdmd : ptDmdSet) {
            TaxCalculationInfo taxCalcInfo = this.getTaxCalInfo(ptdmd);
            if (taxCalcInfo == null) continue;
            installment = ptdmd.getEgInstallmentMaster();
            if (this.between(occupancyDate, ptdmd.getEgInstallmentMaster().getFromDate(), ptdmd.getEgInstallmentMaster().getToDate()).booleanValue()) {
                taxCalInfoMap.put(occupancyDate, taxCalcInfo);
                continue;
            }
            taxCalInfoMap.put(installment.getFromDate(), taxCalcInfo);
        }
        return taxCalInfoMap;
    }

    public String getDesignationName(Long userId) {
        LOGGER.debug((Object)("Entered into getDesignationName, userId=" + userId));
        return this.getAssignment(userId).getDesignation().getName();
    }

    public WorkflowDetails initWorkflowAction(PropertyImpl propertyModel, WorkflowBean workflowBean, Long loggedInUserId, EisCommonService eisCommonService) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into initWorkflowAction");
            LOGGER.debug((Object)("initWorkflowAction - propertyModel=" + propertyModel + ", workflowBean=" + workflowBean + ", loggedInUserId=" + loggedInUserId));
        }
        String[] beanActionName = null;
        if (PropertyTaxUtil.isNotNull(workflowBean)) {
            beanActionName = workflowBean.getActionName().split(":");
        }
        WorkflowDetails workflowAction = null;
        if ("Create".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionCreate(propertyModel, workflowBean, loggedInUserId);
        } else if ("Modify".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionModify(propertyModel, workflowBean, loggedInUserId);
        } else if ("Bifurcate".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionBifurcate(propertyModel, workflowBean, loggedInUserId);
        } else if ("Amalgamate".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionAmalgmate(propertyModel, workflowBean, loggedInUserId);
        } else if ("ChangeAddress".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionChangeAddress(propertyModel, workflowBean, loggedInUserId);
        } else if ("Deactivate".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionDeactivate(propertyModel, workflowBean, loggedInUserId);
        } else if ("Mutation".equalsIgnoreCase(beanActionName[0])) {
            workflowAction = new ActionNameTransfer(propertyModel, workflowBean, loggedInUserId);
        }
        workflowAction.setWorkflowActionStep(this, eisCommonService);
        LOGGER.debug((Object)("initWorkflowAction - workflowAction=" + workflowAction));
        LOGGER.debug((Object)"Exiting from initWorkflowAction");
        return workflowAction;
    }

    public List<Property> getHistoryProperties(BasicProperty basicProperty) {
        ArrayList<Property> historyProperties = new ArrayList<Property>();
        for (Property property : basicProperty.getPropertySet()) {
            if (!PropertyTaxConstants.STATUS_ISHISTORY.equals(property.getStatus())) continue;
            historyProperties.add(property);
        }
        return historyProperties;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean isNotZero(BigDecimal value) {
        return value == null ? false : value.compareTo(BigDecimal.ZERO) != 0;
    }

    public Date getPropertyOccupancyDate(Property property) {
        return property.getPropertyDetail().getDateOfCompletion() == null ? property.getEffectiveDate() : property.getPropertyDetail().getDateOfCompletion();
    }

    public static boolean isResidentialUnit(String usageName) {
        return "C1, D1, D2, E1, E2, E3".contains(usageName);
    }

    public static boolean isNonResidentialUnit(String usageName) {
        return "A1, A2, A3, A4, A5, A6, B1, B2, C2, C3, C4".contains(usageName);
    }

    public static boolean isOpenPlotUnit(String usageName) {
        return "C5, D3, E4".contains(usageName);
    }

    public static boolean isZero(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) == 0;
    }

    public Installment getPTInstallmentForDate(Date date) {
        Module module = this.moduleService.getModuleByName("Property Tax");
        return this.installmentDao.getInsatllmentByModuleForGivenDate(module, date);
    }

    public static Property getInactiveDemandProperty(BasicProperty basicProperty) {
        LOGGER.debug((Object)"Entered into getInactiveDemandProperty");
        for (Property property : basicProperty.getPropertySet()) {
            if (!property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE) || !property.getIsDefaultProperty().equals(Character.valueOf('Y'))) continue;
            return property;
        }
        LOGGER.debug((Object)"Exiting from getInactiveDemandProperty");
        return null;
    }

    public static String getRevisedDemandYear(Property property) {
        LOGGER.debug((Object)("Entered into getDemandEffectiveYear, property=" + property));
        String demandEffectiveYear = null;
        demandEffectiveYear = new SimpleDateFormat("yyyy").format(property.getPropertyDetail().getDateOfCompletion());
        LOGGER.debug((Object)("getRevisedDemandYear - demandEffectiveYear=" + demandEffectiveYear));
        LOGGER.debug((Object)"Exting from getDemandEffectiveYear");
        return demandEffectiveYear;
    }

    public List<String> getAdvanceYearsFromCurrentInstallment() {
        LOGGER.debug((Object)"Entered into getAdvanceYearsFromCurrentInstallment");
        ArrayList<String> advanceYears = new ArrayList<String>();
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        Integer year = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentInstallment.getFromDate());
        year = calendar.get(1);
        for (int i = 0; i < PropertyTaxConstants.MAX_ADVANCES_ALLOWED; ++i) {
            year = year + 1;
            int fromYear = year;
            int toYear = year + 1;
            advanceYears.add(fromYear + "-" + String.valueOf(toYear).substring(2));
        }
        LOGGER.debug((Object)("getAdvanceYearsFromCurrentInstallment = " + advanceYears));
        LOGGER.debug((Object)"Exiting from getAdvanceYearsFromCurrentInstallment");
        return Collections.emptyList();
    }

    public List<Installment> getOrderedInstallmentsFromGivenDate(Date date) {
        return this.persistenceService.findAllBy("select it from org.egov.commons.Installment it where (it.fromDate>=? or ? between it.fromDate and it.toDate) and it.fromDate<=sysdate and it.module.moduleName=? order by installmentYear", new Object[]{date, date, "Property Tax"});
    }

    public Map<String, EgDemandDetails> getEgDemandDetailsAndReasonAsMap(Set<EgDemandDetails> egDemandDetails) {
        HashMap<String, EgDemandDetails> demandDetailAndReason = new HashMap<String, EgDemandDetails>();
        for (EgDemandDetails egDmndDtls : egDemandDetails) {
            EgDemandReasonMaster dmndRsnMstr = egDmndDtls.getEgDemandReason().getEgDemandReasonMaster();
            if (dmndRsnMstr.getCode().equalsIgnoreCase("GEN_TAX")) {
                demandDetailAndReason.put("GEN_TAX", egDmndDtls);
                continue;
            }
            if (dmndRsnMstr.getCode().equalsIgnoreCase("LIB_CESS")) {
                demandDetailAndReason.put("LIB_CESS", egDmndDtls);
                continue;
            }
            if (dmndRsnMstr.getCode().equalsIgnoreCase("EDU_CESS")) {
                demandDetailAndReason.put("EDU_CESS", egDmndDtls);
                continue;
            }
            if (dmndRsnMstr.getCode().equalsIgnoreCase("UNAUTH_PENALTY")) {
                demandDetailAndReason.put("UNAUTH_PENALTY", egDmndDtls);
                continue;
            }
            if (dmndRsnMstr.getCode().equalsIgnoreCase("PENALTY_FINES")) {
                demandDetailAndReason.put("PENALTY_FINES", egDmndDtls);
                continue;
            }
            if (dmndRsnMstr.getCode().equalsIgnoreCase("CHQ_BUNC_PENALTY")) {
                demandDetailAndReason.put("CHQ_BUNC_PENALTY", egDmndDtls);
                continue;
            }
            if (!dmndRsnMstr.getCode().equalsIgnoreCase("ADVANCE")) continue;
            demandDetailAndReason.put("ADVANCE", egDmndDtls);
        }
        return demandDetailAndReason;
    }

    public Date getEarliestModificationDate(String propertyId) {
        List result = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select to_char(min(pd.effective_date), 'dd/mm/yyyy') from PropertyImpl p inner join p.propertyDetail pd where p.basicProperty.active = true and p.basicProperty.upicNo = :upicNo and (p.remarks is null or p.remarks <> :propertyMigrationRemarks) and pd.effective_date is not null").setString("upicNo", propertyId).setString("propertyMigrationRemarks", "Migrated from NMC Legacy DB").list();
        Date earliestModificationDate = null;
        if (result.isEmpty()) {
            return null;
        }
        if (result.get(0) == null) {
            return null;
        }
        try {
            earliestModificationDate = PropertyTaxConstants.DATEFORMATTER_DDMMYYYY.parse((String)result.get(0));
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Error while parsing effective date", (Throwable)e);
            throw new ApplicationRuntimeException("Error while parsing effective date", (Throwable)e);
        }
        return earliestModificationDate;
    }

    public static Date getWaterTaxEffectiveDateForPenalty() {
        Date waterTaxEffectiveDate = null;
        Logger LOG = LoggerFactory.getLogger(PropertyTaxUtil.class);
        try {
            waterTaxEffectiveDate = PropertyTaxConstants.DATEFORMATTER_DDMMYYYY.parse("01/01/2012");
        }
        catch (ParseException pe) {
            throw new ApplicationRuntimeException("Error while parsing Water Tax Effective Date for Penalty Calculation", (Throwable)pe);
        }
        LOG.debug("getWaterTaxEffectiveDateForPenalty - waterTaxEffectiveDate = {} ", (Object)waterTaxEffectiveDate);
        return waterTaxEffectiveDate;
    }

    public Map<Date, Property> getPropertiesByOccupancy(BasicProperty basicProperty) {
        LOGGER.debug((Object)"Entered into getPropertiesByOccupancy");
        TreeMap<Date, Property> propertyByCreatedDate = new TreeMap<Date, Property>();
        TreeMap<Date, Property> propertyByOccupancyDate = new TreeMap<Date, Property>();
        for (Property property : basicProperty.getPropertySet()) {
            if (!this.inConsider(property)) continue;
            propertyByCreatedDate.put(property.getCreatedDate(), property);
        }
        for (Map.Entry entry : propertyByCreatedDate.entrySet()) {
            propertyByOccupancyDate.put(this.getPropertyOccupancyDate((Property)entry.getValue()), (Property)entry.getValue());
        }
        LOGGER.debug((Object)"Exiting from getPropertiesByOccupancy");
        return propertyByOccupancyDate;
    }

    private boolean inConsider(Property property) {
        return property.getRemarks() == null || !property.getRemarks().startsWith("Migrated");
    }

    public Map<String, Map<Installment, BigDecimal>> prepareReasonWiseDenandAndCollection(Property property, Installment currentInstallment) {
        LOGGER.debug((Object)("Entered into prepareReasonWiseDenandAndCollection, property=" + property));
        TreeMap<Installment, BigDecimal> installmentWiseDemand = new TreeMap<Installment, BigDecimal>();
        TreeMap<Installment, BigDecimal> installmentWiseCollection = new TreeMap<Installment, BigDecimal>();
        HashMap<String, Map<Installment, BigDecimal>> demandAndCollection = new HashMap<String, Map<Installment, BigDecimal>>();
        String demandReason = "";
        Installment installment = null;
        List<String> demandReasonExcludeList = Arrays.asList("PENALTY_FINES", "ADVANCE");
        String query = "select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I') and p = :property and ptd.egInstallmentMaster = :installment";
        Ptdemand ptDemand = (Ptdemand)((Object)((Session)this.entityManager.unwrap(Session.class)).createQuery("select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I') and p = :property and ptd.egInstallmentMaster = :installment").setEntity("property", (Object)property).setEntity("installment", (Object)currentInstallment).list().get(0));
        for (EgDemandDetails dmdDet : ptDemand.getEgDemandDetails()) {
            demandReason = dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode();
            if (demandReasonExcludeList.contains(demandReason)) continue;
            installment = dmdDet.getEgDemandReason().getEgInstallmentMaster();
            if (installmentWiseDemand.get(installment) == null) {
                installmentWiseDemand.put(installment, dmdDet.getAmount());
            } else {
                installmentWiseDemand.put(installment, ((BigDecimal)installmentWiseDemand.get(installment)).add(dmdDet.getAmount()));
            }
            if (installmentWiseCollection.get(installment) == null) {
                installmentWiseCollection.put(installment, dmdDet.getAmtCollected());
                continue;
            }
            installmentWiseCollection.put(installment, ((BigDecimal)installmentWiseCollection.get(installment)).add(dmdDet.getAmtCollected()));
        }
        demandAndCollection.put("DEMAND", installmentWiseDemand);
        demandAndCollection.put("COLLECTION", installmentWiseCollection);
        LOGGER.debug((Object)("prepareReasonWiseDenandAndCollection - demandAndCollection=" + demandAndCollection));
        LOGGER.debug((Object)"Exiting from prepareReasonWiseDenandAndCollection");
        return demandAndCollection;
    }

    public Map<String, Map<String, BigDecimal>> prepareDemandDetForView(Property property, Installment currentInstallment) throws ParseException {
        LOGGER.debug((Object)("Entered into prepareDemandDetForView, property=" + property));
        TreeMap<String, Map<String, BigDecimal>> DCBDetails = new TreeMap<String, Map<String, BigDecimal>>();
        HashMap<String, BigDecimal> firstHalfReasonDemandDetails = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> secondHalfReasonDemandDetails = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> arrearDemandDetails = new HashMap<String, BigDecimal>();
        String demandReason = "";
        Installment installment = null;
        BigDecimal totalArrearDemand = BigDecimal.ZERO;
        BigDecimal totalCurrentDemand = BigDecimal.ZERO;
        BigDecimal totalArrearCollection = BigDecimal.ZERO;
        BigDecimal totalCurrentCollection = BigDecimal.ZERO;
        BigDecimal totalNextInstCollection = BigDecimal.ZERO;
        BigDecimal totalNextInstDemand = BigDecimal.ZERO;
        Map<String, Installment> currYearInstMap = this.getInstallmentsForCurrYear(new Date());
        List<String> demandReasonExcludeList = Arrays.asList("PENALTY_FINES", "ADVANCE");
        String query = "select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I' or p.status = 'W') and p = :property and ptd.egInstallmentMaster = :installment";
        Ptdemand ptDemand = (Ptdemand)((Object)((Session)this.entityManager.unwrap(Session.class)).createQuery("select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I' or p.status = 'W') and p = :property and ptd.egInstallmentMaster = :installment").setEntity("property", (Object)property).setEntity("installment", (Object)currentInstallment).list().get(0));
        for (EgDemandDetails dmdDet : ptDemand.getEgDemandDetails()) {
            demandReason = dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode();
            if (demandReasonExcludeList.contains(demandReason)) continue;
            installment = dmdDet.getEgDemandReason().getEgInstallmentMaster();
            if (installment.equals((Object)currYearInstMap.get("Current 1st Half"))) {
                totalCurrentDemand = totalCurrentDemand.add(dmdDet.getAmount());
                totalCurrentCollection = totalCurrentCollection.add(dmdDet.getAmtCollected());
                firstHalfReasonDemandDetails.put(dmdDet.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dmdDet.getAmount());
                continue;
            }
            if (installment.equals((Object)currYearInstMap.get("Current 2nd Half"))) {
                totalNextInstDemand = totalNextInstDemand.add(dmdDet.getAmount());
                totalNextInstCollection = totalNextInstCollection.add(dmdDet.getAmtCollected());
                secondHalfReasonDemandDetails.put(dmdDet.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dmdDet.getAmount());
                continue;
            }
            totalArrearDemand = totalArrearDemand.add(dmdDet.getAmount());
            totalArrearCollection = totalArrearCollection.add(dmdDet.getAmtCollected());
        }
        arrearDemandDetails.put("ARR_DMD", totalArrearDemand);
        arrearDemandDetails.put("ARR_COLL", totalArrearCollection);
        firstHalfReasonDemandDetails.put("CURR_FIRSTHALF_DMD", totalCurrentDemand);
        firstHalfReasonDemandDetails.put("CURR_FIRSTHALF_COLL", totalCurrentCollection);
        secondHalfReasonDemandDetails.put("CURR_SECONDHALF_DMD", totalNextInstDemand);
        secondHalfReasonDemandDetails.put("CURR_SECONDHALF_COLL", totalNextInstCollection);
        DCBDetails.put("Current 1st Half", firstHalfReasonDemandDetails);
        DCBDetails.put("Current 2nd Half", secondHalfReasonDemandDetails);
        DCBDetails.put("Arrears", arrearDemandDetails);
        LOGGER.debug((Object)("prepareDemandDetForView - demands=" + DCBDetails));
        LOGGER.debug((Object)"Exiting from prepareDemandDetForView");
        return DCBDetails;
    }

    public Map<Date, Property> getPropertiesForPenlatyCalculation(BasicProperty basicProperty) {
        String query = "select p from PropertyImpl p inner join fetch p.basicProperty bp where bp.upicNo = ? and bp.active = true and (p.remarks = null or p.remarks <> ?) order by p.createdDate";
        List allProperties = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select p from PropertyImpl p inner join fetch p.basicProperty bp where bp.upicNo = ? and bp.active = true and (p.remarks = null or p.remarks <> ?) order by p.createdDate").setString(0, basicProperty.getUpicNo()).setString(1, "Migrated from NMC Legacy DB").list();
        new ArrayList();
        List<String> mutationsCodes = Arrays.asList("NEW", "MODIFY");
        Property property = null;
        Property prevProperty = null;
        String mutationCode = null;
        String nextMutationCode = null;
        String prevMutationCode = null;
        int noOfProperties = allProperties.size();
        TreeMap<Date, Property> propertyAndEffectiveDate = new TreeMap<Date, Property>();
        Date firstDataEntryEffectiveDate = null;
        for (int i = 0; i < noOfProperties; ++i) {
            property = (Property)allProperties.get(i);
            prevProperty = i > 0 ? (Property)allProperties.get(i - 1) : null;
            prevMutationCode = prevProperty != null ? prevProperty.getPropertyDetail().getPropertyMutationMaster().getCode() : null;
            mutationCode = property.getPropertyDetail().getPropertyMutationMaster().getCode();
            String string = nextMutationCode = i != noOfProperties - 1 ? ((Property)allProperties.get(i + 1)).getPropertyDetail().getPropertyMutationMaster().getCode() : null;
            if (mutationCode.equalsIgnoreCase("OBJ")) continue;
            if (mutationsCodes.contains(mutationCode)) {
                propertyAndEffectiveDate.put(this.getPropertyOccupancyDate(property), property);
                continue;
            }
            if (this.isFirstDataEntry(prevMutationCode, mutationCode, prevProperty)) {
                firstDataEntryEffectiveDate = this.getPropertyOccupancyDate(property);
            }
            if (!mutationCode.equalsIgnoreCase("DATA_ENTRY") || nextMutationCode != null) continue;
            propertyAndEffectiveDate.put(firstDataEntryEffectiveDate, property);
        }
        TreeMap<Date, Property> propertyByOccupancyDate = new TreeMap<Date, Property>();
        for (Map.Entry entry : propertyAndEffectiveDate.entrySet()) {
            if (entry.getKey() == null) {
                propertyByOccupancyDate.put(this.getPropertyOccupancyDate((Property)entry.getValue()), (Property)entry.getValue());
                continue;
            }
            propertyByOccupancyDate.put((Date)entry.getKey(), (Property)entry.getValue());
        }
        return propertyByOccupancyDate;
    }

    private boolean isFirstDataEntry(String prevPropMutationCode, String mutationCode, Property prevProperty) {
        List<String> mutationCodes = Arrays.asList("NEW", "OBJ");
        if (prevPropMutationCode != null && mutationCodes.contains(prevPropMutationCode) && mutationCode.equalsIgnoreCase("DATA_ENTRY")) {
            return true;
        }
        return prevProperty == null && mutationCode.equalsIgnoreCase("DATA_ENTRY");
    }

    public static boolean afterOrEqual(Date date, Date dateToCompare) {
        return date.after(dateToCompare) || date.equals(dateToCompare);
    }

    public List<DemandNoticeDetailsInfo> getDemandNoticeDetailsInfo(BasicProperty basicProperty, PropertyWiseConsumptions propertyWiseConsumptions) {
        LinkedList<DemandNoticeDetailsInfo> demandNoticeDetailsInfo = new LinkedList<DemandNoticeDetailsInfo>();
        Ptdemand egDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(basicProperty.getProperty());
        Module module = this.moduleService.getModuleByName("Property Tax");
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        List<Object> tempList = new LinkedList();
        tempList = this.getArrearCurrentDemandbyReasonCode(egDemand, module, finYear);
        if (tempList != null && !tempList.isEmpty()) {
            demandNoticeDetailsInfo.addAll(tempList);
        }
        if (propertyWiseConsumptions != null) {
            tempList = new LinkedList();
            tempList = this.getArrearCurrentDemandforWaterTax(propertyWiseConsumptions);
            if (tempList != null && !tempList.isEmpty()) {
                demandNoticeDetailsInfo.addAll(tempList);
            }
        }
        return demandNoticeDetailsInfo;
    }

    private List<DemandNoticeDetailsInfo> getArrearCurrentDemandforWaterTax(PropertyWiseConsumptions propertyWiseConsumptions) {
        LinkedList<DemandNoticeDetailsInfo> demandNoticeDetailsInfo = new LinkedList<DemandNoticeDetailsInfo>();
        String arrearFromDate = "";
        String arrearToDate = "";
        BigDecimal arrearAmount = BigDecimal.ZERO;
        String currentFromDate = "";
        String currentToDate = "";
        BigDecimal currentAmount = BigDecimal.ZERO;
        if (propertyWiseConsumptions.getConsumerConsumptions() != null && propertyWiseConsumptions.getConsumerConsumptions().size() > 0) {
            DemandNoticeDetailsInfo dndi;
            for (ConsumerConsumption cc : propertyWiseConsumptions.getConsumerConsumptions()) {
                if (cc == null) continue;
                if (cc.getArrearDue() != null && cc.getArrearDue().compareTo(BigDecimal.ZERO) > 0) {
                    if (arrearFromDate == "") {
                        arrearFromDate = this.sdf.format(cc.getArrearFromDate().toDate());
                    }
                    arrearToDate = this.sdf.format(cc.getArrearToDate().toDate());
                    arrearAmount = arrearAmount.add(cc.getArrearDue());
                }
                if (cc.getCurrentDue() == null || cc.getCurrentDue().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentFromDate == "") {
                    currentFromDate = this.sdf.format(cc.getCurrentFromDate().toDate());
                }
                currentToDate = this.sdf.format(cc.getCurentToDate().toDate());
                currentAmount = currentAmount.add(cc.getCurrentDue());
            }
            if (arrearFromDate != "") {
                dndi = new DemandNoticeDetailsInfo();
                dndi.setFromDate(arrearFromDate);
                dndi.setToDate(arrearToDate);
                dndi.setWaterTax(arrearAmount);
                demandNoticeDetailsInfo.add(dndi);
            }
            if (currentFromDate != "") {
                dndi = new DemandNoticeDetailsInfo();
                dndi.setFromDate(currentFromDate);
                dndi.setToDate(currentToDate);
                dndi.setWaterTax(currentAmount);
                demandNoticeDetailsInfo.add(dndi);
            }
            return demandNoticeDetailsInfo;
        }
        return demandNoticeDetailsInfo;
    }

    private List<DemandNoticeDetailsInfo> getArrearCurrentDemandbyReasonCode(EgDemand egDemand, Module module, CFinancialYear finYear) {
        DemandNoticeDetailsInfo dndi;
        List list = new LinkedList();
        String arrearFromDate = "";
        String arrearToDate = "";
        BigDecimal arrearAmount = BigDecimal.ZERO;
        BigDecimal pnltyArrearAmount = BigDecimal.ZERO;
        String currentFromDate = "";
        String currentToDate = "";
        Integer instId = null;
        BigDecimal currentAmount = BigDecimal.ZERO;
        BigDecimal pnltyCurrentAmount = BigDecimal.ZERO;
        LinkedList<DemandNoticeDetailsInfo> demandNoticeDetailsInfo = new LinkedList<DemandNoticeDetailsInfo>();
        list = this.demandGenericDAO.getReasonWiseDCB(egDemand, module);
        for (Object record : list) {
            Object[] data = (Object[])record;
            instId = Integer.valueOf(data[5].toString());
            Installment installment = this.installmentDao.findById(instId.intValue(), false);
            if (installment.getFromDate().compareTo(finYear.getStartingDate()) < 0) {
                if (arrearFromDate == "") {
                    arrearFromDate = this.sdf.format(installment.getFromDate());
                }
                arrearToDate = this.sdf.format(installment.getToDate());
                if (!data[0].toString().equalsIgnoreCase("PENALTY_FINES")) {
                    arrearAmount = arrearAmount.add(new BigDecimal(data[2].toString()));
                    continue;
                }
                pnltyArrearAmount = pnltyArrearAmount.add(new BigDecimal(data[2].toString()));
                continue;
            }
            if (currentFromDate == "") {
                currentFromDate = this.sdf.format(installment.getFromDate());
            }
            currentToDate = this.sdf.format(installment.getToDate());
            if (!data[0].toString().equalsIgnoreCase("PENALTY_FINES")) {
                currentAmount = currentAmount.add(new BigDecimal(data[2].toString()));
                continue;
            }
            pnltyCurrentAmount = pnltyCurrentAmount.add(new BigDecimal(data[2].toString()));
        }
        if (arrearFromDate != "") {
            dndi = new DemandNoticeDetailsInfo();
            dndi.setFromDate(arrearFromDate);
            dndi.setToDate(arrearToDate);
            dndi.setPropertyTax(arrearAmount);
            dndi.setPenalty(pnltyArrearAmount);
            demandNoticeDetailsInfo.add(dndi);
        }
        if (currentFromDate != "") {
            dndi = new DemandNoticeDetailsInfo();
            dndi.setFromDate(currentFromDate);
            dndi.setToDate(currentToDate);
            dndi.setPropertyTax(currentAmount);
            dndi.setPenalty(pnltyCurrentAmount);
            demandNoticeDetailsInfo.add(dndi);
        }
        return demandNoticeDetailsInfo;
    }

    public DepreciationMaster getDepreciationByDate(Date constructionDate, Date effectiveDate) {
        String depreciationYear = null;
        int years = DateUtils.noOfYears((Date)constructionDate, (Date)effectiveDate);
        depreciationYear = years >= 0 && years <= 25 ? "0-25" : (years > 25 && years <= 40 ? "26-40" : "Above 40");
        return (DepreciationMaster)this.persistenceService.getSession().createQuery("from DepreciationMaster where depreciationName = :depreName").setString("depreName", depreciationYear).uniqueResult();
    }

    public List<InstrumentType> prepareInstrumentTypeList() {
        return this.persistenceService.findAllBy("from InstrumentType order by type", new Object[0]);
    }

    public Boolean isCorporation() {
        Boolean isCorporation = Boolean.FALSE;
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "IS_CORPORATION");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            isCorporation = Boolean.valueOf(((AppConfigValues)appConfigValue.get(0)).getValue());
        }
        return isCorporation;
    }

    public Boolean isSeaShoreULB() {
        Boolean isSeaShoreULB = Boolean.FALSE;
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "IS_SEASHORE_ULB");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            isSeaShoreULB = Boolean.valueOf(((AppConfigValues)appConfigValue.get(0)).getValue());
        }
        return isSeaShoreULB;
    }

    public Boolean isPrimaryServiceApplicable() {
        Boolean isCorporation = Boolean.FALSE;
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "IS_PRIMARYSERVICECHARGES_APPLICABLE");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            isCorporation = Boolean.valueOf(((AppConfigValues)appConfigValue.get(0)).getValue());
        }
        return isCorporation;
    }

    public String getRolesForUserId(Long userId) {
        LOGGER.debug((Object)("Entered into method getRolesForUserId " + userId));
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        LOGGER.debug((Object)("Exit from method getRolesForUserId with return value : " + ((Object)roleNameList).toString().toUpperCase()));
        return ((Object)roleNameList).toString().toUpperCase();
    }

    public String generateUserName(String name) {
        StringBuilder userNameBuilder = new StringBuilder();
        String userName = "";
        userName = name.length() < 6 ? String.format("%-6s", name).replace(' ', '0') : name.substring(0, 6).replace(' ', '0');
        userNameBuilder.append(userName).append(RandomStringUtils.randomNumeric((int)4));
        return userNameBuilder.toString();
    }

    public PropertyWiseConsumptions getPropertyWiseConsumptions(String basicPropertyId) {
        PropertyWiseConsumptions propertyWiseConsumptions = this.waterChargesIntegrationService.getPropertyWiseConsumptionsForWaterCharges(basicPropertyId);
        return propertyWiseConsumptions;
    }

    public Properties loadTaxRates() {
        Properties taxRates = new Properties();
        String s = this.appConfigValuesService.getAppConfigValueByDate("Property Tax", "PT_TAXRATES", new Date()).getValue();
        StringReader sr = new StringReader(s);
        try {
            taxRates.load(sr);
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Could not decipher Tax rates from string" + s, (Throwable)e);
        }
        sr.close();
        return taxRates;
    }

    public Query prepareQueryforCollectionSummaryReport(String fromDate, String toDate, String collMode, String transMode, String mode, String boundaryId, String propTypeCategoryId, Long zoneId, Long wardId, Long blockId) {
        String srchQryStr = "";
        String baseQry = "";
        String orderbyQry = "";
        String ZONEWISE = "zoneWise";
        String WARDWISE = "wardWise";
        String BLOCKWISE = "blockWise";
        String LOCALITYWISE = "localityWise";
        String USAGEWISE = "usageWise";
        new ArrayList();
        try {
            baseQry = "select cs from CollectionSummary cs where ";
            if (fromDate != null && !fromDate.equals("DD/MM/YYYY") && !fromDate.equals("")) {
                srchQryStr = "(cast(cs.receiptDate as date)) >= to_date('" + fromDate + "', 'DD/MM/YYYY') ";
            }
            if (toDate != null && !toDate.equals("DD/MM/YYYY") && !toDate.equals("")) {
                srchQryStr = srchQryStr + "and (cast(cs.receiptDate as date)) <= to_date('" + toDate + "', 'DD/MM/YYYY') ";
            }
            if (collMode != null && !collMode.equals("") && !collMode.equals("-1")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Collection Mode = " + collMode));
                }
                srchQryStr = srchQryStr + "and cs.collectionType ='" + collMode + "' ";
            }
            if (transMode != null && !transMode.equals("") && !transMode.equals("-1")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Transaction Mode = " + transMode));
                }
                srchQryStr = srchQryStr + "and (cs.paymentMode ='" + transMode + "' OR cs.paymentMode like '%' || '" + transMode + "' || '%')";
            }
            if (mode.equals("usageWise")) {
                if (propTypeCategoryId != null && !propTypeCategoryId.equals("") && !propTypeCategoryId.equals("-1")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Transaction Mode = " + transMode));
                    }
                    srchQryStr = srchQryStr + "and cs.property.propertyDetail in (select floor.propertyDetail from Floor floor where floor.propertyUsage = '" + propTypeCategoryId + "')) ";
                }
                if (zoneId != null && !zoneId.equals("") && zoneId != -1L) {
                    srchQryStr = srchQryStr + " and cs.zoneId.id =" + zoneId;
                }
                if (wardId != null && !wardId.equals("") && wardId != -1L) {
                    srchQryStr = srchQryStr + " and cs.wardId.id =" + wardId;
                }
                if (blockId != null && !blockId.equals("") && blockId != -1L) {
                    srchQryStr = srchQryStr + " and cs.areaId.id =" + blockId;
                }
                orderbyQry = "order by cs.property.propertyDetail.categoryType";
            }
            if (mode.equals("zoneWise")) {
                if (boundaryId != null && !boundaryId.equals("") && !boundaryId.equals("-1")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("zoneNo = " + boundaryId));
                    }
                    srchQryStr = srchQryStr + "and cs.zoneId.id =" + boundaryId;
                }
                orderbyQry = " and cs.zoneId.boundaryType.name = 'Zone' order by cs.zoneId.boundaryNum";
            } else if (mode.equals("wardWise")) {
                if (boundaryId != null && !boundaryId.equals("") && !boundaryId.equals("-1")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("wardNo = " + boundaryId));
                    }
                    srchQryStr = srchQryStr + "and cs.wardId.id =" + boundaryId;
                }
                orderbyQry = " and cs.wardId.boundaryType.name = 'Ward' order by cs.wardId.boundaryNum";
            } else if (mode.equals("blockWise")) {
                if (boundaryId != null && !boundaryId.equals("") && !boundaryId.equals("-1")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("blockNo = " + boundaryId));
                    }
                    srchQryStr = srchQryStr + "and cs.areaId.id =" + boundaryId;
                }
                orderbyQry = " and cs.areaId.boundaryType.name = 'Block' order by cs.areaId.boundaryNum";
            } else if (mode.equals("localityWise")) {
                if (boundaryId != null && !boundaryId.equals("") && !boundaryId.equals("-1")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("localityNo = " + boundaryId));
                    }
                    srchQryStr = srchQryStr + "and cs.localityId.id =" + boundaryId;
                }
                orderbyQry = "  order by cs.localityId.boundaryNum";
            }
            srchQryStr = baseQry + srchQryStr + orderbyQry;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occured in Class : CollectionSummaryReportAction  Method : list", (Throwable)e);
            throw new ApplicationRuntimeException("Error occured in Class : CollectionSummaryReportAction  Method : list " + e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from prepareQueryforCollectionSummaryReport method");
        }
        Query qry = this.persistenceService.getSession().createQuery(srchQryStr.toString());
        return qry;
    }

    public List<PropertyMaterlizeView> prepareQueryforArrearRegisterReport(Long zoneId, Long wardId, Long areaId, Long localityId) {
        Installment currentInst = this.propertyTaxCommonUtils.getCurrentInstallment();
        StringBuffer query = new StringBuffer(300);
        query.append("select distinct pmv from PropertyMaterlizeView pmv,InstDmdCollMaterializeView idc where pmv.basicPropertyID = idc.propMatView.basicPropertyID and pmv.isActive = true and idc.installment.fromDate not between  ('" + currentInst.getFromDate() + "') and ('" + currentInst.getToDate() + "') ");
        if (localityId != null && localityId != -1L) {
            query.append(" and pmv.locality.id= :localityId ");
        }
        if (zoneId != null && zoneId != -1L) {
            query.append(" and pmv.zone.id= :zoneId ");
        }
        if (wardId != null && wardId != -1L) {
            query.append("  and pmv.ward.id= :wardId ");
        }
        if (areaId != null && areaId != -1L) {
            query.append("  and pmv.block.id= :areaId ");
        }
        query.append(" order by pmv.basicPropertyID ");
        Query qry = this.persistenceService.getSession().createQuery(query.toString());
        if (localityId != null && localityId != -1L) {
            qry.setParameter("localityId", (Object)localityId);
        }
        if (zoneId != null && zoneId != -1L) {
            qry.setParameter("zoneId", (Object)zoneId);
        }
        if (wardId != null && wardId != -1L) {
            qry.setParameter("wardId", (Object)wardId);
        }
        if (areaId != null && areaId != -1L) {
            qry.setParameter("areaId", (Object)areaId);
        }
        List propertyViewList = qry.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY).list();
        return propertyViewList;
    }

    public Query prepareQueryforTitleTransferReport(Long zoneId, Long wardId, Long areaId, String fromDate, String toDate) {
        StringBuffer query = new StringBuffer(300);
        new PropertyMutation();
        String boundaryCond = "";
        String boundaryWhrCond = "";
        if (zoneId != null && zoneId != -1L) {
            boundaryCond = " and pi.zone.id= " + zoneId;
        }
        if (wardId != null && wardId != -1L) {
            boundaryCond = boundaryCond + " and pi.ward.id= " + wardId;
        }
        if (areaId != null && areaId != -1L) {
            boundaryCond = boundaryCond + " and pi.area.id= " + areaId;
        }
        boundaryWhrCond = boundaryCond != "" ? ",PropertyID pi where pm.basicProperty.id=pi.basicProperty.id  and pm.state.value in ('Commissioner Approved','Closed') " : " where pm.state.value in ('Commissioner Approved','Closed') ";
        query.append("select pm from PropertyMutation pm").append(boundaryWhrCond).append(boundaryCond);
        if (fromDate != null && !fromDate.isEmpty()) {
            if (toDate != null && !toDate.isEmpty()) {
                query.append(" and (cast(pm.createdDate as date)) between to_date('" + fromDate + "', 'DD/MM/YYYY') and to_date('" + toDate + "','DD/MM/YYYY') ");
            } else {
                query.append(" and (cast(pm.createdDate as date)) between to_date('" + fromDate + "', 'DD/MM/YYYY') and to_date('" + this.sdf.format(new Date()) + "','DD/MM/YYYY')  ");
            }
        }
        query.append(" order by pm.basicProperty.id,pm.mutationDate ");
        Query qry = this.persistenceService.getSession().createQuery(query.toString());
        return qry;
    }

    public BigDecimal getPropertyTaxDetails(Long basicPropId, CFinancialYear finyear) {
        List list = new ArrayList();
        String selectQuery = " select sum(amount) as amount from ( select distinct inst.description,dd.amount as amount from egpt_basic_property bp, egpt_property prop,  egpt_ptdemand ptd, eg_demand d,  eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst  where bp.id = prop.id_basic_property and prop.status = 'A'  and prop.id = ptd.id_property and ptd.id_demand = d.id  and d.id = dd.id_demand  and dd.id_demand_reason = dr.id and drm.id = dr.id_demand_reason_master  and dr.id_installment = inst.id and bp.id =:basicPropId  and inst.start_date between '" + finyear.getStartingDate() + "' and '" + finyear.getEndingDate() + "' and drm.code = '" + "GEN_TAX" + "') as genTaxDtls";
        Query qry = this.persistenceService.getSession().createSQLQuery(selectQuery).setLong("basicPropId", basicPropId.longValue());
        list = qry.list();
        return null != list && !list.contains(null) ? new BigDecimal((Double)list.get(0)) : null;
    }

    public Map<String, BigDecimal> prepareDemandDetForWorkflowProperty(Property property, Installment dmdInstallment, Installment dmdDetInstallment) {
        LOGGER.debug((Object)("Entered into prepareDemandDetForWorkflowProperty, property=" + property));
        HashMap<String, BigDecimal> DCBDetails = new HashMap<String, BigDecimal>();
        String demandReason = "";
        Installment installment = null;
        BigDecimal totalCurrentDemand = BigDecimal.ZERO;
        BigDecimal totalCurrentCollection = BigDecimal.ZERO;
        List<String> demandReasonExcludeList = Arrays.asList("PENALTY_FINES", "ADVANCE");
        String query = "select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'W' or p.status = 'I' or p.status = 'A') and p = :property and ptd.egInstallmentMaster = :installment";
        Ptdemand ptDemand = (Ptdemand)((Object)((Session)this.entityManager.unwrap(Session.class)).createQuery("select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'W' or p.status = 'I' or p.status = 'A') and p = :property and ptd.egInstallmentMaster = :installment").setEntity("property", (Object)property).setEntity("installment", (Object)dmdInstallment).list().get(0));
        for (EgDemandDetails dmdDet : ptDemand.getEgDemandDetails()) {
            demandReason = dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode();
            if (demandReasonExcludeList.contains(demandReason) || !(installment = dmdDet.getEgDemandReason().getEgInstallmentMaster()).equals((Object)dmdDetInstallment)) continue;
            totalCurrentDemand = totalCurrentDemand.add(dmdDet.getAmount());
            totalCurrentCollection = totalCurrentCollection.add(dmdDet.getAmtCollected());
            DCBDetails.put(dmdDet.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dmdDet.getAmount());
        }
        LOGGER.debug((Object)("prepareDemandDetForWorkflowProperty - demands=" + DCBDetails));
        LOGGER.debug((Object)"Exiting from prepareDemandDetForWorkflowProperty");
        return DCBDetails;
    }

    public String getApproverUserName(Long approvalPosition) {
        Position approverPosition = null;
        User approverUser = null;
        if (approvalPosition != null) {
            approverPosition = this.positionMasterService.getPositionById(approvalPosition);
            approverUser = this.eisCommonService.getUserForPosition(approvalPosition, new Date());
        }
        return approverUser != null ? approverUser.getName().concat("~").concat(approverPosition.getName()) : "";
    }

    public boolean enableVacancyRemission(String upicNo) {
        boolean vrFlag = false;
        List remissionList = this.persistenceService.findAllBy("select vr from VacancyRemission vr where vr.basicProperty.upicNo=? order by id desc", new Object[]{upicNo});
        if (remissionList.isEmpty()) {
            vrFlag = true;
        } else {
            VacancyRemission vacancyRemission = (VacancyRemission)((Object)remissionList.get(remissionList.size() - 1));
            if (vacancyRemission != null) {
                if (vacancyRemission.getStatus().equalsIgnoreCase("APPROVED")) {
                    if (DateUtils.isSameDay((Date)vacancyRemission.getVacancyToDate(), (Date)new Date())) {
                        vrFlag = true;
                    } else if (vacancyRemission.getVacancyToDate().compareTo(new Date()) < 0) {
                        vrFlag = true;
                    }
                } else if (vacancyRemission.getStatus().equalsIgnoreCase("Rejection Acknowledgement Generated")) {
                    vrFlag = true;
                }
            }
        }
        return vrFlag;
    }

    public boolean enableMonthlyUpdate(String upicNo) {
        boolean monthlyUpdateFlag = false;
        VacancyRemission vacancyRemission = (VacancyRemission)((Object)this.persistenceService.find("select vr from VacancyRemission vr where vr.basicProperty.upicNo=? and vr.status = 'APPROVED'", new Object[]{upicNo}));
        if (vacancyRemission != null) {
            if (vacancyRemission.getVacancyRemissionDetails().isEmpty()) {
                monthlyUpdateFlag = true;
            } else {
                VacancyRemissionDetails vrd = vacancyRemission.getVacancyRemissionDetails().get(vacancyRemission.getVacancyRemissionDetails().size() - 1);
                int noOfMonths = DateUtils.noOfMonths((Date)vrd.getCheckinDate(), (Date)new Date());
                if (noOfMonths != 0) {
                    monthlyUpdateFlag = true;
                }
            }
        }
        return monthlyUpdateFlag;
    }

    public boolean enableVRApproval(String upicNo) {
        int detailsSize;
        boolean vrApprovalFlag = false;
        VacancyRemission vacancyRemission = (VacancyRemission)((Object)this.persistenceService.find("select vr from VacancyRemission vr where vr.basicProperty.upicNo=? and vr.status = 'APPROVED'", new Object[]{upicNo}));
        if (vacancyRemission != null && !vacancyRemission.getVacancyRemissionDetails().isEmpty() && (detailsSize = vacancyRemission.getVacancyRemissionDetails().size()) % 5 == 0) {
            vrApprovalFlag = true;
        }
        return vrApprovalFlag;
    }

    public boolean checkForParentUsedInBifurcation(String upicNo) {
        boolean isChildUnderWorkflow = false;
        PropertyStatusValues statusValues = (PropertyStatusValues)((Object)this.persistenceService.find("select psv from PropertyStatusValues psv where psv.referenceBasicProperty.upicNo=? and psv.basicProperty.underWorkflow = 't' ", new Object[]{upicNo}));
        if (statusValues != null) {
            isChildUnderWorkflow = true;
        }
        return isChildUnderWorkflow;
    }

    public Date getLowestInstallmentForProperty(Property property) {
        String query = "select demandDetails.egDemandReason from Ptdemand ptd,EgDemandDetails demandDetails where ptd.egptProperty = :property  and ptd.id = demandDetails.egDemand.id ";
        List egDemandReason = this.persistenceService.getSession().createQuery("select demandDetails.egDemandReason from Ptdemand ptd,EgDemandDetails demandDetails where ptd.egptProperty = :property  and ptd.id = demandDetails.egDemand.id ".toString()).setEntity("property", (Object)property).list();
        return null != egDemandReason && !egDemandReason.isEmpty() ? ((EgDemandReason)egDemandReason.get(0)).getEgInstallmentMaster().getFromDate() : null;
    }

    public boolean checkIsNagarPanchayat() {
        String grade = (String)this.persistenceService.findAllBy("select grade from City", new Object[0]).get(0);
        return "NP".equalsIgnoreCase(grade);
    }

    public Query prepareQueryforDefaultersReport(Long wardId, String fromDemand, String toDemand, Integer limit, String ownerShipType) {
        StringBuffer query = new StringBuffer(300);
        query.append("select pmv from PropertyMaterlizeView pmv where pmv.propertyId is not null and pmv.isActive = true and pmv.isExempted=false ");
        String arrearBalanceCond = " ((pmv.aggrArrDmd - pmv.aggrArrColl) + ((pmv.aggrCurrFirstHalfDmd + pmv.aggrCurrSecondHalfDmd) - (pmv.aggrCurrFirstHalfColl + pmv.aggrCurrSecondHalfColl))) ";
        String arrearBalanceNotZeroCond = " and ((pmv.aggrArrDmd - pmv.aggrArrColl) + ((pmv.aggrCurrFirstHalfDmd + pmv.aggrCurrSecondHalfDmd) - (pmv.aggrCurrFirstHalfColl + pmv.aggrCurrSecondHalfColl)))!=0 ";
        String orderByClause = " order by ";
        query.append(arrearBalanceNotZeroCond);
        if (StringUtils.isNotBlank((CharSequence)fromDemand) && StringUtils.isBlank((CharSequence)toDemand)) {
            query.append(" and " + arrearBalanceCond + " >= ").append(fromDemand);
        } else if (StringUtils.isNotBlank((CharSequence)fromDemand) && StringUtils.isNotBlank((CharSequence)toDemand)) {
            query.append(" and " + arrearBalanceCond + " >= ").append(fromDemand);
            query.append(" and " + arrearBalanceCond + " <= ").append(toDemand);
        }
        if (wardId != null && wardId != -1L) {
            query.append(" and pmv.ward.id = ").append(wardId);
        }
        if (StringUtils.isNotBlank((CharSequence)ownerShipType)) {
            if (ownerShipType.equals("PRIVATE")) {
                query.append(" and (pmv.propTypeMstrID.code = '" + ownerShipType + "' or pmv.propTypeMstrID.code = 'EWSHS') and cast(pmv.propertyId as integer) not in (select propertyId from PropertyCourtCase) ");
            } else if (ownerShipType.equals("STATE_GOVT")) {
                query.append(" and (pmv.propTypeMstrID.code = '" + ownerShipType + "') and  cast(pmv.propertyId as integer) not in (select propertyId from PropertyCourtCase) ");
            } else if (ownerShipType.equals("CENTRAL_GOVT")) {
                query.append(" and (pmv.propTypeMstrID.code like  '" + ownerShipType + "%') and cast(pmv.propertyId as integer) not in (select propertyId from PropertyCourtCase) ");
            } else if (ownerShipType.equals("COURT_CASE")) {
                query.append(" and cast(pmv.propertyId as integer) in (select propertyId from PropertyCourtCase)");
            }
        }
        orderByClause = orderByClause.concat(arrearBalanceCond + " desc, pmv.ward.id asc ");
        query.append(orderByClause);
        Query qry = this.persistenceService.getSession().createQuery(query.toString());
        if (limit != null && limit != -1) {
            qry.setMaxResults(limit.intValue());
        }
        return qry;
    }

    public List<Installment> getInstallments(PropertyImpl property) {
        Ptdemand egDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        List installments = this.persistenceService.findAllBy("select distinct(dd.egDemandReason.egInstallmentMaster) from EgDemandDetails dd where dd.egDemand = ? order by dd.egDemandReason.egInstallmentMaster.fromDate", new Object[]{egDemand});
        return installments;
    }

    public Map<String, Installment> getInstallmentsForCurrYear(Date currDate) {
        HashMap<String, Installment> currYearInstMap = new HashMap<String, Installment>();
        String query = "select installment from Installment installment,CFinancialYear finYear where installment.module.name = 'Property Tax'  and (cast(:currDate as date)) between finYear.startingDate and finYear.endingDate  and cast(installment.fromDate as date) >= cast(finYear.startingDate as date) and cast(installment.toDate as date) <= cast(finYear.endingDate as date) order by installment.id ";
        Query qry = this.persistenceService.getSession().createQuery("select installment from Installment installment,CFinancialYear finYear where installment.module.name = 'Property Tax'  and (cast(:currDate as date)) between finYear.startingDate and finYear.endingDate  and cast(installment.fromDate as date) >= cast(finYear.startingDate as date) and cast(installment.toDate as date) <= cast(finYear.endingDate as date) order by installment.id ".toString());
        qry.setDate("currDate", currDate);
        List installments = qry.list();
        currYearInstMap.put("Current 1st Half", (Installment)installments.get(0));
        currYearInstMap.put("Current 2nd Half", (Installment)installments.get(1));
        return currYearInstMap;
    }

    public boolean isRebatePeriodActive() {
        boolean isActive = false;
        Date today = new Date();
        RebatePeriod rebatePeriod = this.rebatePeriodService.getRebateForCurrInstallment(this.propertyTaxCommonUtils.getCurrentInstallment().getId());
        if (rebatePeriod != null && today.before(rebatePeriod.getRebateDate())) {
            isActive = true;
        }
        return isActive;
    }

    public Date getEffectiveDateForProperty() {
        Module module = this.moduleDao.getModuleByName("Property Tax");
        Date currInstToDate = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date()).getToDate();
        Date dateBefore6Installments = new Date();
        dateBefore6Installments.setDate(1);
        dateBefore6Installments.setMonth(currInstToDate.getMonth() + 1);
        dateBefore6Installments.setYear(currInstToDate.getYear() - 3);
        return dateBefore6Installments;
    }

    public Map<String, BigDecimal> getTaxDetailsForInstallment(Property property, Installment effectiveInstallment, Installment demandInstallment) {
        HashMap<String, BigDecimal> taxDetailsMap = new HashMap<String, BigDecimal>();
        String query = "select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I' or p.status = 'W') and p = :property and ptd.egInstallmentMaster = :demandInstallment ";
        Ptdemand ptDemand = (Ptdemand)((Object)((Session)this.entityManager.unwrap(Session.class)).createQuery("select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I' or p.status = 'W') and p = :property and ptd.egInstallmentMaster = :demandInstallment ").setEntity("property", (Object)property).setEntity("demandInstallment", (Object)demandInstallment).list().get(0));
        for (EgDemandDetails dmdDet : ptDemand.getEgDemandDetails()) {
            if (!dmdDet.getInstallmentStartDate().equals(effectiveInstallment.getFromDate()) || dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES") || dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ADVANCE")) continue;
            taxDetailsMap.put(dmdDet.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dmdDet.getAmount());
        }
        return taxDetailsMap;
    }

    public List<Installment> getInstallmentsListByEffectiveDate(Date effectiveDate) {
        Installment effectiveInstallment = this.getPTInstallmentForDate(effectiveDate);
        String query = "";
        List<Object> installmentList = new ArrayList<Installment>();
        Map<String, Installment> installmentMap = this.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = installmentMap.get("Current 1st Half");
        Installment installmentSecondHalf = installmentMap.get("Current 2nd Half");
        if (!effectiveInstallment.equals((Object)installmentFirstHalf) && !effectiveInstallment.equals((Object)installmentSecondHalf) && effectiveDate.before(installmentFirstHalf.getFromDate())) {
            query = "select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate between :startdate and :enddate order by inst.fromDate";
            installmentList = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setParameter("startdate", (Object)effectiveInstallment.getFromDate()).setParameter("enddate", (Object)installmentSecondHalf.getFromDate()).list();
        } else if (effectiveInstallment.equals((Object)installmentFirstHalf)) {
            installmentList.add(installmentFirstHalf);
            installmentList.add(installmentSecondHalf);
        } else if (effectiveInstallment.equals((Object)installmentSecondHalf)) {
            installmentList.add(installmentSecondHalf);
        } else if (effectiveDate.after(installmentSecondHalf.getToDate())) {
            query = "select inst from Installment inst where inst.module.name = 'Property Tax' and exists (select inst2.finYearRange from Installment inst2 where inst.finYearRange = inst2.finYearRange and inst2.module.name = 'Property Tax' and inst2.fromDate = :startdate ) order by inst.fromDate";
            installmentList = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setParameter("startdate", (Object)effectiveInstallment.getFromDate()).list();
        }
        return installmentList;
    }
}

