/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.service.calculator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.model.EgDemandReasonDetails;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.handler.TaxCalculationInfoXmlHandler;
import org.egov.ptis.client.model.calculator.APMiscellaneousTax;
import org.egov.ptis.client.model.calculator.APTaxCalculationInfo;
import org.egov.ptis.client.model.calculator.APUnitTaxCalculationInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BoundaryCategory;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.egov.ptis.domain.service.calculator.PropertyTaxCalculator;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class APTaxCalculator
implements PropertyTaxCalculator {
    private static final Logger LOGGER = Logger.getLogger(APTaxCalculator.class);
    private static BigDecimal RESD_OWNER_DEPRECIATION = new BigDecimal(40);
    private static BigDecimal SEASHORE_RESD_OWNER_DEPRECIATION = new BigDecimal(45);
    private BigDecimal BUIULDING_VALUE = new BigDecimal(2).divide(new BigDecimal(3), 5, 4);
    private BigDecimal SITE_VALUE = new BigDecimal(1).divide(new BigDecimal(3), 5, 4);
    private BigDecimal totalTaxPayable = BigDecimal.ZERO;
    private Boolean isCorporation = Boolean.FALSE;
    private Boolean isSeaShoreULB = Boolean.FALSE;
    private Boolean isPrimaryServiceChrApplicable = Boolean.FALSE;
    private String unAuthDeviationPerc = "";
    private HashMap<Installment, TaxCalculationInfo> taxCalculationMap = new HashMap();
    private Properties taxRateProps = null;
    private Installment currInstallment = null;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private InstallmentHibDao installmentDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @Override
    public HashMap<Installment, TaxCalculationInfo> calculatePropertyTax(Property property, Date occupationDate) throws TaxCalculatorExeption {
        Boundary propertyZone = null;
        BigDecimal totalNetArv = BigDecimal.ZERO;
        BoundaryCategory boundaryCategory = null;
        this.taxRateProps = this.propertyTaxUtil.loadTaxRates();
        this.isCorporation = this.propertyTaxUtil.isCorporation();
        this.isSeaShoreULB = this.propertyTaxUtil.isSeaShoreULB();
        this.currInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        if (this.isCorporation.booleanValue()) {
            this.isPrimaryServiceChrApplicable = this.propertyTaxUtil.isPrimaryServiceApplicable();
        }
        List<String> applicableTaxes = this.prepareApplicableTaxes(property);
        List<Installment> taxInstallments = this.propertyTaxUtil.getInstallmentsListByEffectiveDate(occupationDate);
        propertyZone = property.getBasicProperty().getPropertyID().getZone();
        for (Installment installment : taxInstallments) {
            this.totalTaxPayable = BigDecimal.ZERO;
            totalNetArv = BigDecimal.ZERO;
            APTaxCalculationInfo taxCalculationInfo = this.addPropertyInfo(property);
            if (!this.betweenOrBefore(occupationDate, installment.getFromDate(), installment.getToDate()).booleanValue()) continue;
            if (property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND") || property.getPropertyDetail().isAppurtenantLandChecked() != null && property.getPropertyDetail().isAppurtenantLandChecked().booleanValue()) {
                APUnitTaxCalculationInfo unitTaxCalculationInfo = this.calculateVacantLandTax(property, occupationDate, applicableTaxes, installment);
                totalNetArv = totalNetArv.add(unitTaxCalculationInfo.getNetARV());
                taxCalculationInfo.addUnitTaxCalculationInfo(unitTaxCalculationInfo);
                this.totalTaxPayable = this.totalTaxPayable.add(unitTaxCalculationInfo.getTotalTaxPayable());
            }
            for (Floor floorIF : property.getPropertyDetail().getFloorDetails()) {
                if (!this.betweenOrBefore(floorIF.getOccupancyDate(), installment.getFromDate(), installment.getToDate()).booleanValue()) continue;
                boundaryCategory = this.getBoundaryCategory(propertyZone, installment, floorIF.getPropertyUsage().getId(), occupationDate, floorIF.getStructureClassification().getId());
                APUnitTaxCalculationInfo unitTaxCalculationInfo = this.calculateNonVacantTax(property, floorIF, boundaryCategory, applicableTaxes, installment);
                totalNetArv = totalNetArv.add(unitTaxCalculationInfo.getNetARV());
                this.totalTaxPayable = this.totalTaxPayable.add(unitTaxCalculationInfo.getTotalTaxPayable());
                taxCalculationInfo.addUnitTaxCalculationInfo(unitTaxCalculationInfo);
            }
            taxCalculationInfo.setTotalNetARV(totalNetArv);
            taxCalculationInfo.setTotalTaxPayable(this.totalTaxPayable);
            taxCalculationInfo.setTaxCalculationInfoXML(this.generateTaxCalculationXML(taxCalculationInfo));
            this.taxCalculationMap.put(installment, taxCalculationInfo);
        }
        return this.taxCalculationMap;
    }

    private APUnitTaxCalculationInfo calculateNonVacantTax(Property property, Floor floor, BoundaryCategory boundaryCategory, List<String> applicableTaxes, Installment installment) {
        APUnitTaxCalculationInfo unitTaxCalculationInfo = new APUnitTaxCalculationInfo();
        BigDecimal builtUpArea = BigDecimal.ZERO;
        BigDecimal floorMrv = BigDecimal.ZERO;
        BigDecimal floorBuildingValue = BigDecimal.ZERO;
        BigDecimal floorSiteValue = BigDecimal.ZERO;
        BigDecimal floorGrossArv = BigDecimal.ZERO;
        BigDecimal floorDepreciation = BigDecimal.ZERO;
        BigDecimal floorNetArv = BigDecimal.ZERO;
        builtUpArea = BigDecimal.valueOf(floor.getBuiltUpArea().getArea().floatValue());
        floorMrv = this.calculateFloorMrv(builtUpArea, boundaryCategory);
        floorBuildingValue = this.calculateFloorBuildingValue(floorMrv);
        floorSiteValue = this.calculateFloorSiteValue(floorMrv);
        floorGrossArv = floorBuildingValue.multiply(new BigDecimal(12));
        floorDepreciation = this.calculateFloorDepreciation(floorGrossArv, floor);
        floorNetArv = floorSiteValue.multiply(new BigDecimal(12)).add(floorGrossArv.subtract(floorDepreciation));
        unitTaxCalculationInfo.setFloorNumber(PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()));
        unitTaxCalculationInfo.setFloorArea(builtUpArea);
        unitTaxCalculationInfo.setBaseRateEffectiveDate(boundaryCategory.getFromDate());
        unitTaxCalculationInfo.setBaseRate(BigDecimal.valueOf(boundaryCategory.getCategory().getCategoryAmount()));
        unitTaxCalculationInfo.setMrv(floorMrv);
        unitTaxCalculationInfo.setBuildingValue(floorBuildingValue);
        unitTaxCalculationInfo.setSiteValue(floorSiteValue);
        unitTaxCalculationInfo.setGrossARV(floorGrossArv);
        unitTaxCalculationInfo.setDepreciation(floorDepreciation);
        unitTaxCalculationInfo.setUnitUsage(floor.getPropertyUsage().getUsageCode());
        unitTaxCalculationInfo.setUnitOccupation(floor.getPropertyOccupation().getOccupancyCode());
        unitTaxCalculationInfo.setUnitStructure(floor.getStructureClassification().getConstrTypeCode());
        unitTaxCalculationInfo.setNetARV(floorNetArv.setScale(0, 4));
        BigDecimal unAuthDeviationPerc = this.getUnAuthDeviationPerc(floor);
        this.calculateApplicableTaxes(applicableTaxes, unitTaxCalculationInfo, installment, property.getPropertyDetail().getPropertyTypeMaster().getCode(), floor, unAuthDeviationPerc);
        return unitTaxCalculationInfo;
    }

    private APTaxCalculationInfo addPropertyInfo(Property property) {
        APTaxCalculationInfo taxCalculationInfo = new APTaxCalculationInfo();
        PropertyID propertyId = property.getBasicProperty().getPropertyID();
        taxCalculationInfo.setPropertyOwnerName(property.getBasicProperty().getFullOwnerName());
        taxCalculationInfo.setPropertyAddress(property.getBasicProperty().getAddress().toString());
        taxCalculationInfo.setHouseNumber(property.getBasicProperty().getAddress().getHouseNoBldgApt());
        taxCalculationInfo.setZone(propertyId.getZone().getName());
        taxCalculationInfo.setWard(propertyId.getWard().getName());
        taxCalculationInfo.setBlock(propertyId.getArea() != null ? propertyId.getArea().getName() : "");
        taxCalculationInfo.setLocality(property.getBasicProperty().getPropertyID().getLocality().getName());
        if (property.getPropertyDetail().getSitalArea().getArea() != null) {
            taxCalculationInfo.setPropertyArea(new BigDecimal(property.getPropertyDetail().getSitalArea().getArea().toString()));
        }
        taxCalculationInfo.setPropertyType(property.getPropertyDetail().getPropertyTypeMaster().getType());
        taxCalculationInfo.setPropertyId(property.getBasicProperty().getUpicNo());
        return taxCalculationInfo;
    }

    public APUnitTaxCalculationInfo calculateApplicableTaxes(List<String> applicableTaxes, APUnitTaxCalculationInfo unitTaxCalculationInfo, Installment installment, String propTypeCode, Floor floor, BigDecimal unAuthDeviationPerc) {
        BigDecimal totalHalfTaxPayable = BigDecimal.ZERO;
        BigDecimal alv = unitTaxCalculationInfo.getNetARV();
        BigDecimal generalTax = BigDecimal.ZERO;
        BigDecimal educationTax = BigDecimal.ZERO;
        BigDecimal halfYearHeadTax = BigDecimal.ZERO;
        BigDecimal taxRatePerc = BigDecimal.ZERO;
        LOGGER.debug((Object)("calculateApplicableTaxes - ALV: " + alv));
        LOGGER.debug((Object)("calculateApplicableTaxes - applicableTaxes: " + applicableTaxes));
        for (String applicableTax : applicableTaxes) {
            halfYearHeadTax = BigDecimal.ZERO;
            if (applicableTax.equals("GEN_TAX") || applicableTax.equals("VAC_LAND_TAX")) {
                if (applicableTax.equals("VAC_LAND_TAX")) {
                    taxRatePerc = this.getTaxRate("VAC_LAND_TAX");
                    halfYearHeadTax = this.getHalfYearTax(alv.multiply(taxRatePerc.divide(new BigDecimal("100"))).setScale(2, 4));
                } else {
                    taxRatePerc = floor != null && floor.getPropertyUsage().getIsResidential() != false ? this.getTaxRate("GEN_TAX_RESD") : this.getTaxRate("GEN_TAX_NR");
                    halfYearHeadTax = alv.multiply(taxRatePerc.divide(new BigDecimal("100"))).setScale(2, 4);
                }
                generalTax = halfYearHeadTax = this.taxIfGovtProperty(propTypeCode, halfYearHeadTax);
            }
            if (applicableTax.equals("EDU_CESS")) {
                halfYearHeadTax = educationTax = alv.multiply(this.getTaxRate("EDU_CESS").divide(new BigDecimal("100"))).setScale(2, 4);
            }
            if (applicableTax.equals("LIB_CESS")) {
                halfYearHeadTax = generalTax.add(educationTax).multiply(this.getTaxRate("LIB_CESS").divide(new BigDecimal("100"))).setScale(2, 4);
            }
            if (halfYearHeadTax.compareTo(BigDecimal.ZERO) <= 0) continue;
            totalHalfTaxPayable = totalHalfTaxPayable.add(halfYearHeadTax);
            this.createMiscTax(applicableTax, halfYearHeadTax, unitTaxCalculationInfo);
        }
        if (!(propTypeCode.equalsIgnoreCase("VAC_LAND") || unAuthDeviationPerc == null || "0".equals(unAuthDeviationPerc) || "-1".equals(unAuthDeviationPerc) || unAuthDeviationPerc != null && unAuthDeviationPerc.intValue() == 0)) {
            halfYearHeadTax = BigDecimal.ZERO;
            halfYearHeadTax = this.calculateUnAuthPenalty(unAuthDeviationPerc, totalHalfTaxPayable);
            totalHalfTaxPayable = totalHalfTaxPayable.add(halfYearHeadTax);
            this.createMiscTax("UNAUTH_PENALTY", halfYearHeadTax, unitTaxCalculationInfo);
        }
        if (this.isPrimaryServiceChrApplicable.booleanValue()) {
            halfYearHeadTax = BigDecimal.ZERO;
            halfYearHeadTax = this.roundOffToNearestEven(this.calcPublicServiceCharges(totalHalfTaxPayable));
            totalHalfTaxPayable = totalHalfTaxPayable.add(halfYearHeadTax);
            this.createMiscTax("PRIMARY_SER_CHRG", halfYearHeadTax, unitTaxCalculationInfo);
        }
        unitTaxCalculationInfo.setTotalTaxPayable(totalHalfTaxPayable);
        return unitTaxCalculationInfo;
    }

    private List<String> prepareApplicableTaxes(Property property) {
        LOGGER.debug((Object)"Entered into prepareApplTaxes");
        LOGGER.debug((Object)("prepareApplTaxes: property: " + property));
        ArrayList<String> applicableTaxes = new ArrayList<String>();
        if (!property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
            applicableTaxes.add("GEN_TAX");
            applicableTaxes.add("UNAUTH_PENALTY");
            applicableTaxes.add("EDU_CESS");
        } else {
            applicableTaxes.add("VAC_LAND_TAX");
        }
        applicableTaxes.add("LIB_CESS");
        if (this.isCorporation.booleanValue()) {
            applicableTaxes.add("SEW_TAX");
        }
        if (this.isPrimaryServiceChrApplicable.booleanValue()) {
            applicableTaxes.add("PRIMARY_SER_CHRG");
        }
        LOGGER.debug((Object)("prepareApplTaxes: applicableTaxes: " + applicableTaxes));
        LOGGER.debug((Object)"Exiting from prepareApplTaxes");
        return applicableTaxes;
    }

    private BoundaryCategory getBoundaryCategory(Boundary zone, Installment installment, Long usageId, Date occupancyDate, Long classification) throws TaxCalculatorExeption {
        List categories = new ArrayList();
        categories = this.persistenceService.findAllByNamedQuery("BASERATE_BY_OCCUPANCY_ZONE", new Object[]{zone.getId(), usageId, classification, occupancyDate, installment.getToDate()});
        LOGGER.debug((Object)("baseRentOfUnit - Installment : " + installment));
        if (categories.isEmpty()) {
            throw new TaxCalculatorExeption("There are no Unit rates defined for chosen combinations, zone : " + zone.getName() + " usageId : " + usageId + " classification : " + classification + " occupancyDate : " + occupancyDate);
        }
        return (BoundaryCategory)((Object)categories.get(0));
    }

    private List<EgDemandReasonDetails> getDemandReasonDetails(String demandReasonCode, BigDecimal grossAnnualRentAfterDeduction, Installment installment) {
        return this.persistenceService.findAllByNamedQuery("DEMANDREASONDETAILS_BY_DEMANDREASON_AND_INSTALLMENT", new Object[]{demandReasonCode, grossAnnualRentAfterDeduction, installment.getFromDate(), installment.getToDate()});
    }

    public Map<String, BigDecimal> getMiscTaxesForProp(List<UnitTaxCalculationInfo> unitTaxCalcInfos) {
        HashMap<String, BigDecimal> taxMap = new HashMap<String, BigDecimal>();
        for (UnitTaxCalculationInfo unitTaxCalculationInfo : unitTaxCalcInfos) {
            for (MiscellaneousTax miscTax : unitTaxCalculationInfo.getMiscellaneousTaxes()) {
                if (taxMap.get(miscTax.getTaxName()) == null) {
                    taxMap.put(miscTax.getTaxName(), miscTax.getTotalCalculatedTax());
                    continue;
                }
                taxMap.put(miscTax.getTaxName(), ((BigDecimal)taxMap.get(miscTax.getTaxName())).add(miscTax.getTotalCalculatedTax()));
            }
        }
        for (Map.Entry entry : taxMap.entrySet()) {
            entry.setValue(((BigDecimal)entry.getValue()).setScale(0, 4));
        }
        return taxMap;
    }

    private APUnitTaxCalculationInfo calculateVacantLandTax(Property property, Date occupancyDate, List<String> applicableTaxes, Installment installment) {
        APUnitTaxCalculationInfo unitTaxCalculationInfo = new APUnitTaxCalculationInfo();
        unitTaxCalculationInfo.setFloorNumber("VACANT");
        unitTaxCalculationInfo.setBaseRateEffectiveDate(occupancyDate);
        unitTaxCalculationInfo.setCapitalValue(new BigDecimal(property.getPropertyDetail().getCurrentCapitalValue()));
        unitTaxCalculationInfo.setNetARV(unitTaxCalculationInfo.getCapitalValue());
        this.calculateApplicableTaxes(applicableTaxes, unitTaxCalculationInfo, installment, property.getPropertyDetail().getPropertyTypeMaster().getCode(), null, null);
        return unitTaxCalculationInfo;
    }

    public String generateTaxCalculationXML(TaxCalculationInfo taxCalculationInfo) {
        TaxCalculationInfoXmlHandler handler = new TaxCalculationInfoXmlHandler();
        String taxCalculationInfoXML = "";
        if (taxCalculationInfo != null) {
            taxCalculationInfoXML = handler.toXML(taxCalculationInfo);
        }
        return taxCalculationInfoXML;
    }

    private Boolean between(Date date, Date fromDate, Date toDate) {
        return (date.after(fromDate) || date.equals(fromDate)) && date.before(toDate) || date.equals(toDate);
    }

    private Boolean betweenOrBefore(Date date, Date fromDate, Date toDate) {
        Boolean result = this.between(date, fromDate, toDate) != false || date.before(fromDate);
        return result;
    }

    private BigDecimal calculateFloorMrv(BigDecimal builtUpArea, BoundaryCategory boundaryCategory) {
        return builtUpArea.multiply(BigDecimal.valueOf(boundaryCategory.getCategory().getCategoryAmount()));
    }

    private BigDecimal calculateFloorBuildingValue(BigDecimal floorMrv) {
        return floorMrv.multiply(this.BUIULDING_VALUE).setScale(2, 4);
    }

    private BigDecimal calculateFloorSiteValue(BigDecimal floorMrv) {
        return floorMrv.multiply(this.SITE_VALUE).setScale(2, 4);
    }

    private BigDecimal calculateFloorDepreciation(BigDecimal grossArv, Floor floor) {
        BigDecimal depreciationPct = BigDecimal.ZERO;
        depreciationPct = this.isSeaShoreULB.booleanValue() ? (floor.getPropertyOccupation().getOccupancyCode().equals("OWNER") ? SEASHORE_RESD_OWNER_DEPRECIATION : BigDecimal.valueOf(floor.getDepreciationMaster().getDepreciationPct().floatValue())) : (floor.getPropertyOccupation().getOccupancyCode().equals("OWNER") && floor.getPropertyUsage().getIsResidential() != false ? RESD_OWNER_DEPRECIATION : BigDecimal.valueOf(floor.getDepreciationMaster().getDepreciationPct().floatValue()));
        return grossArv.multiply(depreciationPct).divide(BigDecimal.valueOf(100L));
    }

    public BigDecimal roundOffToNearestEven(BigDecimal amount) {
        BigDecimal remainder = amount.remainder(new BigDecimal(2));
        BigDecimal roundedAmt = remainder.compareTo(new BigDecimal("1")) == 1 ? amount.subtract(remainder).add(new BigDecimal(2)) : amount.subtract(remainder);
        return roundedAmt;
    }

    public BigDecimal convertYardToSquareMeters(Float vacantLandArea) {
        Float areaInSqMts = null;
        areaInSqMts = Float.valueOf(new Float(vacantLandArea.floatValue()).floatValue() * new Float(PropertyTaxConstants.SQUARE_YARD_TO_SQUARE_METER_VALUE.floatValue()).floatValue());
        return new BigDecimal(areaInSqMts.floatValue()).setScale(2, 4);
    }

    private BigDecimal taxIfGovtProperty(String propTypeCode, BigDecimal tax) {
        if (propTypeCode.equals("CENTRAL_GOVT_33.5")) {
            tax = tax.multiply(new BigDecimal(0.335));
        }
        if (propTypeCode.equals("CENTRAL_GOVT_50")) {
            tax = tax.multiply(new BigDecimal(0.5));
        }
        if (propTypeCode.equals("CENTRAL_GOVT_75")) {
            tax = tax.multiply(new BigDecimal(0.75));
        }
        return tax;
    }

    private BigDecimal getUnAuthDeviationPerc(Floor floor) {
        BigDecimal buildingPlanPlinthArea;
        BigDecimal deviationPerc = null;
        BigDecimal diffArea = null;
        BigDecimal plinthArea = new BigDecimal(floor.getBuiltUpArea().getArea().floatValue()).setScale(2, 4);
        BigDecimal bigDecimal = buildingPlanPlinthArea = floor.getBuildingPlanPlinthArea() != null && floor.getBuildingPlanPlinthArea().getArea() != null ? new BigDecimal(floor.getBuildingPlanPlinthArea().getArea().floatValue()).setScale(2, 4) : BigDecimal.ZERO;
        if (buildingPlanPlinthArea.compareTo(BigDecimal.ZERO) == 0) {
            deviationPerc = new BigDecimal(100);
        } else if (plinthArea.compareTo(buildingPlanPlinthArea) == 1) {
            diffArea = plinthArea.subtract(buildingPlanPlinthArea);
            deviationPerc = diffArea.divide(buildingPlanPlinthArea, 2, 4).multiply(new BigDecimal("100"));
        }
        return deviationPerc;
    }

    private BigDecimal calculateUnAuthPenalty(BigDecimal deviationPerc, BigDecimal totalPropertyTax) {
        BigDecimal unAuthPenalty = BigDecimal.ZERO;
        if (deviationPerc != null && !deviationPerc.equals("0")) {
            unAuthPenalty = deviationPerc.compareTo(BigDecimal.ZERO) == 1 && deviationPerc.compareTo(BigDecimal.TEN) <= 0 ? totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_1_10) : (deviationPerc.compareTo(BigDecimal.TEN) == 1 && deviationPerc.compareTo(PropertyTaxConstants.BIGDECIMAL_100) != 0 ? totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_ABOVE_11) : totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_NOT_DEFINED));
        }
        return unAuthPenalty;
    }

    private BigDecimal calcPublicServiceCharges(BigDecimal totalPropertyTax) {
        BigDecimal publicServiceCharge = BigDecimal.ZERO;
        return publicServiceCharge;
    }

    private void createMiscTax(String taxHead, BigDecimal tax, APUnitTaxCalculationInfo unitTaxCalculationInfo) {
        APMiscellaneousTax miscellaneousTax = new APMiscellaneousTax();
        miscellaneousTax.setTaxName(taxHead);
        miscellaneousTax.setTotalCalculatedTax(tax);
        unitTaxCalculationInfo.addMiscellaneousTaxes(miscellaneousTax);
    }

    private BigDecimal getTaxRate(String taxHead) {
        BigDecimal taxRate = BigDecimal.ZERO;
        if (this.taxRateProps != null) {
            taxRate = new BigDecimal(this.taxRateProps.getProperty(taxHead));
        }
        return taxRate;
    }

    private BigDecimal getHalfYearTax(BigDecimal annualTax) {
        return annualTax.divide(new BigDecimal(2)).setScale(2, 4);
    }
}

