/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.integration.impl;

import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.integration.bean.Property;
import org.egov.ptis.client.integration.utils.SpringBeanUtil;
import org.egov.ptis.client.util.DCBUtils;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.service.collection.PropertyTaxCollection;

public class PropertyImpl
extends Property {
    private PropertyTaxBillable billable;

    @Override
    protected Billable getBillable() {
        if (this.billable == null) {
            this.billable = new PropertyTaxBillable();
            this.billable.setBasicProperty(this.basicProperty);
            this.billable.setCollectionType("F");
        }
        return this.billable;
    }

    @Override
    public void setBillable(PropertyTaxBillable billable) {
        this.billable = billable;
    }

    @Override
    protected DCBDisplayInfo getDCBDisplayInfo() {
        DCBUtils dcbUtils = new DCBUtils();
        return dcbUtils.prepareDisplayInfo();
    }

    @Override
    public EgBill createBill() {
        PropertyTaxCollection propertyTaxCollection = SpringBeanUtil.getPropertyTaxCollection();
        PropertyTaxUtil propTaxUtil = SpringBeanUtil.getPropertyTaxUtil();
        PropertyTaxNumberGenerator propNumberGenerator = SpringBeanUtil.getPropertyTaxNumberGenerator();
        PTBillServiceImpl billServiceInterface = new PTBillServiceImpl();
        billServiceInterface.setPropertyTaxUtil(propTaxUtil);
        EgBill bill = billServiceInterface.generateBill(this.billable);
        return bill;
    }

    @Override
    protected void checkAuthorization() {
        Long userId = ApplicationThreadLocals.getUserId();
        if (userId == null) {
            throw new ApplicationRuntimeException(" User is null.Please check ");
        }
    }

    @Override
    protected void checkIsActive() {
        if (!this.basicProperty.isActive().booleanValue()) {
            throw new ApplicationRuntimeException("Property is Deactivated. Provided propertid : " + this.getPropertyID());
        }
    }
}

