/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.model.calculator;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;

@XStreamAlias(value="unitinfo")
public abstract class UnitTaxCalculationInfo {
    @XStreamAsAttribute
    private Date baseRateEffectiveDate;
    @XStreamAsAttribute
    private String floorNumber;
    @XStreamAsAttribute
    private BigDecimal floorArea;
    private BigDecimal unitAreaInSqFt;
    private String unitOccupation;
    private String unitOccupier;
    private String unitUsage;
    private String unitStructure;
    private BigDecimal baseRate;
    private BigDecimal baseRatePerSqMtPerMonth;
    private BigDecimal mrv;
    private BigDecimal buildingValue;
    private BigDecimal siteValue;
    private BigDecimal grossARV;
    private BigDecimal depreciation;
    private BigDecimal netARV;
    private Date occpancyDate;
    private Date effectiveAssessmentDate;
    @XStreamOmitField
    private Date propertyCreatedDate;
    @XStreamAlias(value="misctaxes")
    private List<MiscellaneousTax> miscellaneousTaxes = new ArrayList<MiscellaneousTax>();
    private BigDecimal totalTaxPayable;

    public UnitTaxCalculationInfo() {
    }

    public UnitTaxCalculationInfo(UnitTaxCalculationInfo unit) {
        this.floorNumber = unit.getFloorNumber();
        this.unitOccupation = unit.getUnitOccupation();
        this.unitUsage = unit.getUnitUsage();
        this.occpancyDate = new Date(unit.getOccpancyDate().getTime());
        this.effectiveAssessmentDate = unit.getEffectiveAssessmentDate();
        this.propertyCreatedDate = unit.getPropertyCreatedDate();
    }

    public Date getBaseRateEffectiveDate() {
        return this.baseRateEffectiveDate;
    }

    public void setBaseRateEffectiveDate(Date baseRateEffectiveDate) {
        this.baseRateEffectiveDate = baseRateEffectiveDate;
    }

    public String getFloorNumber() {
        return this.floorNumber;
    }

    public void setFloorNumber(String floorNumber) {
        this.floorNumber = floorNumber;
    }

    public BigDecimal getFloorArea() {
        return this.floorArea;
    }

    public void setFloorArea(BigDecimal floorArea) {
        this.floorArea = floorArea;
    }

    public BigDecimal getUnitAreaInSqFt() {
        return this.unitAreaInSqFt;
    }

    public void setUnitAreaInSqFt(BigDecimal unitAreaInSqFt) {
        this.unitAreaInSqFt = unitAreaInSqFt;
    }

    public String getUnitOccupation() {
        return this.unitOccupation;
    }

    public void setUnitOccupation(String unitOccupation) {
        this.unitOccupation = unitOccupation;
    }

    public String getUnitOccupier() {
        return this.unitOccupier;
    }

    public void setUnitOccupier(String unitOccupier) {
        this.unitOccupier = unitOccupier;
    }

    public String getUnitUsage() {
        return this.unitUsage;
    }

    public void setUnitUsage(String unitUsage) {
        this.unitUsage = unitUsage;
    }

    public String getUnitStructure() {
        return this.unitStructure;
    }

    public void setUnitStructure(String unitStructure) {
        this.unitStructure = unitStructure;
    }

    public BigDecimal getBaseRate() {
        return this.baseRate;
    }

    public void setBaseRate(BigDecimal baseRate) {
        this.baseRate = baseRate;
    }

    public BigDecimal getBaseRatePerSqMtPerMonth() {
        return this.baseRatePerSqMtPerMonth;
    }

    public void setBaseRatePerSqMtPerMonth(BigDecimal baseRatePerSqMtPerMonth) {
        this.baseRatePerSqMtPerMonth = baseRatePerSqMtPerMonth;
    }

    public BigDecimal getMrv() {
        return this.mrv;
    }

    public void setMrv(BigDecimal mrv) {
        this.mrv = mrv;
    }

    public BigDecimal getBuildingValue() {
        return this.buildingValue;
    }

    public void setBuildingValue(BigDecimal buildingValue) {
        this.buildingValue = buildingValue;
    }

    public BigDecimal getSiteValue() {
        return this.siteValue;
    }

    public void setSiteValue(BigDecimal siteValue) {
        this.siteValue = siteValue;
    }

    public BigDecimal getGrossARV() {
        return this.grossARV;
    }

    public void setGrossARV(BigDecimal grossARV) {
        this.grossARV = grossARV;
    }

    public BigDecimal getDepreciation() {
        return this.depreciation;
    }

    public void setDepreciation(BigDecimal depreciation) {
        this.depreciation = depreciation;
    }

    public BigDecimal getNetARV() {
        return this.netARV;
    }

    public void setNetARV(BigDecimal netARV) {
        this.netARV = netARV;
    }

    public Date getOccpancyDate() {
        return this.occpancyDate;
    }

    public void setOccpancyDate(Date occpancyDate) {
        this.occpancyDate = occpancyDate;
    }

    public Date getEffectiveAssessmentDate() {
        return this.effectiveAssessmentDate;
    }

    public void setEffectiveAssessmentDate(Date effectiveAssessmentDate) {
        this.effectiveAssessmentDate = effectiveAssessmentDate;
    }

    public Date getPropertyCreatedDate() {
        return this.propertyCreatedDate;
    }

    public void setPropertyCreatedDate(Date propertyCreatedDate) {
        this.propertyCreatedDate = propertyCreatedDate;
    }

    public List<MiscellaneousTax> getMiscellaneousTaxes() {
        return this.miscellaneousTaxes;
    }

    public void setMiscellaneousTaxes(List<MiscellaneousTax> miscellaneousTaxes) {
        this.miscellaneousTaxes = miscellaneousTaxes;
    }

    public void addMiscellaneousTaxes(MiscellaneousTax miscellaneousTaxes) {
        this.getMiscellaneousTaxes().add(miscellaneousTaxes);
    }

    public BigDecimal getTotalTaxPayable() {
        return this.totalTaxPayable;
    }

    public void setTotalTaxPayable(BigDecimal totalTaxPayable) {
        this.totalTaxPayable = totalTaxPayable;
    }

    public int hashCode() {
        int hashCode = this.effectiveAssessmentDate.hashCode() + this.floorNumber.hashCode() + this.occpancyDate.hashCode() + this.unitOccupation.hashCode() + this.unitUsage.hashCode();
        return hashCode;
    }
}

