/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.dao.property.PropertyMutationMasterDAO;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyMutationMasterDAO")
@Transactional(readOnly=true)
public class PropertyMutationMasterHibDAO
implements PropertyMutationMasterDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public List<PropertyMutationMaster> getAllPropertyMutationMastersByType(String type) {
        Query qry = this.getCurrentSession().createQuery("from PropertyMutationMaster PM where upper(PM.type) = :type order by PM.orderId");
        qry.setString("type", type.toUpperCase());
        return qry.list();
    }

    @Override
    public PropertyMutationMaster getPropertyMutationMasterByCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from PropertyMutationMaster PM where upper(PM.code) = :code");
        qry.setString("code", code.toUpperCase());
        return (PropertyMutationMaster)qry.uniqueResult();
    }

    @Override
    public PropertyMutationMaster getPropertyMutationMasterByCodeAndType(String code, String type) {
        Query qry = this.getCurrentSession().createQuery("from PropertyMutationMaster PM where upper(PM.code) = :code and upper(PM.type) = :type");
        qry.setString("code", code.toUpperCase());
        qry.setString("type", type.toUpperCase());
        return (PropertyMutationMaster)qry.uniqueResult();
    }

    public Object findById(Serializable id, boolean lock) {
        return null;
    }

    public List findAll() {
        return null;
    }

    public List findByExample(Object exampleT) {
        return null;
    }

    public Object create(Object entity) {
        return null;
    }

    public void delete(Object entity) {
    }

    public Object update(Object entity) {
        return null;
    }

    @Override
    public PropertyMutationMaster findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public PropertyMutationMaster create(PropertyMutationMaster propertyMutationMaster) {
        return null;
    }

    @Override
    public void delete(PropertyMutationMaster propertyMutationMaster) {
    }

    @Override
    public PropertyMutationMaster update(PropertyMutationMaster propertyMutationMaster) {
        return null;
    }
}

