/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.ptis.domain.dao.property.PropertyIDDAO;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyIDDAO")
@Transactional(readOnly=true)
public class PropertyIDHibernateDAO
implements PropertyIDDAO {
    private static final Logger LOGGER = Logger.getLogger(PropertyIDHibernateDAO.class);
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PropertyID getPropertyIDByUPICNo(String upicNo) {
        Query qry = this.getCurrentSession().createQuery("from PropertyID PD where PD.id_PropertyId =:upicNo");
        qry.setString("upicNo", upicNo);
        return (PropertyID)((Object)qry.uniqueResult());
    }

    @Override
    public List getPropertyIDByBoundry(Integer zoneID, Integer wardID, Integer colonyID) {
        LOGGER.info((Object)(">>>>>>>>>>>>>>>>>> colonyId" + zoneID + ":::::::" + wardID + ":::::::::::" + colonyID));
        Query qry = this.getCurrentSession().createQuery("from PropertyID PD where PD.zoneId=:zoneID And PD.wardId=:wardID And PD.colonyId =:colonyID");
        qry.setInteger("zoneID", zoneID.intValue());
        qry.setInteger("wardID", wardID.intValue());
        qry.setInteger("colonyID", colonyID.intValue());
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>> After Qry");
        return qry.list();
    }

    @Override
    public List getPropertyIDByBoundryForWardBlockStreet(Integer wardID, Integer blockID, Integer streetID) {
        LOGGER.info((Object)(">>>>>>>>>>>>>>>>>> streetID" + wardID + ":::::::" + blockID + ":::::::::::" + streetID));
        Query qry = this.getCurrentSession().createQuery("from PropertyID PD where PD.wardId=:wardID And PD.blockId=:blockID And PD.streetId =:streetID");
        qry.setInteger("wardID", wardID.intValue());
        qry.setInteger("blockID", blockID.intValue());
        qry.setInteger("streetID", streetID.intValue());
        LOGGER.info((Object)">>>>>>>>>>>>>>>>>> After Qry");
        return qry.list();
    }

    @Override
    public PropertyID getPropertyByBoundryAndMunNo(Integer zoneID, Integer wardID, Integer colonyID, Integer munNo) {
        LOGGER.info((Object)(">>>>>>>>>>>>>>>>>> colonyId" + colonyID + ":::::::::::::::munNo:" + munNo));
        Query qry = this.getCurrentSession().createQuery("from PropertyID PD where PD.zoneId=:zoneID And PD.wardId=:wardID And PD.colonyId =:colonyID and PD.doorNum =:munNo");
        qry.setInteger("zoneID", zoneID.intValue());
        qry.setInteger("wardID", wardID.intValue());
        qry.setInteger("colonyID", colonyID.intValue());
        qry.setInteger("munNo", munNo.intValue());
        return (PropertyID)((Object)qry.uniqueResult());
    }

    @Override
    public PropertyID findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<PropertyID> findAll() {
        return null;
    }

    @Override
    public PropertyID create(PropertyID propertyID) {
        return null;
    }

    @Override
    public void delete(PropertyID propertyID) {
    }

    @Override
    public PropertyID update(PropertyID propertyID) {
        return null;
    }
}

