/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.service;

import java.math.BigDecimal;

public final class Amount {
    private BigDecimal amount;
    private static Amount ZERO = new Amount(BigDecimal.ZERO);

    public Amount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean isZero() {
        return this.amount.compareTo(BigDecimal.ZERO) == 0;
    }

    public boolean isGreaterThan(BigDecimal bd) {
        return this.amount.compareTo(bd) > 0;
    }

    public boolean isGreaterThanZero() {
        return this.isGreaterThan(BigDecimal.ZERO);
    }

    public boolean isGreaterThanOrEqualTo(BigDecimal bd) {
        return this.amount.compareTo(bd) >= 0;
    }

    public boolean isLessThanOrEqualTo(BigDecimal bd) {
        return this.amount.compareTo(bd) <= 0;
    }

    public boolean isLessThan(BigDecimal bd) {
        return this.amount.compareTo(bd) < 0;
    }

    public boolean isGreaterThanOrEqualToZero() {
        return this.isGreaterThanOrEqualTo(BigDecimal.ZERO);
    }

    public Amount minus(BigDecimal bd) {
        return new Amount(this.amount.subtract(bd));
    }

    public Amount plus(BigDecimal bd) {
        return new Amount(this.amount.add(bd));
    }

    public Amount multiply(BigDecimal bd) {
        return new Amount(this.amount.multiply(bd));
    }

    public Amount divide(BigDecimal bd) {
        return new Amount(this.amount.divide(bd));
    }
}

