/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.transfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyMutationMasterDAO;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyMutationTransferee;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertySource;
import org.egov.ptis.domain.entity.property.PtApplicationType;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.egov.ptis.wtms.WaterChargesIntegrationService;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class PropertyTransferService {
    @Autowired
    @Qualifier(value="propertyMutationService")
    private PersistenceService<PropertyMutation, Long> propertyMutationService;
    @Autowired
    @Qualifier(value="propertyImplService")
    private PersistenceService<PropertyImpl, Long> propertyImplService;
    @Autowired
    @Qualifier(value="basicPropertyService")
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyMutationMasterDAO propertyMutationMasterDAO;
    @Autowired
    @Qualifier(value="fileStoreService")
    private FileStoreService fileStoreService;
    @Autowired
    @Qualifier(value="propertyTaxNumberGenerator")
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    @Qualifier(value="documentTypePersistenceService")
    private PersistenceService<DocumentType, Long> documentTypePersistenceService;
    @Autowired
    @Qualifier(value="ptaxApplicationTypeService")
    private PersistenceService<PtApplicationType, Long> ptaxApplicationTypeService;
    @Autowired
    private UserService userService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private SimpleRestClient simpleRestClient;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private ReportService reportService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private CityService cityService;
    @Autowired
    private PropertyTaxBillable propertyTaxBillable;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    @Qualifier(value="waterChargesIntegrationServiceImpl")
    private WaterChargesIntegrationService waterChargesIntegrationService;
    @Autowired
    private PtDemandDao ptDemandDAO;

    @Transactional
    public void initiatePropertyTransfer(BasicProperty basicProperty, PropertyMutation propertyMutation) {
        propertyMutation.setBasicProperty(basicProperty);
        propertyMutation.setProperty(basicProperty.getActiveProperty());
        for (PropertyOwnerInfo ownerInfo : basicProperty.getPropertyOwnerInfo()) {
            propertyMutation.getTransferorInfos().add(ownerInfo.getOwner());
        }
        propertyMutation.setMutationDate(new Date());
        if (propertyMutation.getApplicationNo() == null) {
            propertyMutation.setApplicationNo(this.applicationNumberGenerator.generate());
        }
        this.createUserIfNotExist(propertyMutation, propertyMutation.getTransfereeInfosProxy());
        basicProperty.getPropertyMutations().add(propertyMutation);
        basicProperty.setUnderWorkflow(true);
        this.processAndStoreDocument(propertyMutation.getDocuments());
        this.propertyService.updateIndexes(propertyMutation, "Transfer_of_Ownership");
        this.basicPropertyService.persist((Object)basicProperty);
    }

    @Transactional
    public void approvePropertyTransfer(BasicProperty basicProperty, PropertyMutation propertyMutation) {
        PropertySource propertySource = basicProperty.getPropertyOwnerInfo().get(0).getSource();
        basicProperty.getPropertyOwnerInfo().clear();
        this.createUserIfNotExist(propertyMutation, propertyMutation.getTransfereeInfosProxy());
        int order = 1;
        for (PropertyMutationTransferee propertyOwner : propertyMutation.getTransfereeInfosProxy()) {
            PropertyOwnerInfo propertyOwnerInfo = new PropertyOwnerInfo(basicProperty, propertySource, propertyOwner.getTransferee(), order++);
            basicProperty.getPropertyOwnerInfo().add(propertyOwnerInfo);
        }
        propertyMutation.setMutationDate(new Date());
        this.propertyService.updateIndexes(propertyMutation, "Transfer_of_Ownership");
        this.waterChargesIntegrationService.updateConsumerIndex(this.propertyService.loadAssessmentDetails(basicProperty));
        this.basicPropertyService.persist((Object)basicProperty);
    }

    @Transactional
    public void updatePropertyTransfer(BasicProperty basicProperty, PropertyMutation propertyMutation) {
        this.processAndStoreDocument(propertyMutation.getDocuments());
        this.checkAllMandatoryDocumentsAttached(propertyMutation);
        this.createUserIfNotExist(propertyMutation, propertyMutation.getTransfereeInfosProxy());
        basicProperty.setUnderWorkflow(true);
        this.propertyService.updateIndexes(propertyMutation, "Transfer_of_Ownership");
        this.basicPropertyService.persist((Object)basicProperty);
    }

    @Transactional
    public void viewPropertyTransfer(BasicProperty basicProperty, PropertyMutation propertyMutation) {
        this.propertyService.updateIndexes(propertyMutation, "Transfer_of_Ownership");
        this.basicPropertyService.persist((Object)basicProperty);
    }

    @Transactional
    public void deleteTransferee(PropertyMutation propertyMutation, Long transfereeId) {
        PropertyMutationTransferee userToRemove = null;
        for (PropertyMutationTransferee user : propertyMutation.getTransfereeInfos()) {
            if (!user.getTransferee().getId().equals(transfereeId)) continue;
            userToRemove = user;
        }
        propertyMutation.getTransfereeInfos().remove((Object)userToRemove);
        this.propertyMutationService.persist((Object)propertyMutation);
    }

    public double calculateMutationFee(double marketValue, String transferReason, PropertyMutation propertyMutation) {
        int transferedInMonths = Months.monthsBetween((ReadablePartial)new LocalDate((Object)propertyMutation.getMutationDate()).withDayOfMonth(1), (ReadablePartial)new LocalDate((Object)propertyMutation.getDeedDate()).withDayOfMonth(1)).getMonths();
        return (Double)this.scriptService.executeScript("PTIS-MUTATION-FEE-CALCULATOR", ScriptService.createContext((Object[])new Object[]{"marketValue", marketValue, "transferedInMonths", transferedInMonths, "transferReason", transferReason}));
    }

    public BigDecimal getWaterTaxDues(String wtmsTaxDueChecking_REST_url, String upicNo) {
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsTaxDueChecking_REST_url);
        return waterTaxInfo.get("totalTaxDue") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("totalTaxDue"));
    }

    public PropertyImpl getActiveProperty(String upicNo) {
        return (PropertyImpl)this.propertyImplService.findByNamedQuery("getPropertyByUpicNoAndStatus", new Object[]{upicNo, PropertyTaxConstants.STATUS_ISACTIVE});
    }

    public BasicPropertyImpl getBasicPropertyByUpicNo(String upicNo) {
        return (BasicPropertyImpl)this.basicPropertyDAO.getBasicPropertyByPropertyID(upicNo);
    }

    public List<DocumentType> getPropertyTransferDocumentTypes() {
        return this.documentTypePersistenceService.findAllByNamedQuery("DOCUMENTTYPE_BY_TRANSACTION_TYPE", new Object[]{TransactionType.TRANSFER});
    }

    public List<PropertyMutationMaster> getPropertyTransferReasons() {
        return this.propertyMutationMasterDAO.getAllPropertyMutationMastersByType("TRANSFER");
    }

    public PropertyMutationMaster getPropertyTransferReasonsByCode(String mutationCode) {
        return this.propertyMutationMasterDAO.getPropertyMutationMasterByCodeAndType(mutationCode, "TRANSFER");
    }

    public PropertyMutation getPropertyMutationByApplicationNo(String applicationNo) {
        return (PropertyMutation)((Object)this.propertyMutationService.findByNamedQuery("BY_APPLICATION_NO", new Object[]{applicationNo}));
    }

    public PropertyMutation getCurrentPropertyMutationByAssessmentNo(String assessmentNo) {
        PropertyMutation currentPropertyMutation = null;
        BasicPropertyImpl basicProperty = this.getBasicPropertyByUpicNo(assessmentNo);
        if (null != basicProperty) {
            for (PropertyMutation propertyMutation : basicProperty.getPropertyMutations()) {
                if (propertyMutation.getState().getValue().equals("Closed")) continue;
                currentPropertyMutation = propertyMutation;
                break;
            }
        }
        return currentPropertyMutation;
    }

    public ReportOutput generateAcknowledgement(BasicProperty basicProperty, PropertyMutation propertyMutation, String cityName, String cityLogo) {
        HashMap reportParams = new HashMap();
        PropertyAckNoticeInfo ackBean = new PropertyAckNoticeInfo();
        ackBean.setUlbLogo(cityLogo);
        ackBean.setMunicipalityName(cityName);
        ackBean.setReceivedDate(new SimpleDateFormat("dd/MM/yyyy").format(propertyMutation.getMutationDate()));
        ackBean.setApplicationNo(propertyMutation.getApplicationNo());
        ackBean.setApplicationDate(new SimpleDateFormat("dd/MM/yyyy").format(propertyMutation.getMutationDate()));
        ackBean.setApplicationName(propertyMutation.getFullTranfereeName());
        if (propertyMutation.getTransfereeInfos() != null && propertyMutation.getTransfereeInfos().size() > 0) {
            String newOwnerName = "";
            for (PropertyMutationTransferee usr : propertyMutation.getTransfereeInfos()) {
                newOwnerName = newOwnerName + usr.getTransferee().getName() + ",";
            }
            ackBean.setOwnerName(newOwnerName.substring(0, newOwnerName.length() - 1));
        }
        ackBean.setOwnerAddress(basicProperty.getAddress().toString());
        ackBean.setNoOfDays(((PtApplicationType)((Object)this.ptaxApplicationTypeService.findByNamedQuery("BY_CODE", new Object[]{"TRANSFER"}))).getResolutionTime().toString());
        ReportRequest reportInput = new ReportRequest("transferProperty_ack", (Object)ackBean, reportParams);
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        return this.reportService.createReport(reportInput);
    }

    @Transactional
    public ReportOutput generateTransferNotice(BasicProperty basicProperty, PropertyMutation propertyMutation, String cityName, String cityLogo, String actionType, boolean isCorporation) {
        PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("Mutation Certificate", propertyMutation.getApplicationNo());
        ReportOutput reportOutput = new ReportOutput();
        if ("Generate Title Transfer Notice".equalsIgnoreCase(actionType)) {
            byte[] bFile;
            FileStoreMapper fsm = notice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating Mutation Certificate : " + e);
            }
            reportOutput.setReportOutputData(bFile);
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            propertyMutation.transition().end();
            basicProperty.setUnderWorkflow(false);
        } else {
            PropertyAckNoticeInfo noticeBean = new PropertyAckNoticeInfo();
            noticeBean.setMunicipalityName(cityName);
            BasicProperty basicProp = propertyMutation.getBasicProperty();
            HashMap<String, Object> reportParams = new HashMap<String, Object>();
            reportParams.put("userSignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : null);
            reportParams.put("isCorporation", isCorporation);
            noticeBean.setOldOwnerName(propertyMutation.getFullTranferorName());
            noticeBean.setOldOwnerParentName(propertyMutation.getFullTransferorGuardianName());
            noticeBean.setNewOwnerName(propertyMutation.getFullTranfereeName());
            noticeBean.setNewOwnerGuardianRelation(propertyMutation.getTransfereeGuardianRelation());
            noticeBean.setRegDocDate(new SimpleDateFormat("dd/MM/yyyy").format(propertyMutation.getDeedDate()));
            noticeBean.setRegDocNo(propertyMutation.getDeedNo());
            noticeBean.setAssessmentNo(basicProp.getUpicNo());
            noticeBean.setApprovedDate(new SimpleDateFormat("dd/MM/yyyy").format(propertyMutation.getMutationDate()));
            if (basicProp.getAddress() != null) {
                PropertyAddress address = basicProp.getAddress();
                noticeBean.setOwnerAddress(address.toString());
                if (StringUtils.isNotBlank((String)address.getHouseNoBldgApt())) {
                    noticeBean.setDoorNo(address.getHouseNoBldgApt());
                } else {
                    noticeBean.setDoorNo("N/A");
                }
            }
            PropertyID propertyId = basicProp.getPropertyID();
            noticeBean.setLocalityName(propertyId.getLocality().getName());
            ReportRequest reportInput = new ReportRequest("mainMutationCertificate", (Object)noticeBean, reportParams);
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            reportOutput = this.reportService.createReport(reportInput);
            if ("Sign".equals(actionType)) {
                if (notice == null) {
                    String noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber("Mutation Certificate");
                    this.noticeService.saveNotice(propertyMutation.getApplicationNo(), noticeNo, "Mutation Certificate", basicProperty, new ByteArrayInputStream(reportOutput.getReportOutputData()));
                } else {
                    this.noticeService.updateNotice(notice, new ByteArrayInputStream(reportOutput.getReportOutputData()));
                }
                this.noticeService.getSession().flush();
            }
        }
        return reportOutput;
    }

    private void checkAllMandatoryDocumentsAttached(PropertyMutation propertyMutation) {
        for (Document document : propertyMutation.getDocuments()) {
            if (!document.getType().isMandatory() && !document.isEnclosed() || !document.getFiles().isEmpty()) continue;
            throw new ValidationException(new ValidationError[]{new ValidationError("documents", "Please attach mandatory/marked enclosed documents.")});
        }
    }

    private void createUserIfNotExist(PropertyMutation propertyMutation, List<PropertyMutationTransferee> transferees) {
        ArrayList newOwners = new ArrayList();
        propertyMutation.getTransfereeInfos().clear();
        for (PropertyMutationTransferee transferee : transferees) {
            if (transferee != null) {
                User user = null;
                if (null != transferee.getTransferee().getAadhaarNumber() && !transferee.getTransferee().getAadhaarNumber().isEmpty()) {
                    List userList = new ArrayList();
                    userList = this.userService.getUserByAadhaarNumberAndType(transferee.getTransferee().getAadhaarNumber(), transferee.getTransferee().getType());
                    if (userList != null && !userList.isEmpty()) {
                        for (int i = 0; i < userList.size(); ++i) {
                            if (!((User)userList.get(i)).getAadhaarNumber().equalsIgnoreCase(transferee.getTransferee().getAadhaarNumber()) || !((User)userList.get(i)).getMobileNumber().equalsIgnoreCase(transferee.getTransferee().getMobileNumber()) || !((User)userList.get(i)).getName().equalsIgnoreCase(transferee.getTransferee().getName())) continue;
                            user = (User)userList.get(i);
                        }
                    }
                } else {
                    user = (User)this.basicPropertyService.find("From User where name = ? and mobileNumber = ? and gender = ? ", new Object[]{transferee.getTransferee().getName(), transferee.getTransferee().getMobileNumber(), transferee.getTransferee().getGender()});
                }
                if (user == null) {
                    if (UserType.CITIZEN.equals((Object)transferee.getTransferee().getType())) {
                        Citizen newOwner = new Citizen();
                        newOwner.setAadhaarNumber(transferee.getTransferee().getAadhaarNumber());
                        newOwner.setEmailId(transferee.getTransferee().getEmailId());
                        newOwner.setMobileNumber(transferee.getTransferee().getMobileNumber());
                        newOwner.setGender(transferee.getTransferee().getGender());
                        newOwner.setGuardian(transferee.getTransferee().getGuardian());
                        newOwner.setGuardianRelation(transferee.getTransferee().getGuardianRelation());
                        newOwner.setSalutation(transferee.getTransferee().getSalutation());
                        newOwner.setName(transferee.getTransferee().getName());
                        newOwner.setPassword("NOTSET");
                        newOwner.setUsername(this.propertyTaxUtil.generateUserName(transferee.getTransferee().getName()));
                        this.userService.createUser((User)newOwner);
                        transferee.setTransferee((User)newOwner);
                        transferee.setPropertyMutation(propertyMutation);
                    }
                } else {
                    user.setEmailId(transferee.getTransferee().getEmailId());
                    user.setGuardian(transferee.getTransferee().getGuardian());
                    user.setGuardianRelation(transferee.getTransferee().getGuardianRelation());
                    transferee.setTransferee(user);
                    transferee.setPropertyMutation(propertyMutation);
                }
            }
            propertyMutation.addTransfereeInfos(transferee);
        }
    }

    private void processAndStoreDocument(List<Document> documents) {
        documents.forEach(document -> {
            if (!document.getUploads().isEmpty()) {
                int fileCount = 0;
                for (File file : document.getUploads()) {
                    FileStoreMapper fileStore = this.fileStoreService.store(file, document.getUploadsFileName().get(fileCount), document.getUploadsContentType().get(fileCount++), "PTIS");
                    document.getFiles().add(fileStore);
                }
            }
            if (document.getId() == null || document.getType() == null) {
                document.setType((DocumentType)((Object)((Object)this.documentTypePersistenceService.load((Serializable)document.getType().getId(), DocumentType.class))));
            }
        });
    }

    public String generateReceipt(PropertyMutation propertyMutation) {
        this.propertyTaxBillable.setBasicProperty(propertyMutation.getBasicProperty());
        this.propertyTaxBillable.setMutationFeePayment(Boolean.TRUE);
        this.propertyTaxBillable.setMutationFee(propertyMutation.getMutationFee());
        this.propertyTaxBillable.setCollectionType("C");
        this.propertyTaxBillable.setCallbackForApportion(Boolean.FALSE);
        this.propertyTaxBillable.setMutationApplicationNo(propertyMutation.getApplicationNo());
        this.propertyTaxBillable.setUserId(ApplicationThreadLocals.getUserId());
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateManualBillNumber(propertyMutation.getBasicProperty().getPropertyID()));
        return this.ptBillServiceImpl.getBillXML(this.propertyTaxBillable);
    }

    public String getLoggedInUserDesignation() {
        Designation designation = this.propertyTaxUtil.getDesignationForUser(this.securityUtils.getCurrentUser().getId());
        return designation.getName();
    }

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    @Transactional
    public void updateMutationCollection(PropertyMutation propertyMutation) {
        this.propertyMutationService.persist((Object)propertyMutation);
    }

    public String getCityName() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getName();
    }

    public Designation getUserDesigantion() {
        Long userId = this.securityUtils.getCurrentUser().getId();
        Designation designation = this.propertyTaxUtil.getDesignationForUser(userId);
        return designation;
    }

    public PropertyMutation initiatePropertyTransfer(BasicProperty basicproperty, PropertyMutation propertyMutation, HashMap<String, String> meesevaParams) {
        this.initiatePropertyTransfer(basicproperty, propertyMutation);
        return propertyMutation;
    }
}

