/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;

public class StructureClassification
extends BaseModel {
    private String typeName;
    private String description;
    private String constrTypeCode;
    private Integer orderId;
    private Integer floorNum;
    private Integer number;
    private Float factor;
    private Installment startInstallment;
    private char isHistory;
    private Date fromDate;
    private Date toDate;
    private Boolean isActive;

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        StructureClassification thatStrCls = (StructureClassification)((Object)that);
        if (this.getId() != null && thatStrCls.getId() != null) {
            return this.getId().equals(thatStrCls.getId());
        }
        if (this.getTypeName() != null && thatStrCls.getTypeName() != null) {
            return this.getTypeName().equals(thatStrCls.getTypeName());
        }
        if (this.getNumber() != null && thatStrCls.getNumber() != null) {
            return this.getNumber().equals(thatStrCls.getNumber());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        if (this.getTypeName() != null) {
            hashCode += this.getTypeName().hashCode();
        }
        if (this.getNumber() != null) {
            hashCode += this.getNumber().hashCode();
        }
        return hashCode;
    }

    public List<ValidationError> validate() {
        ValidationError ve;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.getTypeName() == null) {
            ve = new ValidationError("StrucClass.TypeName.Null", "In StructureClassification Attribute 'Type Name' is Not Set, Please Check !!");
            validationErrors.add(ve);
        }
        if (this.getNumber() == null || this.getNumber() == 0) {
            ve = new ValidationError("StrucClass.Number.Null", "In StructureClassification Attribute 'Number' is Not Set OR is Zero, Please Check !!");
            validationErrors.add(ve);
        }
        return validationErrors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("").append(this.id).append("|").append(this.constrTypeCode).append("|").append(this.factor);
        return sb.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getConstrTypeCode() {
        return this.constrTypeCode;
    }

    public void setConstrTypeCode(String constrTypeCode) {
        this.constrTypeCode = constrTypeCode;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Integer getFloorNum() {
        return this.floorNum;
    }

    public void setFloorNum(Integer floorNum) {
        this.floorNum = floorNum;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Float getFactor() {
        return this.factor;
    }

    public void setFactor(Float factor) {
        this.factor = factor;
    }

    public Installment getStartInstallment() {
        return this.startInstallment;
    }

    public void setStartInstallment(Installment startInstallment) {
        this.startInstallment = startInstallment;
    }

    public char getIsHistory() {
        return this.isHistory;
    }

    public void setIsHistory(char isHistory) {
        this.isHistory = isHistory;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }
}

