/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.jboss.logging.Logger;

public class DailyCollectionReportSearch {
    private String fromDate;
    private String toDate;
    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat dtft = new SimpleDateFormat("dd/MM/yyyy");
    private String collectionMode;
    private String collectionOperator;
    private String status;
    private String revenueWard;
    private String searchText;
    private String ulbName;
    private List<String> consumerCode = new ArrayList<String>();
    private static final Logger logger = Logger.getLogger(DailyCollectionReportSearch.class);

    public void setFromDate(String fromDate) {
        if (null != fromDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range From start.. :" + this.ft.format(this.dtft.parse(fromDate))));
                }
                this.fromDate = this.ft.format(this.dtft.parse(fromDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setToDate(String toDate) {
        if (null != toDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range Till .. :" + this.ft.format(this.dtft.parse(toDate))));
                }
                this.toDate = this.ft.format(this.dtft.parse(toDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public String getCollectionMode() {
        return this.collectionMode;
    }

    public void setCollectionMode(String collectionMode) {
        this.collectionMode = collectionMode;
    }

    public String getCollectionOperator() {
        return this.collectionOperator;
    }

    public void setCollectionOperator(String collectionOperator) {
        this.collectionOperator = collectionOperator;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRevenueWard() {
        return this.revenueWard;
    }

    public void setRevenueWard(String revenueWard) {
        this.revenueWard = revenueWard;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public List<String> getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(List<String> consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getUlbName() {
        return this.ulbName;
    }

    public void setUlbName(String ulbName) {
        this.ulbName = ulbName;
    }

    public Filters searchCollectionFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>(0);
        andFilters.add(Filter.termsStringFilter((String)"clauses.cityname", (String[])new String[]{this.ulbName}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.channel", (String[])new String[]{this.collectionMode}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.status", (String[])new String[]{this.status}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.receiptcreator", (String[])new String[]{this.collectionOperator}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.billingservice", (String[])new String[]{"Property Tax"}));
        if (!this.consumerCode.isEmpty()) {
            String[] consumerCodes = this.consumerCode.toArray(new String[this.consumerCode.size()]);
            andFilters.add(Filter.termsStringFilter((String)"common.consumercode", (String[])consumerCodes));
        }
        andFilters.add(Filter.rangeFilter((String)"searchable.receiptdate", (String)this.fromDate, (String)this.toDate));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finished filters");
        }
        return Filters.withAndFilters(andFilters);
    }

    public Filters searchProperyForWardFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>(0);
        andFilters.add(Filter.termsStringFilter((String)"clauses.cityname", (String[])new String[]{this.ulbName}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.revwardname", (String[])new String[]{this.revenueWard}));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finished property tax filters");
        }
        return Filters.withAndFilters(andFilters);
    }

    public String searchQuery() {
        return this.searchText;
    }
}

