/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyDetailDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyDetailDAO")
@Transactional(readOnly=true)
public class PropertyDetailHibernateDAO
implements PropertyDetailDAO {
    private static final Logger LOGGER = Logger.getLogger(PropertyDetailHibernateDAO.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PropertyDetail getPropertyDetailByProperty(Property property) {
        Query qry = this.getCurrentSession().createQuery("from PropertyDetail PD where PD.property = :property ");
        qry.setEntity("property", (Object)property);
        return (PropertyDetail)qry.uniqueResult();
    }

    @Override
    public PropertyDetail getPropertyDetailBySurveyNumber(String surveyNumber) {
        Query qry = this.getCurrentSession().createQuery("from PropertyDetail PD where PD.property.surveyNumber =: SURVEY_NUM ");
        qry.setString("surveyNumber", surveyNumber);
        return (PropertyDetail)qry.uniqueResult();
    }

    @Override
    public PropertyDetail getPropertyDetailByRegNum(String regNum) {
        LOGGER.info((Object)"getPropertyDetailByRegNum Invoked");
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByRegNum(regNum);
        LOGGER.info((Object)("basicProperty : " + basicProperty));
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty = :BasicProperty ");
        qry.setEntity("BasicProperty", (Object)basicProperty);
        Property property = (Property)qry.uniqueResult();
        LOGGER.info((Object)("property : " + property));
        Query qry1 = this.getCurrentSession().createQuery("from PropertyDetail PD where PD.property =:Property ");
        qry1.setEntity("Property", (Object)property);
        return (PropertyDetail)qry1.uniqueResult();
    }

    @Override
    public PropertyDetail findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<PropertyDetail> findAll() {
        return null;
    }

    @Override
    public PropertyDetail create(PropertyDetail propertyDetail) {
        return null;
    }

    @Override
    public void delete(PropertyDetail propertyDetail) {
    }

    @Override
    public PropertyDetail update(PropertyDetail propertyDetail) {
        return null;
    }
}

