/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.math.BigDecimal;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertySource;
import org.egov.ptis.exceptions.PropertyNotFoundException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;

public interface PropertyDAO {
    public Property getPropertyByID(String var1);

    public Property getPropertyByBasicPropertyID(BasicProperty var1);

    public List getAllNonDefaultProperties(BasicProperty var1);

    public List getAllProperties(BasicProperty var1);

    public List getOnlineDateByWardID(Integer var1);

    public Property getPropertyForInstallment(BasicProperty var1, Installment var2, PropertySource var3);

    public List getAllHistories(BasicProperty var1, PropertySource var2);

    public List getWardWiseProperties();

    public Property getPropertyBySource(String var1);

    public List getAllPropertiesForGivenBndryListAndSrc(List var1, String var2);

    public List getAllPropertiesForGivenBndryListSrcAndInst(List var1, String var2, Installment var3);

    public List getAllNonHistoryPropertiesForSrc(BasicProperty var1, PropertySource var2);

    public Property getPropertyBySrcAndBp(BasicProperty var1, PropertySource var2);

    public boolean checkIfPropCountExceeds500(List var1);

    public List getBasicPropertyListByDcNo(String var1) throws ApplicationRuntimeException;

    public List getPtDemandArvProposedList(Property var1);

    public Citizen getOwnerByOwnerId(Long var1);

    public List getPropertyDemand(String var1);

    public List getPropertyRebate(String var1);

    public List getPropertyCollection(String var1);

    public List getPTDemandArvByNoticeNumber(String var1);

    public List getPropsMrkdForDeactByWard(Boundary var1) throws PropertyNotFoundException;

    public List getPropMaterlizeViewList(Projection var1, Criterion var2, Order var3);

    public List getResultsList(Class var1, Projection var2, Criterion var3, Order var4);

    public List getResultsList(DetachedCriteria var1);

    public List getDmdCollAmtInstWise(EgDemand var1);

    public List getPenaltyDmdCollAmtInstWise(EgDemand var1);

    public List getDmdDetIdFromInstallandEgDemand(Installment var1, EgDemand var2);

    public BigDecimal getEgptPropertyFromBillId(Long var1);

    public List getAllDemands(BasicProperty var1);

    public List getDmdDetIdFromInstallandEgDemand(Installment var1, EgDemand var2, String var3);

    public List getDmdCollForAllDmdReasons(EgDemand var1);

    public Property findById(Integer var1, boolean var2);

    public List<Property> findAll();

    public Property create(Property var1);

    public void delete(Property var1);

    public Property update(Property var1);
}

