/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.ptis.domain.dao.property.BoundaryCategoryDao;
import org.egov.ptis.domain.entity.property.BoundaryCategory;
import org.egov.ptis.domain.entity.property.Category;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="boundaryCategoryDAO")
@Transactional(readOnly=true)
public class BoundaryCategoryHibDao
implements BoundaryCategoryDao {
    @PersistenceContext
    private EntityManager entityManager;
    public static final String BOUNDARY = "bndry";

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public Category getCategoryForBoundary(Boundary bndry) {
        Category category = null;
        Query qry = null;
        if (bndry != null) {
            qry = this.getCurrentSession().createQuery("select C from Category C inner join C.catBoundaries BC where BC.bndry = :bndry AND ((BC.toDate IS NULL AND BC.fromDate <= :currDate) OR (BC.fromDate <= :currDate AND BC.toDate >= :currDate)) ");
            qry.setEntity(BOUNDARY, (Object)bndry);
            qry.setDate("currDate", new Date());
            if (qry.list().size() == 1) {
                category = (Category)((Object)qry.uniqueResult());
            }
        }
        return category;
    }

    @Override
    public Category getCategoryForBoundaryAndDate(Boundary bndry, Date date) {
        Category category = null;
        Query qry = null;
        if (bndry != null && date != null) {
            qry = this.getCurrentSession().createQuery("select C from Category C inner join C.catBoundaries BC where BC.bndry = :bndry AND ((BC.toDate IS NULL AND BC.fromDate <= :date) OR (BC.fromDate <= :date AND BC.toDate >= :date)) ");
            qry.setEntity(BOUNDARY, (Object)bndry);
            qry.setDate("date", date);
            if (qry.list().size() == 1) {
                category = (Category)((Object)qry.uniqueResult());
            }
        }
        return category;
    }

    @Override
    public BoundaryCategory getBoundaryCategoryByBoundry(Boundary bndry) {
        BoundaryCategory bndryCategory = null;
        Query qry = null;
        if (bndry != null) {
            qry = this.getCurrentSession().createQuery("from BoundaryCategory BC where BC.bndry = :bndry AND ((BC.toDate IS NULL AND BC.fromDate <= :currDate) OR (BC.fromDate <= :currDate AND BC.toDate >= :currDate)) ");
            qry.setEntity(BOUNDARY, (Object)bndry);
            qry.setDate("currDate", new Date());
            if (qry.list().size() == 1) {
                bndryCategory = (BoundaryCategory)((Object)qry.uniqueResult());
            }
        }
        return bndryCategory;
    }

    @Override
    public BoundaryCategory getBoundaryCategoryByBoundryAndDate(Boundary bndry, Date date) {
        BoundaryCategory bndryCategory = null;
        Query qry = null;
        if (bndry != null && date != null) {
            qry = this.getCurrentSession().createQuery("from BoundaryCategory BC where BC.bndry = :bndry AND ((BC.toDate IS NULL AND BC.fromDate <= :date) OR (BC.fromDate <= :date AND BC.toDate >= :date)) ");
            qry.setEntity(BOUNDARY, (Object)bndry);
            qry.setDate("date", date);
            if (qry.list().size() == 1) {
                bndryCategory = (BoundaryCategory)((Object)qry.uniqueResult());
            }
        }
        return bndryCategory;
    }

    @Override
    public Category getCategoryByBoundryAndUsage(Boundary bndry, PropertyUsage propertyUsage) {
        Category category = null;
        Query qry = null;
        if (bndry != null && propertyUsage != null) {
            qry = this.getCurrentSession().createQuery("select C from Category C inner join C.catBoundaries BC where BC.bndry = :bndry and C.propUsage = :propertyUsage AND ((BC.toDate IS NULL AND BC.fromDate <= :currDate) OR (BC.fromDate <= :currDate AND BC.toDate >= :currDate)) ");
            qry.setEntity(BOUNDARY, (Object)bndry);
            qry.setEntity("propertyUsage", (Object)propertyUsage);
            qry.setDate("currDate", new Date());
            if (qry.list().size() == 1) {
                category = (Category)((Object)qry.uniqueResult());
            }
        }
        return category;
    }

    @Override
    public Category getCategoryByBoundryAndUsageAndDate(Boundary bndry, PropertyUsage propertyUsage, Date date) {
        Category category = null;
        Query qry = null;
        if (bndry != null && propertyUsage != null && date != null) {
            qry = this.getCurrentSession().createQuery("select C from Category C inner join C.catBoundaries BC where BC.bndry = :bndry and C.propUsage = :propertyUsage AND ((BC.toDate IS NULL AND BC.fromDate <= :date) OR (BC.fromDate <= :date AND BC.toDate >= :date)) ");
            qry.setEntity(BOUNDARY, (Object)bndry);
            qry.setEntity("propertyUsage", (Object)propertyUsage);
            qry.setDate("date", date);
            if (qry.list().size() == 1) {
                category = (Category)((Object)qry.uniqueResult());
            }
        }
        return category;
    }

    @Override
    public BoundaryCategory getBoundaryCategoryByBoundaryAndCategory(Criterion criterion) {
        Criteria criteria = this.getCurrentSession().createCriteria(BoundaryCategory.class);
        BoundaryCategory boundaryCategory = null;
        if (criterion != null) {
            LogicalExpression dateCondn1 = Restrictions.and((Criterion)Restrictions.le((String)"fromDate", (Object)new Date()), (Criterion)Restrictions.isNull((String)"toDate"));
            LogicalExpression dateCondn2 = Restrictions.and((Criterion)Restrictions.le((String)"fromDate", (Object)new Date()), (Criterion)Restrictions.ge((String)"toDate", (Object)new Date()));
            LogicalExpression dateCondn = Restrictions.or((Criterion)dateCondn1, (Criterion)dateCondn2);
            criteria.add(criterion);
            criteria.add((Criterion)dateCondn);
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            boundaryCategory = (BoundaryCategory)((Object)criteria.uniqueResult());
        }
        return boundaryCategory;
    }

    @Override
    public List<Category> getCategoriesByBoundry(Boundary bndry) {
        ArrayList<Category> list = new ArrayList();
        Query qry = this.getCurrentSession().createQuery("select bc.category from BoundaryCategory bc where bc.bndry =:Boundary");
        qry.setEntity("Boundary", (Object)bndry);
        list = qry.list();
        return list;
    }

    @Override
    public Category findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public Category create(Category category) {
        return null;
    }

    @Override
    public void delete(Category category) {
    }

    @Override
    public Category update(Category category) {
        return null;
    }

    @Override
    public List<Category> findAll() {
        return null;
    }
}

