/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.util;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PropertyTaxNumberGenerator {
    private static final String SEQ_EGPT_ASSESSMENT_NUMBER = "seq_egpt_assessment_number";
    private static final String SEQ_EGPT_NOTICE_NUMBER = "SEQ_EGPT_NOTICE_NUMBER";
    private static final String SEQ_EG_BILL = "SEQ_EG_BILL";
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private CityService cityService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;

    public String generateNoticeNumber(String noticeType) {
        StringBuffer noticeNo = new StringBuffer();
        try {
            if (StringUtils.isNotBlank((String)noticeType)) {
                if (noticeType.equalsIgnoreCase("Special Notice")) {
                    noticeNo.append("SN").append("/");
                } else if (noticeType.equalsIgnoreCase("Mutation Certificate")) {
                    noticeNo.append("MC").append("/");
                }
                String cityCode = ApplicationThreadLocals.getCityCode();
                noticeNo.append(cityCode);
                String index = this.sequenceNumberGenerator.getNextSequence(SEQ_EGPT_NOTICE_NUMBER).toString();
                noticeNo.append(StringUtils.leftPad((String)index, (int)6, (String)"0"));
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception : " + e.getMessage(), (Throwable)e);
        }
        return noticeNo.toString();
    }

    public String generateBillNumber(String wardNo) {
        StringBuffer billNo = new StringBuffer();
        Module module = this.moduleDao.getModuleByName("Property Tax");
        this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
        return billNo.toString();
    }

    public String generateManualBillNumber(PropertyID propertyID) {
        StringBuffer billNo = new StringBuffer();
        try {
            billNo.append("B").append("/");
            String cityCode = ((City)this.cityService.findAll().get(0)).getCode();
            billNo.append(cityCode);
            String bill = this.sequenceNumberGenerator.getNextSequence(SEQ_EG_BILL).toString();
            billNo.append(StringUtils.leftPad((String)bill, (int)6, (String)"0"));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception : " + e.getMessage(), (Throwable)e);
        }
        return billNo.toString();
    }

    public String generateRecoveryNotice(String noticeType) {
        StringBuffer noticeNo = new StringBuffer();
        return noticeNo.toString();
    }

    public String generateAssessmentNumber() {
        StringBuffer indexNum = new StringBuffer();
        try {
            String cityCode = ApplicationThreadLocals.getCityCode();
            indexNum.append(cityCode);
            String index = this.sequenceNumberGenerator.getNextSequence(SEQ_EGPT_ASSESSMENT_NUMBER).toString();
            indexNum.append(StringUtils.leftPad((String)index, (int)6, (String)"0"));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception : " + e.getMessage(), (Throwable)e);
        }
        return indexNum.toString();
    }

    public String generateMemoNumber() {
        return "";
    }

    public String getRejectionLetterSerialNum() {
        return "";
    }

    public String generateUnitIdentifierPrefix() {
        return null;
    }

    public void setSequenceNumberGenerator(SequenceNumberGenerator sequenceNumberGenerator) {
        this.sequenceNumberGenerator = sequenceNumberGenerator;
    }
}

