/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.client.bill.PenaltyBill;
import org.egov.ptis.client.service.Amount;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.RebatePeriod;
import org.egov.ptis.domain.service.property.RebatePeriodService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PenaltyCalculationService {
    private Logger LOGGER = LoggerFactory.getLogger(PenaltyCalculationService.class);
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    private static final BigDecimal VALUE_HUNDRED = new BigDecimal(100);
    private BasicProperty basicProperty;
    private Map<Installment, BigDecimal> installmentWiseDemand;
    private Map<Installment, BigDecimal> installmentWiseCollection;
    private Map<String, Date> installmentAndLatestCollDate;
    private Map<Installment, EgDemandDetails> installmentWisePenaltyDemandDetail;
    @Autowired
    private RebatePeriodService rebatePeriodService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    public PenaltyCalculationService() {
    }

    public PenaltyCalculationService(BasicProperty basicProperty, Map<Installment, BigDecimal> installmentWiseDemand, Map<Installment, BigDecimal> installmentWiseCollection, Map<String, Date> installmentAndLatestCollDate, Map<Installment, EgDemandDetails> installmentWisePenaltyDemandDetail) {
        this.basicProperty = basicProperty;
        this.installmentWiseDemand = installmentWiseDemand;
        this.installmentWiseCollection = installmentWiseCollection;
        this.installmentAndLatestCollDate = installmentAndLatestCollDate;
        this.installmentWisePenaltyDemandDetail = installmentWisePenaltyDemandDetail;
    }

    public Map<Installment, BigDecimal> getInstallmentWisePenalty() throws ValidationException {
        this.LOGGER.debug("Entered into getInstallmentWisePenalty, basicProperty={}", (Object)this.basicProperty);
        TreeMap<Installment, BigDecimal> installmentWisePenalty = new TreeMap<Installment, BigDecimal>();
        Map<Installment, Date> installmentWisePenaltyEffectiveDates = this.getPenaltyEffectiveDates(this.basicProperty, new ArrayList<Installment>(this.installmentWiseDemand.keySet()));
        if (installmentWisePenaltyEffectiveDates.isEmpty()) {
            this.LOGGER.debug("getInstallmentWisePenalty - installmentWisePenaltyEffectiveDates is empty");
            return null;
        }
        this.LOGGER.debug("getInstallmentWisePenalty - installmentWisePenaltyEffectiveDates={}", installmentWisePenaltyEffectiveDates);
        Installment installment = null;
        BigDecimal penalty = BigDecimal.ZERO;
        BigDecimal balancePenalty = BigDecimal.ZERO;
        EgDemandDetails penaltyDemandDetail = null;
        Amount balance = null;
        Amount installmentDemand = null;
        Amount installmentCollection = null;
        DateTime installmentLatestCollectionDate = null;
        DateTime today = new DateTime();
        for (Map.Entry<Installment, Date> mapEntry : installmentWisePenaltyEffectiveDates.entrySet()) {
            installment = mapEntry.getKey();
            penalty = BigDecimal.ZERO;
            installmentDemand = new Amount(this.installmentWiseDemand.get(installment));
            installmentCollection = new Amount(this.installmentWiseCollection.get(installment));
            installmentLatestCollectionDate = new DateTime((Object)this.installmentAndLatestCollDate.get(installment));
            if (!this.installmentWisePenaltyDemandDetail.isEmpty()) {
                penaltyDemandDetail = this.installmentWisePenaltyDemandDetail.get(installment);
            }
            if (mapEntry.getValue() != null && (balance = installmentDemand.minus(this.installmentWiseCollection.get(installment))).isGreaterThanZero()) {
                if (penaltyDemandDetail == null || installmentLatestCollectionDate == null) {
                    this.LOGGER.debug("getInstallmentWisePenalty - Penalty demand detail / collection date is null for {} ", (Object)installment);
                    penalty = this.calculatePenalty(mapEntry.getValue(), balance.getAmount());
                } else {
                    if (penaltyDemandDetail.getAmtCollected().compareTo(BigDecimal.ZERO) > 0) {
                        balancePenalty = penaltyDemandDetail.getAmount().subtract(penaltyDemandDetail.getAmtCollected());
                    }
                    penalty = installmentLatestCollectionDate.getMonthOfYear() == today.getMonthOfYear() && installmentLatestCollectionDate.getYear() == today.getYear() ? (balancePenalty.compareTo(BigDecimal.ZERO) > 0 ? balancePenalty : this.calculatePenalty(mapEntry.getValue(), balance.getAmount())) : this.calculatePenalty(mapEntry.getValue(), balance.getAmount()).add(balancePenalty);
                }
            }
            installmentWisePenalty.put(mapEntry.getKey(), penalty);
        }
        this.LOGGER.debug("getInstallmentWisePenalty, installmentWisePenalty={}", installmentWisePenalty);
        this.LOGGER.debug("Exiting from getInstallmentWisePenalty");
        return installmentWisePenalty;
    }

    private BigDecimal excludeWaterTax(Installment installment, BigDecimal balanceDemand, BigDecimal waterTax) {
        BigDecimal demand = balanceDemand;
        Date waterTaxEffectiveDate = PropertyTaxUtil.getWaterTaxEffectiveDateForPenalty();
        if (installment.getFromDate().before(waterTaxEffectiveDate) && !this.propertyTaxUtil.between(waterTaxEffectiveDate, installment.getFromDate(), installment.getToDate()).booleanValue()) {
            demand = demand.subtract(waterTax);
        }
        return demand;
    }

    public BigDecimal calculatePenalty(Date effectiveFrom, BigDecimal tax) {
        this.LOGGER.debug("Entered into calculatePenalty, effectiveFrom={} , tax={} ", (Object)effectiveFrom, (Object)tax);
        Integer noOfMonths = PropertyTaxUtil.getMonthsBetweenDates(effectiveFrom, new Date());
        BigDecimal penalty = BigDecimal.ZERO;
        if (noOfMonths > 0) {
            penalty = tax.multiply(PropertyTaxConstants.LP_PERCENTAGE_CONSTANT).divide(VALUE_HUNDRED).multiply(BigDecimal.valueOf(noOfMonths.intValue()));
        }
        this.LOGGER.debug("calcPanalty - before rounding -  noOfMonths={}, penalty={}", (Object)noOfMonths, (Object)penalty);
        penalty = MoneyUtils.roundOff((BigDecimal)penalty);
        this.LOGGER.debug("calcPanalty - after rounding -  noOfMonths={}, penalty={}", (Object)noOfMonths, (Object)penalty);
        this.LOGGER.debug("Exiting from calculatePenalty");
        return penalty;
    }

    private Map<Installment, Date> getPenaltyEffectiveDates(BasicProperty basicProperty, List<Installment> installments) throws ValidationException {
        Map<Installment, Date> installmentAndBillDate;
        this.LOGGER.debug("Entered into getPenaltyEffectiveDates, basicProperty={}, installments={}", (Object)basicProperty, installments);
        TreeMap<Installment, Date> installmentWisePenaltyEffectiveDate = new TreeMap<Installment, Date>();
        Date date22ndDay = this.get22ndDayDateAfter21DaysNoticeExpiry(basicProperty.getUpicNo());
        if (date22ndDay == null) {
            this.LOGGER.debug(" getPenaltyEffectiveDates, date22ndDay is null ");
        }
        Date earliestModificationDate = null;
        if (!basicProperty.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_APPLICATION)) {
            earliestModificationDate = this.propertyTaxUtil.getEarliestModificationDate(basicProperty.getUpicNo());
            this.LOGGER.debug(" getPenaltyEffectiveDates, earliestModificationDate={}", (Object)earliestModificationDate);
        }
        if ((installmentAndBillDate = this.getAllBillGenerationDates(basicProperty, installments)) != null && !installmentAndBillDate.isEmpty()) {
            Map<Installment, Date> installmentAnd90DaysDate = this.get90DaysDate(installmentAndBillDate, date22ndDay);
            this.LOGGER.debug("getPenaltyEffectiveDates - installmentAndLatestCollDate={}", this.installmentAndLatestCollDate);
            Date latestCollectionDate = null;
            Installment installment = null;
            Date dateOn91stDay = null;
            Date penaltyEffectiveDate = null;
            for (Map.Entry<Installment, Date> mapEntry : installmentAnd90DaysDate.entrySet()) {
                installment = mapEntry.getKey();
                dateOn91stDay = mapEntry.getValue();
                penaltyEffectiveDate = null;
                if (earliestModificationDate != null && installment.getFromDate().before(earliestModificationDate) && installment.getToDate().before(earliestModificationDate)) continue;
                latestCollectionDate = this.installmentAndLatestCollDate.get(installment.getDescription());
                if (dateOn91stDay == null) {
                    if (this.isRolloverInstallment(installment)) {
                        penaltyEffectiveDate = this.getPenaltyEffectiveForRolloverInstallment(latestCollectionDate, installment.getFromDate());
                    }
                } else {
                    penaltyEffectiveDate = latestCollectionDate != null && latestCollectionDate.after(dateOn91stDay) ? this.getPenaltyEffectiveForRolloverInstallment(latestCollectionDate, installment.getFromDate()) : this.getPenaltyEffectiveDate(dateOn91stDay);
                }
                installmentWisePenaltyEffectiveDate.put(installment, penaltyEffectiveDate);
            }
        }
        this.LOGGER.debug("getPenaltyEffectiveDates - installmentWisePenaltyEffectiveDate={}", installmentWisePenaltyEffectiveDate);
        this.LOGGER.debug("Exiting from getPenaltyEffectiveDates");
        return installmentWisePenaltyEffectiveDate;
    }

    public Map<Installment, Date> getAllBillGenerationDates(BasicProperty basicProperty, List<Installment> installments) throws ValidationException {
        TreeMap<Installment, Date> installmentAndBillDate = new TreeMap<Installment, Date>();
        String upicNo = basicProperty.getUpicNo();
        String noBillMessage = "Bill is not available penalty calculation for " + upicNo;
        String query = "select notice from EgBill bill, PtNotice notice left join notice.basicProperty bp where bill.is_Cancelled = 'N' and bill.egBillType.code = :billTypeCode and bill.billNo = notice.noticeNo and notice.noticeType = :noticeType and bp.upicNo = :upicNo order by notice.noticeDate";
        List demandBills = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setString("billTypeCode", "MANUAL").setString("noticeType", "Bill").setString("upicNo", upicNo).list();
        if (demandBills.isEmpty()) {
            this.LOGGER.debug("getAllBillGenerationDates - {}", (Object)noBillMessage);
        }
        TreeMap<Date, Date> propertyCreatedAndOccupancyDate = new TreeMap<Date, Date>();
        ArrayList<Date> propertySystemCreatedDates = new ArrayList<Date>();
        ArrayList<Object> occupancyDates = new ArrayList();
        for (Map.Entry<Date, Property> entry : this.propertyTaxUtil.getPropertiesForPenlatyCalculation(basicProperty).entrySet()) {
            propertySystemCreatedDates.add(entry.getValue().getCreatedDate());
            propertyCreatedAndOccupancyDate.put(entry.getValue().getCreatedDate(), entry.getKey());
        }
        occupancyDates = new ArrayList(propertyCreatedAndOccupancyDate.values());
        this.LOGGER.info("getAllBillGenerationDates - propertySystemCreatedDates=" + propertySystemCreatedDates + ", occupancyDates=" + occupancyDates);
        int noOfEffects = propertySystemCreatedDates.size();
        Date createdDate = null;
        Date occupancyDate = null;
        Date nextOccupancyDate = null;
        Date nextCreatedDate = null;
        Date billDate = null;
        int j = 0;
        ArrayList<PenaltyBill> billDetails = new ArrayList<PenaltyBill>();
        Calendar fromDateCalendar = Calendar.getInstance();
        Calendar billDateCalendar = Calendar.getInstance();
        fromDateCalendar.set(5, 1);
        fromDateCalendar.set(2, 3);
        fromDateCalendar.set(11, 0);
        fromDateCalendar.set(12, 0);
        fromDateCalendar.set(13, 0);
        fromDateCalendar.set(14, 0);
        if (!demandBills.isEmpty()) {
            for (int i = 0; i < noOfEffects; ++i) {
                createdDate = (Date)propertySystemCreatedDates.get(i);
                occupancyDate = (Date)occupancyDates.get(i);
                Date date = nextCreatedDate = i != noOfEffects - 1 ? (Date)propertySystemCreatedDates.get(i + 1) : null;
                if (demandBills.isEmpty()) break;
                billDate = ((PtNotice)demandBills.get(j)).getNoticeDate();
                if (billDate.before(createdDate)) {
                    demandBills.remove(j);
                    --i;
                    continue;
                }
                if (!PropertyTaxUtil.afterOrEqual(billDate, createdDate) || nextCreatedDate != null && !billDate.before(nextCreatedDate)) continue;
                billDetails.add(new PenaltyBill(createdDate, occupancyDate, billDate, false));
                demandBills.remove(j);
            }
        }
        j = 0;
        if (!demandBills.isEmpty()) {
            for (j = 0; j < demandBills.size(); ++j) {
                billDate = ((PtNotice)demandBills.get(j)).getNoticeDate();
                billDateCalendar.setTime(billDate);
                fromDateCalendar.set(1, billDateCalendar.get(1));
                billDetails.add(new PenaltyBill(fromDateCalendar.getTime(), fromDateCalendar.getTime(), billDate, true));
            }
        }
        Collections.sort(billDetails, new Comparator<PenaltyBill>(){

            @Override
            public int compare(PenaltyBill bill1, PenaltyBill bill2) {
                return bill1.getBillDate().compareTo(bill2.getBillDate());
            }
        });
        int totalBills = billDetails.size();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        block3: for (int i = 0; i < totalBills; ++i) {
            createdDate = ((PenaltyBill)billDetails.get(i)).getCreatedDate();
            occupancyDate = ((PenaltyBill)billDetails.get(i)).getOccupancyDate();
            nextOccupancyDate = i == totalBills - 1 ? null : ((PenaltyBill)billDetails.get(i + 1)).getOccupancyDate();
            for (Installment installment : installments) {
                if (((PenaltyBill)billDetails.get(i)).getIsBillGeneratedAfterRollover()) {
                    if (!dateFormat.format(installment.getFromDate()).equalsIgnoreCase(dateFormat.format(createdDate))) continue;
                    installmentAndBillDate.put(installment, null);
                    continue;
                }
                if (nextOccupancyDate != null && this.propertyTaxUtil.between(nextOccupancyDate, installment.getFromDate(), installment.getToDate()).booleanValue()) continue block3;
                if (!PropertyTaxUtil.afterOrEqual(createdDate, installment.getFromDate()) || ((PenaltyBill)billDetails.get(i)).getIsBillGeneratedAfterRollover() || !this.propertyTaxUtil.between(occupancyDate, installment.getFromDate(), installment.getToDate()).booleanValue() && !PropertyTaxUtil.afterOrEqual(installment.getFromDate(), occupancyDate) || nextOccupancyDate != null && !installment.getFromDate().before(nextOccupancyDate)) continue;
                installmentAndBillDate.put(installment, ((PenaltyBill)billDetails.get(i)).getBillDate());
            }
        }
        for (Installment installment : installments) {
            if (installmentAndBillDate.get(installment) != null) continue;
            installmentAndBillDate.put(installment, null);
        }
        this.LOGGER.info("getAllBillGenerationDates - installmentAndBillDate={}", installmentAndBillDate);
        return installmentAndBillDate;
    }

    private Date getApplicableBillDate(int i, int j, Installment installment, List<Date> createdDates, List<Date> occupancyDates, List<PtNotice> demandBills) {
        Date nextBillDate;
        Date applicableBillDate = null;
        Date createdDate = createdDates.get(i);
        Date nextCreatedDate = i != createdDates.size() - 1 ? createdDates.get(i + 1) : null;
        Date occupancyDate = occupancyDates.get(i);
        Date nextOccupancyDate = nextCreatedDate == null ? null : occupancyDates.get(i + 1);
        Date billDate = demandBills.get(j).getNoticeDate();
        Date date = nextBillDate = j != demandBills.size() - 1 ? demandBills.get(j + 1).getNoticeDate() : null;
        if (nextBillDate == null) {
            applicableBillDate = billDate;
        } else if (!this.propertyTaxUtil.between(nextBillDate, installment.getFromDate(), installment.getToDate()).booleanValue() && PropertyTaxUtil.afterOrEqual(billDate, createdDate) && billDate.before(nextCreatedDate) && (installment.getFromDate().before(billDate) || this.propertyTaxUtil.between(billDate, installment.getFromDate(), installment.getToDate()).booleanValue()) && PropertyTaxUtil.afterOrEqual(installment.getFromDate(), occupancyDate) && (nextOccupancyDate == null || installment.getFromDate().before(nextOccupancyDate))) {
            applicableBillDate = billDate;
            createdDates.remove(i);
            occupancyDates.remove(i);
            demandBills.remove(j);
        }
        return applicableBillDate;
    }

    public Map<Installment, Date> get90DaysDate(Map<Installment, Date> installmentAndBillDate, Date dateAfter21Days) {
        TreeMap<Installment, Date> installmentAnd90DaysDate = new TreeMap<Installment, Date>();
        Date date = null;
        Date dateOn91stDay = null;
        for (Map.Entry<Installment, Date> mapEntry : installmentAndBillDate.entrySet()) {
            date = mapEntry.getValue();
            dateOn91stDay = null;
            if (date != null) {
                date = dateAfter21Days == null ? date : (dateAfter21Days.after(date) ? dateAfter21Days : date);
                dateOn91stDay = DateUtils.add((Date)date, (int)5, (int)91);
            }
            installmentAnd90DaysDate.put(mapEntry.getKey(), dateOn91stDay);
        }
        return installmentAnd90DaysDate;
    }

    public Date get22ndDayDateAfter21DaysNoticeExpiry(String propertyId) {
        this.LOGGER.debug("Entered into get22ndDayDateAfter21DaysNoticeExpiry, propertyId={}", (Object)propertyId);
        String notice127And134 = "'Notice 127', 'Notice 134'";
        String stringQuery = "select to_char(n.noticeDate, 'dd/mm/yyyy'), to_char(pvr.noticeDate, 'dd/mm/yyyy'), to_char(p.createdDate, 'dd/mm/yyyy') from PtNotice n, PtNotice pvr, PropertyImpl p left join p.basicProperty bp where n.basicProperty = bp and pvr.basicProperty = bp and (p.status = 'A' or p.status = 'I') and bp.upicNo = :upicNo and bp.status.statusCode <> :bpStatus and n.noticeType in (" + notice127And134 + ") " + "and pvr.noticeType = :noticePVR " + "and n.noticeDate > p.createdDate " + "and pvr.noticeDate > p.createdDate " + " and n.noticeDate is not null " + "and pvr.noticeDate is not null ";
        List result = ((Session)this.entityManager.unwrap(Session.class)).createQuery(stringQuery).setString("upicNo", propertyId).setString("bpStatus", "OBJECTED").setString("noticePVR", "Prativrutta").list();
        if (result.isEmpty()) {
            return null;
        }
        Date noticeDate = null;
        Date pvrDate = null;
        Object row = result.get(0);
        Object[] columnValues = (Object[])row;
        try {
            noticeDate = this.dateFormatter.parse((String)columnValues[0]);
            pvrDate = this.dateFormatter.parse((String)columnValues[1]);
        }
        catch (ParseException pe) {
            this.LOGGER.error("Error while parsing notice/pvr date", (Throwable)pe);
            throw new ApplicationRuntimeException("Error while parsing notice/pvr date", (Throwable)pe);
        }
        Date dateOn22ndDay = DateUtils.add((Date)(noticeDate.before(pvrDate) ? pvrDate : noticeDate), (int)5, (int)21);
        this.LOGGER.debug("get22ndDayDateAfter21DaysNoticeExpiry, dateOn22ndDay={}", (Object)dateOn22ndDay);
        this.LOGGER.debug("Exiting from get22ndDayDateAfter21DaysNoticeExpiry");
        return dateOn22ndDay;
    }

    public Date getPenaltyEffectiveDate(Date dateAfterNoticeDaysExpiry) {
        this.LOGGER.debug("Entered into getPenaltyEffectiveDate, dateAfterNoticeDaysExpiry={}", (Object)dateAfterNoticeDaysExpiry);
        Date penaltyEffectiveDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateAfterNoticeDaysExpiry);
        if (calendar.get(5) <= 15) {
            penaltyEffectiveDate = dateAfterNoticeDaysExpiry;
        } else {
            calendar.add(2, 1);
            penaltyEffectiveDate = calendar.getTime();
        }
        this.LOGGER.debug("getPenaltyEffectiveDate, penaltyEffectiveDate={}", (Object)penaltyEffectiveDate);
        this.LOGGER.debug("Exting from getPenaltyEffectiveDate");
        return penaltyEffectiveDate;
    }

    public Date getPenaltyEffectiveForRolloverInstallment(Date latestCollReceiptDate, Date fromDate) {
        this.LOGGER.info("Enter into calcPanalty - latestCollReceiptDate: " + latestCollReceiptDate + ", fromDate " + fromDate);
        Calendar fromDateCalendar = Calendar.getInstance();
        fromDateCalendar.setTime(fromDate);
        Calendar arrearsPenaltyApplicableDate = Calendar.getInstance();
        arrearsPenaltyApplicableDate.set(5, 1);
        arrearsPenaltyApplicableDate.set(2, 0);
        arrearsPenaltyApplicableDate.set(11, 0);
        arrearsPenaltyApplicableDate.set(12, 0);
        arrearsPenaltyApplicableDate.set(13, 0);
        Calendar latestCollRcptCalendar = Calendar.getInstance();
        if (latestCollReceiptDate != null) {
            latestCollRcptCalendar.setTime(latestCollReceiptDate);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date arrearlpDate = null;
        Date arrearlpDateBreakup = null;
        Date frmDate = null;
        try {
            arrearlpDate = dateFormat.parse("01/06/2010");
            arrearlpDateBreakup = dateFormat.parse("01/04/2010");
            frmDate = dateFormat.parse(dateFormat.format(fromDate));
        }
        catch (ParseException e) {
            this.LOGGER.error("Error while parsing Arrear Late Payment penalty dates", (Throwable)e);
        }
        Date penaltyFromDate = null;
        if (latestCollReceiptDate != null && latestCollReceiptDate.after(frmDate) && latestCollReceiptDate.after(arrearlpDateBreakup)) {
            latestCollRcptCalendar.add(2, 1);
            arrearsPenaltyApplicableDate.setTime(latestCollRcptCalendar.getTime());
            penaltyFromDate = arrearsPenaltyApplicableDate.getTime();
        } else if (frmDate.after(arrearlpDateBreakup) || frmDate.equals(arrearlpDateBreakup)) {
            arrearsPenaltyApplicableDate.set(1, fromDateCalendar.get(1) + 1);
            penaltyFromDate = arrearsPenaltyApplicableDate.getTime();
        } else {
            penaltyFromDate = arrearlpDate;
        }
        this.LOGGER.info("calcPanalty - penaltyFromDate: " + penaltyFromDate);
        return penaltyFromDate;
    }

    private boolean isRolloverInstallment(Installment installment) {
        Date systemCreatedDate = this.basicProperty.getProperty().getCreatedDate();
        return this.propertyTaxUtil.between(new Date(), installment.getFromDate(), installment.getToDate()) != false && this.propertyTaxUtil.between(systemCreatedDate, installment.getFromDate(), installment.getToDate()) == false;
    }

    public Map<String, Map<Installment, BigDecimal>> getInstallmentDemandAndCollection(BasicProperty basicProperty, EgDemand currentDemand) {
        TreeMap<String, Map<Installment, BigDecimal>> installmentDemandAndCollection = new TreeMap();
        Property property = null;
        property = basicProperty.getProperty();
        Installment currentInstall = currentDemand.getEgInstallmentMaster();
        installmentDemandAndCollection = this.propertyTaxUtil.prepareReasonWiseDenandAndCollection(property, currentInstall);
        return installmentDemandAndCollection;
    }

    public Map<Installment, EgDemandDetails> getInstallmentWisePenaltyDemandDetails(Property property, EgDemand currentDemand) {
        TreeMap<Installment, EgDemandDetails> installmentWisePenaltyDemandDetails = new TreeMap<Installment, EgDemandDetails>();
        for (EgDemandDetails dmdDet : currentDemand.getEgDemandDetails()) {
            if (!dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES") || dmdDet.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            installmentWisePenaltyDemandDetails.put(dmdDet.getEgDemandReason().getEgInstallmentMaster(), dmdDet);
        }
        return installmentWisePenaltyDemandDetails;
    }

    public boolean isEarlyPayRebateActive() {
        boolean value = false;
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        RebatePeriod rebatePeriod = this.rebatePeriodService.getRebateForCurrInstallment(currentInstallment.getId());
        if (rebatePeriod != null && rebatePeriod.getRebateDate().compareTo(new Date()) > 0) {
            value = true;
        }
        return value;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }
}

