/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.firm;

import org.egov.portal.entity.Firm;
import org.egov.portal.firm.service.FirmService;
import org.egov.portal.web.controller.firm.BaseFirmController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/firm"})
public class UpdateFirmController
extends BaseFirmController {
    @Autowired
    private FirmService firmService;

    @GetMapping(value={"/update/{firmId}"})
    public String updateFirm(Model model, @PathVariable String firmId) {
        Firm firm = this.firmService.getFirmById(Long.valueOf(Long.parseLong(firmId)));
        firm.setTempFirmUsers(firm.getFirmUsers());
        model.addAttribute("firm", (Object)firm);
        model.addAttribute("mode", (Object)"edit");
        return "firm-update";
    }

    @PostMapping(value={"/update"})
    public String update(@ModelAttribute Firm firm, BindingResult resultBinder, Model model) {
        this.validateFirm(firm, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("firm", (Object)firm);
            return "firm-update";
        }
        this.firmService.createFirm(firm);
        Long firmId = firm.getId();
        return "redirect:/firm/firm-success?firmId=" + firmId;
    }
}

