/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.firm;

import javax.validation.Valid;
import org.egov.portal.entity.Firm;
import org.egov.portal.firm.service.FirmService;
import org.egov.portal.web.controller.firm.BaseFirmController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/firm"})
public class CreateFirmController
extends BaseFirmController {
    @Autowired
    private FirmService firmService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @GetMapping(value={"/create"})
    public String showNewForm(Model model) {
        Firm firm = new Firm();
        firm.setTempFirmUsers(firm.getFirmUsers());
        model.addAttribute("firm", (Object)firm);
        return "firm-create";
    }

    @PostMapping(value={"/create"})
    public String create(@Valid @ModelAttribute Firm firm, BindingResult resultBinder, Model model) {
        this.validateEmail(firm, resultBinder, "create");
        if (resultBinder.hasErrors()) {
            model.addAttribute("firm", (Object)firm);
            return "firm-create";
        }
        this.firmService.createFirm(firm);
        Long firmId = firm.getId();
        return "redirect:/firm/firm-success?firmId=" + firmId;
    }

    @RequestMapping(value={"/firm-success"}, method={RequestMethod.GET})
    public String successView(Model model, @RequestParam String firmId) {
        Firm firm = this.firmService.getFirmById(Long.valueOf(firmId));
        model.addAttribute("firm", (Object)firm);
        model.addAttribute("success", (Object)this.messageSource.getMessage("msg.firm.create.success", (Object[])new String[]{firm.getName()}, null));
        return "firm-success";
    }
}

