/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.firm;

import org.egov.portal.entity.Firm;
import org.egov.portal.entity.FirmUser;
import org.egov.portal.firm.service.FirmService;
import org.egov.portal.firm.service.FirmUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;

@Controller
public abstract class BaseFirmController {
    @Autowired
    private FirmService firmService;
    @Autowired
    private FirmUserService firmUserService;

    protected void validateFirm(Firm firm, BindingResult resultBinder) {
        Firm exitingFirm;
        this.validateFirmHeader(firm, resultBinder);
        if (firm.getPan() != null && (exitingFirm = this.firmService.getFirmByPan(firm.getPan())) != null && firm.getId() != null && !exitingFirm.getId().equals(firm.getId())) {
            resultBinder.reject("error.firm.pan.unique", "error.firm.pan.unique");
        }
        this.validateEmail(firm, resultBinder, "update");
    }

    protected void validateFirmHeader(Firm firm, BindingResult resultBinder) {
        if (firm.getTempFirmUsers() == null) {
            resultBinder.reject("error.firm.altleastone.overusers.needed", "error.firm.altleastone.firmusers.needed");
        }
        if (firm.getName() == null) {
            resultBinder.reject("error.firm.firmname", "error.firm.firmname");
        }
        if (firm.getPan() == null) {
            resultBinder.reject("error.firm.pan", "error.firm.pan");
        }
    }

    protected void validateEmail(Firm firm, BindingResult resultBinder, String mode) {
        int index = 0;
        for (FirmUser firmUsers : firm.getTempFirmUsers()) {
            FirmUser existingFirmUser;
            if (firmUsers.getEmailId() != null && !firmUsers.getEmailId().matches("^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$")) {
                resultBinder.rejectValue("tempFirmUsers[" + index + "].emailId", "error.firm.emailid");
            }
            if (firmUsers.getMobileNumber() != null && firmUsers.getMobileNumber().length() != 10) {
                resultBinder.rejectValue("tempFirmUsers[" + index + "].mobileNumber", "Pattern.citizen.mobileNumber");
            }
            if (firmUsers.getEmailId() != null && firmUsers.getId() != null && mode.equalsIgnoreCase("update") && (existingFirmUser = this.firmUserService.getFirmUserByEmail(firmUsers.getEmailId())) != null && !existingFirmUser.getId().equals(firmUsers.getId())) {
                resultBinder.rejectValue("tempFirmUsers[" + index + "].emailId", "error.firm.email.exist");
            }
            if (firmUsers.getEmailId() != null && mode.equalsIgnoreCase("create") && (existingFirmUser = this.firmUserService.getFirmUserByEmail(firmUsers.getEmailId())) != null) {
                resultBinder.rejectValue("tempFirmUsers[" + index + "].emailId", "error.firm.email.exist");
            }
            ++index;
        }
    }
}

