/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.citizen;

import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.portal.entity.CitizenInbox;
import org.egov.portal.service.CitizenInboxService;
import org.egov.portal.service.PortalInboxUserService;
import org.egov.portal.service.PortalServiceTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/home"})
public class HomeController {
    @Autowired
    private CitizenInboxService citizenInboxService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PortalInboxUserService portalInboxUserService;
    @Autowired
    private PortalServiceTypeService portalServiceTypeService;
    @Autowired
    private CityService cityService;

    @RequestMapping(method={RequestMethod.GET})
    public String showHomePage(ModelMap modelData) {
        return this.setupHomePage(modelData);
    }

    @RequestMapping(value={"/refreshInbox"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer refreshInbox(@RequestParam Long citizenInboxId) {
        CitizenInbox citizenInbox = this.citizenInboxService.getInboxMessageById(citizenInboxId);
        citizenInbox.setRead(true);
        this.citizenInboxService.updateMessage(citizenInbox);
        return this.citizenInboxService.findUnreadMessagesCount(this.securityUtils.getCurrentUser());
    }

    private String setupHomePage(ModelMap modelData) {
        User user = this.securityUtils.getCurrentUser();
        modelData.addAttribute("unreadMessageCount", (Object)this.getUnreadMessageCount());
        modelData.addAttribute("inboxMessages", (Object)this.getAllInboxMessages());
        modelData.addAttribute("myAccountMessages", (Object)this.getMyAccountMessages());
        modelData.addAttribute("cityLogo", (Object)this.cityService.getCityLogoPath());
        modelData.addAttribute("cityName", (Object)this.cityService.getMunicipalityName());
        modelData.addAttribute("userName", (Object)(user.getName() == null ? "Anonymous" : user.getName()));
        modelData.addAttribute("moduleNames", (Object)this.portalServiceTypeService.getDistinctModuleNames());
        modelData.addAttribute("services", (Object)this.portalServiceTypeService.getAllPortalService());
        modelData.addAttribute("distinctModuleNames", (Object)this.portalServiceTypeService.getAllModules());
        modelData.addAttribute("userId", (Object)user.getId());
        List totalServicesApplied = this.portalInboxUserService.getPortalInboxByUserId(user.getId());
        List totalServicesCompleted = this.portalInboxUserService.getPortalInboxByResolved(user.getId(), true);
        List totalServicesPending = this.portalInboxUserService.getPortalInboxByResolved(user.getId(), false);
        modelData.addAttribute("totalServicesPending", (Object)totalServicesPending);
        modelData.addAttribute("totalServicesApplied", (Object)totalServicesApplied);
        modelData.addAttribute("totalServicesCompleted", (Object)totalServicesCompleted);
        modelData.addAttribute("totalServicesPendingSize", (Object)totalServicesPending.size());
        modelData.addAttribute("totalServicesAppliedSize", (Object)totalServicesApplied.size());
        modelData.addAttribute("totalServicesCompletedSize", (Object)totalServicesCompleted.size());
        return "citizen-home";
    }

    private List<CitizenInbox> getMyAccountMessages() {
        return this.citizenInboxService.findMyAccountMessages(this.securityUtils.getCurrentUser());
    }

    private List<CitizenInbox> getAllInboxMessages() {
        return this.citizenInboxService.findAllInboxMessage(this.securityUtils.getCurrentUser());
    }

    private Integer getUnreadMessageCount() {
        return this.citizenInboxService.findUnreadMessagesCount(this.securityUtils.getCurrentUser());
    }
}

