/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.servicetype;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.utils.JsonUtils;
import org.egov.portal.entity.PortalServiceType;
import org.egov.portal.service.PortalServiceTypeService;
import org.egov.portal.web.adaptor.SearchPortalServiceTypeJasonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/portalservicetype"})
public class PortalServiceTypeController {
    private static final String PORTAL_EDIT = "portalservicetype-edit";
    private static final String PORTAL_ACK = "portalservicetype-ack";
    @Autowired
    private PortalServiceTypeService portalServiceTypeService;

    @RequestMapping(value={"/ajaxboundary-servicesbymodule"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getServiceNames(@RequestParam Long moduleId) {
        return this.portalServiceTypeService.findAllServiceTypes(moduleId);
    }

    @GetMapping(value={"/search"})
    public String searchPortalServiceType(Model model) throws ApplicationException {
        model.addAttribute("portalServiceType", (Object)new PortalServiceType());
        model.addAttribute("modules", (Object)this.portalServiceTypeService.getAllModules());
        return "portalservicetype-search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchPortalServiceTypeToModify(@RequestParam Long module, @RequestParam String name) {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.portalServiceTypeService.searchPortalServiceType(module, name), PortalServiceType.class, SearchPortalServiceTypeJasonAdaptor.class) + "}";
    }

    @GetMapping(value={"/update/{id}"})
    public String updatePortalServiceType(@PathVariable Long id, Model model) throws IOException {
        PortalServiceType portalServiceType = this.portalServiceTypeService.getPortalServiceTypeById(id);
        model.addAttribute("portalServiceType", (Object)portalServiceType);
        model.addAttribute("mode", (Object)"edit");
        return PORTAL_EDIT;
    }

    @PostMapping(value={"/update"})
    public String update(@ModelAttribute PortalServiceType portalServiceType, Model model) {
        this.portalServiceTypeService.update(portalServiceType);
        model.addAttribute("name", (Object)portalServiceType.getName());
        return PORTAL_ACK;
    }
}

