/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.firm;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.utils.JsonUtils;
import org.egov.portal.entity.Firm;
import org.egov.portal.entity.SearchRequestFirm;
import org.egov.portal.firm.service.FirmService;
import org.egov.portal.web.adaptor.SearchFirmJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/firm"})
public class SearchFirmController {
    @Autowired
    private FirmService firmService;

    @RequestMapping(value={"/view/{firmId}"}, method={RequestMethod.GET})
    public String viewFirm(@PathVariable String firmId, Model model) throws ApplicationException {
        Firm firm = this.firmService.getFirmById(Long.valueOf(firmId));
        model.addAttribute("firm", (Object)firm);
        return "firm-success";
    }

    @GetMapping(value={"/search"})
    public String searchFirm(@ModelAttribute SearchRequestFirm searchRequestFirm, Model model, HttpServletRequest request) throws ApplicationException {
        model.addAttribute("searchRequestFirm", (Object)searchRequestFirm);
        model.addAttribute("mode", (Object)request.getParameter("mode"));
        return "firm-search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchFirmToModify(Model model, @ModelAttribute SearchRequestFirm searchRequestFirm) {
        return "{ \"data\":" + JsonUtils.toJSON((Collection)this.firmService.searchFirm(searchRequestFirm), Firm.class, SearchFirmJsonAdaptor.class) + "}";
    }
}

