/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.citizen;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.portal.entity.CitizenInbox;
import org.egov.portal.service.CitizenInboxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/home"})
public class HomeController {
    @Autowired
    private CitizenInboxService citizenInboxService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ApplicationProperties applicationProperties;

    @RequestMapping(method={RequestMethod.GET})
    public String LoginForm(HttpServletRequest request, HttpSession session, ModelMap modelData) {
        return this.setupHomePage(request, session, modelData);
    }

    @RequestMapping(value={"/refreshInbox"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer refreshInbox(@RequestParam Long citizenInboxId) {
        CitizenInbox citizenInbox = this.citizenInboxService.getInboxMessageById(citizenInboxId);
        citizenInbox.setRead(true);
        this.citizenInboxService.updateMessage(citizenInbox);
        return this.citizenInboxService.findUnreadMessagesCount(this.securityUtils.getCurrentUser());
    }

    private String setupHomePage(HttpServletRequest request, HttpSession session, ModelMap modelData) {
        User user = this.securityUtils.getCurrentUser();
        modelData.addAttribute("userName", (Object)user.getName());
        modelData.addAttribute("unreadMessageCount", (Object)this.getUnreadMessageCount());
        modelData.addAttribute("inboxMessages", (Object)this.getAllInboxMessages());
        modelData.addAttribute("myAccountMessages", (Object)this.getMyAccountMessages());
        modelData.addAttribute("cityLogo", session.getAttribute("citylogo"));
        modelData.addAttribute("cityName", session.getAttribute("citymunicipalityname"));
        modelData.addAttribute("enabledFeatures", (Object)this.applicationProperties.portalEnabledFeatures());
        modelData.addAttribute("userName", (Object)(user.getName() == null ? "Anonymous" : user.getName()));
        return "citizen-home";
    }

    private List<CitizenInbox> getMyAccountMessages() {
        return this.citizenInboxService.findMyAccountMessages(this.securityUtils.getCurrentUser());
    }

    private List<CitizenInbox> getAllInboxMessages() {
        return this.citizenInboxService.findAllInboxMessage(this.securityUtils.getCurrentUser());
    }

    private Integer getUnreadMessageCount() {
        return this.citizenInboxService.findUnreadMessagesCount(this.securityUtils.getCurrentUser());
    }
}

