/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.web.controller.citizen;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.security.utils.RecaptchaUtils;
import org.egov.infra.validation.ValidatorUtils;
import org.egov.portal.entity.Citizen;
import org.egov.portal.service.CitizenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/citizen"})
public class CitizenRegistrationController {
    private final CitizenService citizenService;
    @Autowired
    private ValidatorUtils validatorUtils;

    @Autowired
    public CitizenRegistrationController(CitizenService citizenService) {
        this.citizenService = citizenService;
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.GET})
    public String registerCitizen(@ModelAttribute Citizen citizen) {
        return "signup";
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public String registerCitizen(@Valid @ModelAttribute Citizen citizen, BindingResult errors, HttpServletRequest request, RedirectAttributes redirectAttrib) {
        if (!this.validatorUtils.isValidPassword(citizen.getPassword())) {
            errors.rejectValue("password", "error.pwd.invalid");
        } else if (!StringUtils.equals((CharSequence)citizen.getPassword(), (CharSequence)request.getParameter("con-password"))) {
            errors.rejectValue("password", "error.pwd.mismatch");
        }
        if (!RecaptchaUtils.captchaIsValid((HttpServletRequest)request)) {
            errors.rejectValue("active", "error.recaptcha.verification");
        }
        if (errors.hasErrors()) {
            return "signup";
        }
        this.citizenService.create(citizen);
        redirectAttrib.addAttribute("message", (Object)"msg.reg.success");
        return "redirect:register?activation=true";
    }

    @RequestMapping(value={"/activation"}, method={RequestMethod.POST})
    public String citizenOTPActivation(@RequestParam String activationCode) {
        return "redirect:register?activation=true&activated=" + (this.citizenService.activateCitizen(activationCode) != null);
    }
}

