/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.service;

import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.portal.entity.CitizenInbox;
import org.egov.portal.entity.enums.MessageType;
import org.egov.portal.repository.CitizenInboxRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CitizenInboxService {
    private final CitizenInboxRepository citizenInboxRepository;

    @Autowired
    public CitizenInboxService(CitizenInboxRepository citizenInboxRepository) {
        this.citizenInboxRepository = citizenInboxRepository;
    }

    @Transactional
    public void pushMessage(CitizenInbox citizenInbox) {
        this.citizenInboxRepository.save((Object)citizenInbox);
    }

    public Integer findUnreadMessagesCount(User citizenUser) {
        return this.citizenInboxRepository.findUnreadMessagesCount(citizenUser.getId());
    }

    public List<CitizenInbox> findAllInboxMessage(User citizenUser) {
        return this.citizenInboxRepository.findAllInboxMessage(citizenUser.getId());
    }

    public List<CitizenInbox> findAllUserMessages(User citizenUser) {
        return this.citizenInboxRepository.findAllInboxMessageByType(MessageType.USER_MESSAGE, citizenUser.getId());
    }

    public List<CitizenInbox> findAllSystemMessages(User citizenUser) {
        return this.citizenInboxRepository.findAllInboxMessageByType(MessageType.SYSTEM_MESSAGE, citizenUser.getId());
    }

    public List<CitizenInbox> findMyAccountMessages(User citizenUser) {
        return this.citizenInboxRepository.findMyAccountMessages(MessageType.USER_MESSAGE, citizenUser.getId());
    }

    @Transactional
    public void updateMessage(CitizenInbox citizenInbox) {
        this.citizenInboxRepository.save((Object)citizenInbox);
    }

    public CitizenInbox getInboxMessageById(Long id) {
        return (CitizenInbox)((Object)this.citizenInboxRepository.findOne(id));
    }
}

