/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.repository;

import java.util.List;
import org.egov.portal.entity.CitizenInbox;
import org.egov.portal.entity.enums.MessageType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CitizenInboxRepository
extends JpaRepository<CitizenInbox, Long> {
    @Query(value="select count(*) from CitizenInbox ci where ci.assignedToCitizen.id=:citizenUserId and ci.read is false")
    public Integer findUnreadMessagesCount(@Param(value="citizenUserId") Long var1);

    @Query(value="select ci from CitizenInbox ci where ci.assignedToCitizen.id=:citizenUserId order by ci.createdDate desc")
    public List<CitizenInbox> findAllInboxMessage(@Param(value="citizenUserId") Long var1);

    @Query(value="select ci from CitizenInbox ci where ci.messageType=:messageType and ci.assignedToCitizen.id=:citizenUserId order by ci.createdDate desc")
    public List<CitizenInbox> findAllInboxMessageByType(@Param(value="messageType") MessageType var1, @Param(value="citizenUserId") Long var2);

    @Query(value="select ci from CitizenInbox ci where ci.messageType=:messageType and ci.createdBy.id=:citizenUserId and ci.id in (select max(ci1.id) from CitizenInbox ci1 where ci1.messageType=:messageType and ci1.createdBy.id=:citizenUserId group by ci1.identifier) order by ci.createdDate desc")
    public List<CitizenInbox> findMyAccountMessages(@Param(value="messageType") MessageType var1, @Param(value="citizenUserId") Long var2);
}

