/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.portal.entity.PortalNotification;

public class PortalNotificationBuilder {
    private final PortalNotification portalNotification = new PortalNotification();

    public PortalNotificationBuilder(String moduleName, String message, Character priorityFlag, User user) {
        this.portalNotification.setSubject(moduleName);
        this.portalNotification.setMessage(message);
        this.portalNotification.setPriorityFlag(priorityFlag);
        this.portalNotification.setUser(user);
    }

    public PortalNotification build() throws ApplicationRuntimeException {
        this.validate();
        return this.portalNotification;
    }

    private void validate() throws ApplicationRuntimeException {
        if (this.portalNotification.getSubject() == null || this.portalNotification.getSubject().isEmpty()) {
            throw new ApplicationRuntimeException("Subject is mandatory");
        }
        if (this.portalNotification.getMessage() == null || this.portalNotification.getMessage().isEmpty()) {
            throw new ApplicationRuntimeException("Message is mandatory");
        }
        if (this.portalNotification.getPriorityFlag() == null) {
            throw new ApplicationRuntimeException("PriorityFlag is mandatory");
        }
        this.validateUser();
    }

    private void validateUser() {
        if (this.portalNotification.getUser() == null) {
            throw new ApplicationRuntimeException("User is mandatory");
        }
        if (this.portalNotification.getUser().getType() != null && !UserType.BUSINESS.toString().equalsIgnoreCase(this.portalNotification.getUser().getType().toString()) && !UserType.CITIZEN.toString().equalsIgnoreCase(this.portalNotification.getUser().getType().toString())) {
            throw new ApplicationRuntimeException("NotificationnUser must be a Citizen or Business User.");
        }
    }
}

