/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.workflow.entity.State;
import org.egov.portal.entity.PortalInboxUser;
import org.egov.portal.entity.enums.Priority;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="egp_inbox")
@SequenceGenerator(name="seq_egp_inbox", sequenceName="seq_egp_inbox", allocationSize=1)
public class PortalInbox
extends AbstractAuditable {
    public static final String SEQ_PORTALINBOX = "seq_egp_inbox";
    private static final long serialVersionUID = -2303996521024126504L;
    @Id
    @GeneratedValue(generator="seq_egp_inbox", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="MODULEID")
    private Module module;
    @NotNull
    @Length(max=128)
    private String serviceType;
    @Length(max=50)
    private String applicationNumber;
    @Length(max=50)
    private String entityRefNumber;
    private Long entityRefId;
    @Length(max=256)
    private String headerMessage;
    @NotNull
    @Length(max=2048)
    private String detailedMessage;
    @Length(max=256)
    private String link;
    private boolean read;
    private boolean resolved;
    private Date resolvedDate;
    private Date slaEndDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    private Date applicationDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATE_ID")
    private State state;
    @OrderBy(value="id")
    @OneToMany(mappedBy="portalInbox", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private final List<PortalInboxUser> portalInboxUsers = new ArrayList<PortalInboxUser>(0);
    @Transient
    private List<PortalInboxUser> tempPortalInboxUser = new ArrayList<PortalInboxUser>(0);
    @Length(max=20)
    private Priority priority;
    @Length(max=100)
    private String status;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getEntityRefNumber() {
        return this.entityRefNumber;
    }

    public void setEntityRefNumber(String entityRefNumber) {
        this.entityRefNumber = entityRefNumber;
    }

    public Long getEntityRefId() {
        return this.entityRefId;
    }

    public void setEntityRefId(Long entityRefId) {
        this.entityRefId = entityRefId;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public Date getSlaEndDate() {
        return this.slaEndDate;
    }

    public void setSlaEndDate(Date slaEndDate) {
        this.slaEndDate = slaEndDate;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<PortalInboxUser> getPortalInboxUsers() {
        return this.portalInboxUsers;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public String getHeaderMessage() {
        return this.headerMessage;
    }

    public void setHeaderMessage(String headerMessage) {
        this.headerMessage = headerMessage;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public List<PortalInboxUser> getTempPortalInboxUser() {
        return this.tempPortalInboxUser;
    }

    public void setTempPortalInboxUser(List<PortalInboxUser> tempPortalInboxUser) {
        this.tempPortalInboxUser = tempPortalInboxUser;
    }

    public Date getResolvedDate() {
        return this.resolvedDate;
    }

    public void setResolvedDate(Date resolvedDate) {
        this.resolvedDate = resolvedDate;
    }
}

