/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import java.util.ArrayList;
import java.util.Arrays;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.portal.entity.Firm;
import org.egov.portal.entity.FirmUser;

public class FirmBuilder {
    private final Firm firm = new Firm();

    public FirmBuilder(String name, String pan, String address) {
        this.firm.setName(name);
        this.firm.setPan(pan);
        this.firm.setAddress(address);
    }

    public FirmBuilder setFirmUser(String name, String mobileNumber, String emailId, Long userId) {
        FirmUser firmUser = new FirmUser();
        firmUser.setName(name);
        firmUser.setMobileNumber(mobileNumber);
        firmUser.setEmailId(emailId);
        firmUser.setEgUserId(userId);
        if (this.firm.getTempFirmUsers().isEmpty()) {
            this.firm.setTempFirmUsers(new ArrayList<FirmUser>(Arrays.asList(firmUser)));
        } else {
            this.firm.getTempFirmUsers().add(firmUser);
        }
        return this;
    }

    public Firm build() throws ApplicationRuntimeException {
        this.validate();
        return this.firm;
    }

    private void validate() throws ApplicationRuntimeException {
        this.validateNameAndPan();
        if (this.firm.getTempFirmUsers() != null && !this.firm.getTempFirmUsers().isEmpty()) {
            for (FirmUser user : this.firm.getTempFirmUsers()) {
                if (user.getEgUserId() != null || user.getEmailId() != null && !user.getEmailId().isEmpty()) continue;
                throw this.runtimeException();
            }
        }
    }

    private void validateNameAndPan() {
        if (this.firm.getName() == null || this.firm.getName().isEmpty()) {
            throw new ApplicationRuntimeException("Firm Name is mandatory");
        }
        if (this.firm.getPan() == null || this.firm.getPan().isEmpty()) {
            throw new ApplicationRuntimeException("Pan is mandatory");
        }
    }

    private ApplicationRuntimeException runtimeException() {
        return new ApplicationRuntimeException("Firm User EmailId is mandatory");
    }
}

