/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.service;

import java.util.Locale;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.messaging.MessagePriority;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.token.service.TokenService;
import org.egov.portal.entity.Citizen;
import org.egov.portal.repository.CitizenRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CitizenService {
    private static final String CITIZEN_REG_SERVICE = "Citizen Registration";
    @Autowired
    private CitizenRepository citizenRepository;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private TokenService tokenService;

    @Transactional
    public void create(Citizen citizen) {
        citizen.addRole(this.roleService.getRoleByName("Citizen"));
        citizen.updateNextPwdExpiryDate(this.applicationProperties.userPasswordExpiryInDays());
        citizen.setPassword(this.passwordEncoder.encode((CharSequence)citizen.getPassword()));
        citizen.setActive(true);
        this.citizenRepository.saveAndFlush((Object)citizen);
        this.messagingService.sendSMS(citizen.getMobileNumber(), this.getMessage("citizen.reg.sms", new Object[0]));
        this.messagingService.sendEmail(citizen.getEmailId(), this.getMessage("citizen.reg.mail.subject", new Object[0]), this.getMessage("citizen.reg.mail.body", citizen.getName(), String.format("%s/egi/login/secure", ApplicationThreadLocals.getDomainURL()), ApplicationThreadLocals.getMunicipalityName()));
    }

    @Transactional
    public void update(Citizen citizen) {
        this.citizenRepository.save((Object)citizen);
    }

    public Citizen getCitizenByEmailId(String emailId) {
        return this.citizenRepository.findByEmailId(emailId);
    }

    public Citizen getCitizenByUserName(String userName) {
        return this.citizenRepository.findByUsername(userName);
    }

    @Transactional
    public boolean isValidOTP(String otp, String mobileNumber) {
        return this.tokenService.redeemToken(otp, mobileNumber, CITIZEN_REG_SERVICE);
    }

    @Transactional
    public boolean sendOTPMessage(String mobileNumber) {
        String otp = RandomStringUtils.randomNumeric((int)5);
        this.tokenService.generate(otp, mobileNumber, CITIZEN_REG_SERVICE);
        this.messagingService.sendSMS(mobileNumber, this.getMessage("citizen.reg.otp.sms", otp), MessagePriority.HIGH);
        return Boolean.TRUE;
    }

    private String getMessage(String msgKey, Object ... arg) {
        return this.messageSource.getMessage(msgKey, arg, Locale.getDefault());
    }
}

