/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.service.es;

import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.portal.entity.FirmUser;
import org.egov.portal.entity.PortalInbox;
import org.egov.portal.entity.es.PortalInboxIndex;
import org.egov.portal.firm.service.FirmUserService;
import org.egov.portal.repository.es.PortalInboxIndexRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PortalInboxIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private FirmUserService firmUserService;
    @Autowired
    private PortalInboxIndexRepository portalInboxIndexRepository;

    public PortalInboxIndex createPortalInboxIndex(PortalInbox portalInbox) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        PortalInboxIndex portalInboxIndex = new PortalInboxIndex();
        portalInboxIndex.setUlbName(cityWebsite.getName());
        portalInboxIndex.setApplicationCreatedBy(portalInbox.getCreatedBy() != null ? portalInbox.getCreatedBy().getName() : "");
        portalInboxIndex.setApplicationDate(portalInbox.getApplicationDate());
        portalInboxIndex.setApplicationNumber(portalInbox.getApplicationNumber());
        portalInboxIndex.setApplicationStatus(portalInbox.getStatus() != null ? portalInbox.getStatus() : "");
        portalInboxIndex.setCreatedDate(portalInbox.getCreatedDate());
        portalInboxIndex.setDetailedMessage(portalInbox.getDetailedMessage() != null ? portalInbox.getDetailedMessage() : "");
        portalInboxIndex.setEntityReferenceId(portalInbox.getEntityRefId() != null ? portalInbox.getEntityRefId().toString() : "");
        portalInboxIndex.setEntityReferenceNumber(portalInbox.getEntityRefNumber() != null ? portalInbox.getEntityRefNumber() : "");
        portalInboxIndex.setHeaderMessage(portalInbox.getHeaderMessage() != null ? portalInbox.getHeaderMessage() : "");
        portalInboxIndex.setId(cityWebsite.getCode().concat("-").concat(portalInbox.getId().toString()));
        portalInboxIndex.setLink(portalInbox.getLink() != null ? portalInbox.getLink() : "");
        portalInboxIndex.setModule(portalInbox.getModule() != null ? portalInbox.getModule().getName() : "");
        portalInboxIndex.setPriority(portalInbox.getPriority() != null ? portalInbox.getPriority().toString() : "");
        portalInboxIndex.setRead(portalInbox.isRead());
        portalInboxIndex.setResolved(portalInbox.isResolved());
        portalInboxIndex.setServiceType(portalInbox.getServiceType() != null ? portalInbox.getServiceType() : "");
        if (portalInbox.getSlaEndDate() != null) {
            portalInboxIndex.setSlaendDate(portalInbox.getSlaEndDate());
        }
        if (portalInbox.getResolvedDate() != null) {
            portalInboxIndex.setResolvedDate(portalInbox.getResolvedDate());
        }
        this.setFirmDetails(portalInbox, portalInboxIndex);
        this.portalInboxIndexRepository.save(portalInboxIndex);
        return portalInboxIndex;
    }

    private void setFirmDetails(PortalInbox portalInbox, PortalInboxIndex portalInboxIndex) {
        FirmUser firmUser;
        if (portalInbox.getPortalInboxUsers() != null && portalInbox.getPortalInboxUsers().size() != 0 && portalInbox.getPortalInboxUsers().get(0).getUser() != null && (firmUser = this.firmUserService.getFirmUserByUserId(portalInbox.getPortalInboxUsers().get(0).getUser().getId())) != null) {
            portalInboxIndex.setFirmAddress(firmUser.getFirm().getAddress());
            portalInboxIndex.setFirmName(firmUser.getFirm().getName());
            portalInboxIndex.setFirmPan(firmUser.getFirm().getPan());
        }
    }
}

