/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.service;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.portal.entity.PortalInbox;
import org.egov.portal.entity.PortalInboxUser;
import org.egov.portal.repository.PortalInboxRepository;
import org.egov.portal.service.es.PortalInboxIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PortalInboxService {
    private final PortalInboxRepository portalInboxRepository;
    private final PortalInboxIndexService portalInboxIndexService;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public PortalInboxService(PortalInboxRepository portalInboxRepository, PortalInboxIndexService portalInboxIndexService) {
        this.portalInboxRepository = portalInboxRepository;
        this.portalInboxIndexService = portalInboxIndexService;
    }

    public Long getPortalInboxByStatus(boolean resolved) {
        return this.portalInboxRepository.getPortalInboxByStatus(resolved);
    }

    public Long getPortalInboxCount() {
        return this.portalInboxRepository.getPortalInboxCount();
    }

    @Transactional
    public void pushInboxMessage(PortalInbox portalInbox) {
        if (portalInbox.getTempPortalInboxUser().isEmpty()) {
            PortalInboxUser portalInboxUser;
            User user = this.getLoggedInUser();
            if (user != null && (UserType.BUSINESS.toString().equalsIgnoreCase(user.getType().toString()) || UserType.CITIZEN.toString().equalsIgnoreCase(user.getType().toString())) && (portalInboxUser = this.createPortalUser(portalInbox, user)) != null) {
                this.portalInboxRepository.saveAndFlush((Object)portalInbox);
                this.portalInboxIndexService.createPortalInboxIndex(portalInbox);
            }
        } else {
            portalInbox.getPortalInboxUsers().addAll(portalInbox.getTempPortalInboxUser());
            this.portalInboxRepository.saveAndFlush((Object)portalInbox);
            this.portalInboxIndexService.createPortalInboxIndex(portalInbox);
        }
    }

    private PortalInboxUser createPortalUser(PortalInbox portalInbox, User user) {
        PortalInboxUser portalInboxUser = null;
        if (portalInbox != null && user != null) {
            portalInboxUser = new PortalInboxUser();
            portalInboxUser.setUser(user);
            portalInbox.getPortalInboxUsers().add(portalInboxUser);
            portalInboxUser.setPortalInbox(portalInbox);
        }
        return portalInboxUser;
    }

    @Transactional
    public void updateInboxMessage(String applicationNumber, Long moduleId, String status, Boolean isResolved, Date slaEndDate, State state, User additionalUser, String consumerNumber, String link) {
        PortalInbox portalInbox;
        if (applicationNumber != null && moduleId != null && status != null && link != null && (portalInbox = this.getPortalInboxByApplicationNo(applicationNumber, moduleId)) != null) {
            portalInbox.setStatus(status);
            portalInbox.setResolved(isResolved);
            portalInbox.setState(state);
            this.updatePortalInboxData(slaEndDate, consumerNumber, link, portalInbox);
            if (additionalUser != null && (UserType.BUSINESS.toString().equalsIgnoreCase(additionalUser.getType().toString()) || UserType.CITIZEN.toString().equalsIgnoreCase(additionalUser.getType().toString())) && !this.containsUser(portalInbox.getPortalInboxUsers(), additionalUser.getId())) {
                this.createPortalUser(portalInbox, additionalUser);
            }
            this.portalInboxRepository.saveAndFlush((Object)portalInbox);
            this.portalInboxIndexService.createPortalInboxIndex(portalInbox);
        }
    }

    private void updatePortalInboxData(Date slaEndDate, String entityRefNo, String link, PortalInbox portalInbox) {
        if (entityRefNo != null && !entityRefNo.isEmpty()) {
            portalInbox.setEntityRefNumber(entityRefNo);
        }
        if (link != null && !link.isEmpty()) {
            portalInbox.setLink(link);
        }
        if (slaEndDate != null) {
            portalInbox.setSlaEndDate(slaEndDate);
        }
    }

    public boolean containsUser(List<PortalInboxUser> list, Long userId) {
        return list.stream().anyMatch(item -> item.getUser().getId().equals(userId));
    }

    public PortalInbox getPortalInboxByApplicationNo(String applicationNumber, Long moduleId) {
        return this.portalInboxRepository.findByApplicationNumberAndModule_Id(applicationNumber, moduleId);
    }

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }
}

