/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.portal.entity.FirmUser;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egp_firm")
@Unique(fields={"pan"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGP_FIRM", sequenceName="SEQ_EGP_FIRM", allocationSize=1)
public class Firm
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_EGP_FIRM = "SEQ_EGP_FIRM";
    @Id
    @GeneratedValue(generator="SEQ_EGP_FIRM", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    private String name;
    @NotNull
    @SafeHtml
    private String pan;
    @SafeHtml
    private String address;
    @OrderBy(value="id")
    @OneToMany(mappedBy="firm", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=FirmUser.class)
    private final List<FirmUser> firmUsers = new ArrayList<FirmUser>(0);
    @Transient
    private List<FirmUser> tempFirmUsers = new ArrayList<FirmUser>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPan() {
        return this.pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<FirmUser> getTempFirmUsers() {
        return this.tempFirmUsers;
    }

    public void setTempFirmUsers(List<FirmUser> tempFirmUsers) {
        this.tempFirmUsers = tempFirmUsers;
    }

    public List<FirmUser> getFirmUsers() {
        return this.firmUsers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

