/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.firm.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.portal.entity.Firm;
import org.egov.portal.entity.FirmUser;
import org.egov.portal.entity.SearchRequestFirm;
import org.egov.portal.firm.repository.FirmRepository;
import org.egov.portal.firm.repository.FirmUserRepository;
import org.egov.portal.repository.specs.SearchFirmSpec;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FirmService {
    public static final String ROLE_BUSINESS_USER = "BUSINESS";
    @Autowired
    private FirmRepository firmRepository;
    @Autowired
    private FirmUserRepository firmUserRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;

    @Transactional
    public Firm create(Firm firm) {
        this.validateFirmUsers(firm);
        for (FirmUser firmUser : firm.getTempFirmUsers()) {
            FirmUser firmUsers = this.createFirmUserObject();
            if (firmUser.getEgUserId() == null) {
                User user = this.userService.getUserByUsername(firmUser.getEmailId());
                if (user == null) {
                    user = this.createUser(firmUser);
                }
                firmUsers.setUser(user);
            } else {
                firmUsers.setUser(firmUser.getUser());
            }
            firmUsers.setMobileNumber(firmUser.getMobileNumber());
            firmUsers.setEmailId(firmUser.getEmailId());
            firmUsers.setName(firmUser.getName());
            firmUsers.setFirm(firm);
            firm.getFirmUsers().add(firmUsers);
        }
        return (Firm)((Object)this.firmRepository.save((Object)firm));
    }

    private void validateFirmUsers(Firm firm) throws ApplicationRuntimeException {
        if (firm != null && firm.getTempFirmUsers() != null && !firm.getTempFirmUsers().isEmpty()) {
            for (FirmUser firmUser : firm.getTempFirmUsers()) {
                this.initializeUser(firmUser);
                if (firmUser.getUser() == null) {
                    if (firmUser.getEmailId() == null || firmUser.getEmailId().isEmpty() || this.getFirmUserByEmailId(firmUser.getEmailId()) == null) continue;
                    throw new ApplicationRuntimeException("Email is already mapped to a Firm. Please Use different Email Id.");
                }
                if (!firmUser.getUser().getType().toString().equalsIgnoreCase(UserType.BUSINESS.toString())) {
                    throw new ApplicationRuntimeException("User should be a Business User.");
                }
                if (this.getFirmUserByUserId(firmUser.getUser().getId()) == null) continue;
                throw new ApplicationRuntimeException("User is already mapped to a Firm. Please Use different User Id.");
            }
        }
    }

    private void initializeUser(FirmUser firmUser) {
        if (firmUser.getEgUserId() != null) {
            firmUser.setUser(this.userService.getUserById(firmUser.getEgUserId()));
        }
    }

    public Firm getFirmById(Long firmId) {
        return (Firm)((Object)this.firmRepository.findOne(firmId));
    }

    public Firm getFirmByPan(String pan) {
        return this.firmRepository.findByPan(pan);
    }

    public FirmUser getFirmUserByEmailId(String emailId) {
        return this.firmUserRepository.findByEmailId(emailId);
    }

    public FirmUser getFirmUserByUserId(Long userId) {
        return this.firmUserRepository.findByUser_Id(userId);
    }

    @Transactional
    public void createFirm(Firm firm) {
        FirmUser firmUsers = null;
        firm.getFirmUsers().clear();
        for (FirmUser firmUser : firm.getTempFirmUsers()) {
            firmUsers = this.createFirmUserObject();
            User user = this.userService.getUserByUsername(firmUser.getEmailId());
            if (user == null) {
                user = this.createUser(firmUser);
            }
            firmUsers.setUser(user);
            firmUsers.setMobileNumber(firmUser.getMobileNumber());
            firmUsers.setEmailId(firmUser.getEmailId());
            firmUsers.setName(firmUser.getName());
            firmUsers.setFirm(firm);
            firm.getFirmUsers().add(firmUsers);
        }
        this.firmRepository.save((Object)firm);
    }

    private User createUser(FirmUser firmUser) {
        User user = new User();
        user.setUsername(firmUser.getEmailId());
        user.setName(firmUser.getName());
        user.setMobileNumber(firmUser.getMobileNumber());
        user.setPassword(this.passwordEncoder.encode((CharSequence)firmUser.getMobileNumber()));
        user.setEmailId(firmUser.getEmailId());
        user.setType(UserType.BUSINESS);
        user.setActive(true);
        user.setPwdExpiryDate(DateTime.now().plusMonths(6).toDate());
        user.addRole(this.roleService.getRoleByName(ROLE_BUSINESS_USER));
        user = this.userService.createUser(user);
        return user;
    }

    private FirmUser createFirmUserObject() {
        return new FirmUser();
    }

    public List<Firm> searchFirm(SearchRequestFirm searchRequestFirm) {
        List firms = this.firmRepository.findAll(SearchFirmSpec.searchFirm(searchRequestFirm));
        return firms;
    }
}

