/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.portal.entity.PortalInbox;
import org.egov.portal.entity.PortalInboxUser;

public class PortalInboxBuilder {
    private final PortalInbox portalInbox = new PortalInbox();

    public PortalInboxBuilder(Module module, String serviceType, String applicationNumber, String consumerNumber, Long entityId, String headerMsg, String detailedMessage, String link, boolean isResolved, String status, Date slaEndDate, State state, List<User> user) {
        this.portalInbox.setModule(module);
        this.portalInbox.setServiceType(serviceType);
        this.portalInbox.setApplicationNumber(applicationNumber);
        this.portalInbox.setEntityRefNumber(consumerNumber);
        this.portalInbox.setEntityRefId(entityId);
        this.portalInbox.setHeaderMessage(headerMsg);
        this.portalInbox.setResolved(isResolved);
        this.portalInbox.setDetailedMessage(detailedMessage);
        this.portalInbox.setLink(link);
        this.portalInbox.setRead(false);
        this.portalInbox.setStatus(status);
        this.portalInbox.setSlaEndDate(slaEndDate);
        this.portalInbox.setState(state);
        this.portalInbox.setApplicationDate(DateUtils.now());
        if (user != null && !user.isEmpty()) {
            for (User userObject : user) {
                if (!UserType.BUSINESS.toString().equalsIgnoreCase(userObject.getType().toString()) && !UserType.CITIZEN.toString().equalsIgnoreCase(userObject.getType().toString())) continue;
                PortalInboxUser portalInboxUser = new PortalInboxUser();
                portalInboxUser.setUser(userObject);
                portalInboxUser.setPortalInbox(this.portalInbox);
                this.portalInbox.setTempPortalInboxUser(new ArrayList<PortalInboxUser>(Arrays.asList(portalInboxUser)));
            }
        }
    }

    public PortalInbox build() throws ApplicationRuntimeException {
        this.validate();
        return this.portalInbox;
    }

    private void validate() throws ApplicationRuntimeException {
        this.validateParams();
        if (this.portalInbox.getLink() == null || this.portalInbox.getLink().isEmpty()) {
            throw new ApplicationRuntimeException("Link is mandatory");
        }
        if (this.portalInbox.getStatus() == null || this.portalInbox.getStatus().isEmpty()) {
            throw new ApplicationRuntimeException("Status is mandatory");
        }
    }

    private void validateParams() {
        if (this.portalInbox.getModule() == null) {
            throw new ApplicationRuntimeException("Module is mandatory");
        }
        if (this.portalInbox.getServiceType() == null || this.portalInbox.getServiceType().isEmpty()) {
            throw new ApplicationRuntimeException("ServiceType is mandatory");
        }
        if (this.portalInbox.getApplicationNumber() == null || this.portalInbox.getApplicationNumber().isEmpty()) {
            throw new ApplicationRuntimeException("ApplicationNumber is mandatory");
        }
        if (this.portalInbox.getDetailedMessage() == null || this.portalInbox.getDetailedMessage().isEmpty()) {
            throw new ApplicationRuntimeException("DetailedMessage is mandatory");
        }
    }
}

