/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.workflow.entity.State;
import org.egov.portal.entity.enums.MessageType;
import org.egov.portal.entity.enums.Priority;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="egp_citizeninbox")
@SequenceGenerator(name="seq_egp_citizeninbox", sequenceName="seq_egp_citizeninbox", allocationSize=1)
public class CitizenInbox
extends AbstractAuditable {
    private static final long serialVersionUID = -2303996521024126504L;
    public static final String SEQ_CITIZENINBOX = "seq_egp_citizeninbox";
    @DocumentId
    @Id
    @GeneratedValue(generator="seq_egp_citizeninbox", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="MODULE_ID")
    private Module module;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @Column(name="MESSAGE_TYPE")
    private MessageType messageType;
    @Length(max=50)
    @Column(name="IDENTIFIER")
    private String identifier;
    @NotNull
    @Length(max=500)
    @Column(name="HEADER_MSG")
    private String headerMessage;
    @NotNull
    @Length(max=2048)
    @Column(name="DETAILED_MSG")
    private String detailedMessage;
    @Length(max=256)
    @Column(name="LINK")
    private String link;
    @Column(name="READ")
    private boolean read;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column(name="MSG_DATE")
    private Date messageDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATE_ID")
    private State state;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ASSIGNED_TO_USER")
    private User assignedToCitizen;
    @NotNull
    @Length(max=20)
    @Column(name="PRIORITY")
    private Priority priority;
    @Length(max=100)
    @Column(name="STATUS")
    private String status;

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getHeaderMessage() {
        return this.headerMessage;
    }

    public void setHeaderMessage(String headerMessage) {
        this.headerMessage = headerMessage;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public Date getMessageDate() {
        return this.messageDate;
    }

    public void setMessageDate(Date messageDate) {
        this.messageDate = messageDate;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public User getAssignedToCitizen() {
        return this.assignedToCitizen;
    }

    public void setAssignedToCitizen(User assignedToCitizen) {
        this.assignedToCitizen = assignedToCitizen;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

