/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.dto.RouterEscalationForm;
import org.egov.pgr.entity.dto.RouterEscalationRequest;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.reports.RouterEscalationService;
import org.egov.pgr.web.controller.response.adaptor.RouterEscalationAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"routerescalation"})
public class RouterEscalationReportController {
    @Autowired
    private ReportService reportService;
    private final ComplaintTypeCategoryService complaintTypeCategoryService;
    private final BoundaryService boundaryService;
    private final RouterEscalationService routerEscalationService;

    @Autowired
    public RouterEscalationReportController(ComplaintTypeCategoryService complaintTypeCategoryService, BoundaryService boundaryService, RouterEscalationService routerEscalationService) {
        this.complaintTypeCategoryService = complaintTypeCategoryService;
        this.boundaryService = boundaryService;
        this.routerEscalationService = routerEscalationService;
    }

    @ModelAttribute
    public RouterEscalationForm routerEscalationForm() {
        return new RouterEscalationForm();
    }

    @GetMapping(value={"/search-form"})
    public String searchBaseRegister(Model model) {
        model.addAttribute("categories", (Object)this.complaintTypeCategoryService.findAll());
        model.addAttribute("complaintTypes", Collections.emptyList());
        model.addAttribute("wardList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION"));
        return "routerescalation-report";
    }

    @GetMapping(value={"/search-resultList"}, produces={"text/plain"})
    @ResponseBody
    public String search(RouterEscalationRequest routerEscalationRequest) throws IOException {
        return new DataTable(this.routerEscalationService.search(routerEscalationRequest), (long)routerEscalationRequest.draw()).toJson(RouterEscalationAdaptor.class);
    }

    @GetMapping(value={"/reportgeneration"})
    @ResponseBody
    public ResponseEntity<byte[]> generateReport(RouterEscalationRequest routerEscalationRequest) {
        HashMap responseParams = new HashMap();
        ReportRequest reportRequest = new ReportRequest("pgr_routerescalation_report", (Collection)this.routerEscalationService.prepareReport(routerEscalationRequest), responseParams);
        reportRequest.setReportFormat(routerEscalationRequest.getPrintFormat());
        return this.reportResponse(reportRequest);
    }

    private ResponseEntity<byte[]> reportResponse(ReportRequest reportRequest) {
        HttpHeaders headers = new HttpHeaders();
        if (reportRequest.getReportFormat().equals((Object)ReportFormat.PDF)) {
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        } else if (reportRequest.getReportFormat().equals((Object)ReportFormat.XLS)) {
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
        }
        headers.add("content-disposition", "inline;filename=Router_Escalation_report." + reportRequest.getReportFormat());
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

