/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.service.reports.ComplaintTypeWiseReportService;
import org.egov.pgr.web.controller.reports.DrillDownReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.DrillDownReportResult;
import org.egov.pgr.web.controller.reports.DrillDownReportWithcompTypeAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class ComplaintTypeWiseReportController {
    @Autowired
    private ComplaintTypeWiseReportService complaintTypeReportService;

    @ModelAttribute
    public void getReportHelper(Model model) {
        model.addAttribute("reportHelper", (Object)new ReportHelper());
    }

    @GetMapping(value={"complaintTypeReport"})
    public String searchAgeingReportByBoundaryForm() {
        return "complaintTypeReport-search";
    }

    @GetMapping(value={"complaintTypeReport/resultList-update"})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String complaintType, @RequestParam String complaintTypeWithStatus, @RequestParam String status, @RequestParam String complaintDateType, @RequestParam Date fromDate, @RequestParam Date toDate, HttpServletResponse response) throws IOException {
        String result;
        if (complaintTypeWithStatus != null && status != null && !"".equals(complaintTypeWithStatus) && !"".equals(status)) {
            SQLQuery complaintTypeReportQuery = this.complaintTypeReportService.getComplaintTypeWiseReportQuery(fromDate, toDate, complaintDateType, complaintTypeWithStatus, status);
            complaintTypeReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List complaintTypeReportResult = complaintTypeReportQuery.list();
            result = "{ \"data\":" + JsonUtils.toJSON((Collection)complaintTypeReportResult, DrillDownReportResult.class, DrillDownReportWithcompTypeAdaptor.class) + "}";
        } else {
            SQLQuery complaintTypeReportQuery = this.complaintTypeReportService.getComplaintTypeWiseReportQuery(fromDate, toDate, complaintType, complaintDateType);
            complaintTypeReportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List complaintTypeReportResult = complaintTypeReportQuery.list();
            result = "{ \"data\":" + JsonUtils.toJSON((Collection)complaintTypeReportResult, DrillDownReportResult.class, DrillDownReportHelperAdaptor.class) + "}";
        }
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

