/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infstr.services.Page;
import org.egov.pgr.entity.dto.AgeingReportRequest;
import org.egov.pgr.service.reports.AgeingReportService;
import org.egov.pgr.web.controller.reports.AgeingReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class AgeingReportController {
    @Autowired
    private AgeingReportService ageingReportService;
    @Autowired
    private ReportService reportService;

    @ModelAttribute
    public void getReportHelper(Model model) {
        ReportHelper reportHealperObj = new ReportHelper();
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        status.put("Completed", "Completed");
        status.put("Pending", "Pending");
        status.put("Rejected", "Rejected");
        model.addAttribute("status", status);
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @GetMapping(value={"ageingReportByBoundary"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "ageing-search";
    }

    @GetMapping(value={"ageingReportByDept"})
    public String searchAgeingReportByDepartmentForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "ageing-search";
    }

    @GetMapping(value={"/ageing/resultList-update"}, produces={"text/plain"})
    @ResponseBody
    public String searchAgeingReport(AgeingReportRequest request) throws IOException {
        Page ageingreport = this.ageingReportService.pagedAgeingRecords(request);
        long draw = request.draw();
        return new DataTable(ageingreport, draw).toJson(AgeingReportHelperAdaptor.class);
    }

    @GetMapping(value={"/ageing/grand-total"})
    @ResponseBody
    public Object[] ageingReportGrandTotal(AgeingReportRequest request) {
        return this.ageingReportService.ageingReportGrandTotal(request);
    }

    @GetMapping(value={"/ageing/download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadReport(AgeingReportRequest request) {
        ReportRequest reportRequest = new ReportRequest("pgr_ageing_report", (Collection)this.ageingReportService.getAllAgeingReportRecords(request), new HashMap());
        HashMap<String, String> reportparam = new HashMap<String, String>();
        reportparam.put("status", request.getStatus());
        reportRequest.setReportParams(reportparam);
        reportRequest.setReportFormat(request.getPrintFormat());
        reportRequest.setReportName("pgr_ageing_report");
        return WebUtils.reportToResponseEntity((ReportRequest)reportRequest, (ReportOutput)this.reportService.createReport(reportRequest));
    }
}

