/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalationTime;

import java.util.List;
import org.egov.eis.service.DesignationService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.service.ComplaintEscalationService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.web.controller.masters.escalationTime.EscalationForm;
import org.egov.pims.commons.Designation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/escalationTime"})
public class SearchEscalationTimeController {
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintEscalationService escalationService;
    @Autowired
    private DesignationService designationService;

    @ModelAttribute
    public EscalationForm escalationForm() {
        return new EscalationForm();
    }

    @PostMapping(value={"search-view"})
    public String searchEscalationTimeForm(@ModelAttribute EscalationForm escalationForm, Model model) {
        if (escalationForm.getComplaintType() != null) {
            List escalationList = this.escalationService.findAllBycomplaintTypeId(escalationForm.getComplaintType().getId());
            if (escalationList.size() > 0) {
                escalationForm.setEscalationList(escalationList);
                model.addAttribute("mode", (Object)"dataFound");
            } else {
                escalationForm.getEscalationList().clear();
                escalationForm.addEscalationList(new Escalation());
                model.addAttribute("mode", (Object)"noDataFound");
            }
        }
        return "escalationTime-searchView";
    }

    @GetMapping(value={"search-view"})
    public String searchForm(@ModelAttribute EscalationForm escalationForm, Model model) {
        if (escalationForm.getComplaintType() != null) {
            List escalationList = this.escalationService.findAllBycomplaintTypeId(escalationForm.getComplaintType().getId());
            if (escalationList.size() > 0) {
                escalationForm.setEscalationList(escalationList);
            } else {
                escalationForm.addEscalationList(new Escalation());
                model.addAttribute("mode", (Object)"noDataFound");
            }
        } else {
            escalationForm.addEscalationList(new Escalation());
        }
        return "escalationTime-searchView";
    }

    @GetMapping(value={"save-escalationTime"})
    public String saveEscalationTimeForm(@ModelAttribute EscalationForm escalationForm) {
        return "escalationTime-searchView";
    }

    @PostMapping(value={"save-escalationTime"})
    public String saveEscalationTime(@ModelAttribute EscalationForm escalationForm, RedirectAttributes redirectAttrs) {
        ComplaintType compType = null;
        if (escalationForm.getComplaintType() != null && escalationForm.getComplaintType().getId() != null) {
            compType = this.complaintTypeService.findBy(escalationForm.getComplaintType().getId());
            List escalationList = this.escalationService.findAllBycomplaintTypeId(escalationForm.getComplaintType().getId());
            if (escalationList != null && escalationList.size() > 0) {
                this.escalationService.deleteAllInBatch(escalationList);
            }
        }
        if (compType != null && escalationForm.getEscalationList() != null && escalationForm.getEscalationList().size() > 0) {
            for (Escalation escalation : escalationForm.getEscalationList()) {
                if (escalation.getDesignation().getId() == null) continue;
                Designation desig = this.designationService.getDesignationById(escalation.getDesignation().getId());
                escalation.setComplaintType(compType);
                escalation.setDesignation(desig);
                escalation.setNoOfHrs(escalation.getNoOfHrs());
                this.escalationService.create(escalation);
            }
        }
        redirectAttrs.addFlashAttribute("message", (Object)"msg.escalate.time.success");
        return "escalationTime-searchView";
    }
}

