/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.service.ComplaintEscalationService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.web.controller.masters.escalation.BulkEscalationGenerator;
import org.egov.pgr.web.controller.masters.escalation.EscalationHelper;
import org.egov.pgr.web.controller.masters.escalation.EscalationHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/bulkEscalation"})
public class BulkEscalationController {
    @Autowired
    private ComplaintEscalationService escalationService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private ObjectTypeService objectTypeService;
    @Autowired
    private PositionHierarchyService positionHierarchyService;

    @ModelAttribute(value="complainttypes")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findActiveComplaintTypes();
    }

    @ModelAttribute
    public BulkEscalationGenerator bulkEscalationGenerator() {
        return new BulkEscalationGenerator();
    }

    @GetMapping(value={"search"})
    public String newform() {
        return "bulkEscalation-new";
    }

    @GetMapping(value={"search-result"}, produces={"application/json"})
    @ResponseBody
    public void search(@ModelAttribute BulkEscalationGenerator bulkEscalationGenerator, HttpServletResponse response) throws IOException {
        ArrayList<EscalationHelper> escalationHelperList = new ArrayList<EscalationHelper>();
        List escalationRecords = this.escalationService.getEscalationObjByComplaintTypeFromPosition(bulkEscalationGenerator.getComplaintTypes(), bulkEscalationGenerator.getFromPosition());
        for (PositionHierarchy posHir : escalationRecords) {
            EscalationHelper escalationHelper = new EscalationHelper();
            if (posHir.getObjectSubType() != null) {
                escalationHelper.setComplaintType(this.complaintTypeService.findByCode(posHir.getObjectSubType()));
            }
            escalationHelper.setFromPosition(posHir.getFromPosition());
            escalationHelper.setToPosition(posHir.getToPosition());
            escalationHelperList.add(escalationHelper);
        }
        String escalationJSONData = "{ \"data\":" + JsonUtils.toJSON(escalationHelperList, EscalationHelper.class, EscalationHelperAdaptor.class) + "}";
        IOUtils.write((String)escalationJSONData, (Writer)response.getWriter());
    }

    @PostMapping(value={"save"})
    public String save(@Valid @ModelAttribute BulkEscalationGenerator bulkEscalationGenerator, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("message", (Object)"bulkescalation.unble.to.save");
            return "bulkEscalation-new";
        }
        for (ComplaintType complaintType : bulkEscalationGenerator.getComplaintTypes()) {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            PositionHierarchy positionHierarchy = new PositionHierarchy();
            positionHierarchy.setObjectType(objectType);
            positionHierarchy.setObjectSubType(complaintType.getCode());
            positionHierarchy.setFromPosition(bulkEscalationGenerator.getFromPosition());
            positionHierarchy.setToPosition(bulkEscalationGenerator.getToPosition());
            PositionHierarchy existingPosHierarchy = this.escalationService.getExistingEscalation(positionHierarchy);
            if (existingPosHierarchy != null) {
                existingPosHierarchy.setToPosition(bulkEscalationGenerator.getToPosition());
                this.positionHierarchyService.updatePositionHierarchy(existingPosHierarchy);
                continue;
            }
            this.positionHierarchyService.createPositionHierarchy(positionHierarchy);
        }
        redirectAttrs.addFlashAttribute("message", (Object)"msg.bulkescalation.success");
        return "redirect:/bulkEscalation/search";
    }
}

