/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.service.ComplaintRouterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/router/create"})
class CreateRouterController {
    private final BoundaryTypeService boundaryTypeService;
    private final ComplaintRouterService complaintRouterService;
    @Autowired
    private MessageSource messageSource;

    @Autowired
    public CreateRouterController(BoundaryTypeService boundaryTypeService, ComplaintRouterService complaintRouterService) {
        this.boundaryTypeService = boundaryTypeService;
        this.complaintRouterService = complaintRouterService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String createRouterForm() {
        return "router-create";
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @ModelAttribute
    public ComplaintRouter complaintRouter() {
        return new ComplaintRouter();
    }

    @RequestMapping(method={RequestMethod.POST})
    public String saveRouter(@Valid @ModelAttribute ComplaintRouter complaintRouter, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "router-create";
        }
        if (this.complaintRouterService.validateRouter(complaintRouter).booleanValue()) {
            model.addAttribute("warning", (Object)this.messageSource.getMessage("router.exists", null, null));
            return "router-create";
        }
        this.complaintRouterService.createComplaintRouter(complaintRouter);
        redirectAttrs.addFlashAttribute("complaintRouter", (Object)complaintRouter);
        model.addAttribute("message", (Object)"msg.router.success");
        model.addAttribute("routerHeading", (Object)"msg.router.create.heading");
        return "router-success";
    }
}

