/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complainttype"})
public class CreateComplaintTypeController {
    private final DepartmentService departmentService;
    private final ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;

    @Autowired
    public CreateComplaintTypeController(DepartmentService departmentService, ComplaintTypeService complaintTypeService) {
        this.departmentService = departmentService;
        this.complaintTypeService = complaintTypeService;
    }

    @ModelAttribute(value="categories")
    public List<ComplaintTypeCategory> categories() {
        return this.complaintTypeCategoryService.findAll();
    }

    @ModelAttribute(value="departments")
    public List<Department> departments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute
    public ComplaintType complaintTypeModel() {
        return new ComplaintType();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String complaintTypeForm() {
        return "complaint-type";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String createComplaintType(@Valid @ModelAttribute ComplaintType complaintType, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "complaint-type";
        }
        this.complaintTypeService.createComplaintType(complaintType);
        redirectAttrs.addFlashAttribute("complaintType", (Object)complaintType);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.comp.type.success");
        return "redirect:/complainttype/success/" + complaintType.getName();
    }

    @RequestMapping(value={"/success/{name}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="name") String name, @ModelAttribute ComplaintType complaintType) {
        return new ModelAndView("complaintType/complaintType-success", "complaintType", (Object)this.complaintTypeService.findByName(name));
    }
}

