/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.complaint;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.enums.CitizenFeedback;
import org.egov.pgr.service.ComplaintHistoryService;
import org.egov.pgr.service.ComplaintMessagingService;
import org.egov.pgr.service.ComplaintProcessFlowService;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ComplaintStatusMappingService;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complaint/update/{crnNo}"})
public class ComplaintUpdationController {
    private static final String COMPLAINT_UPDATE_SUCCESS = "/update-success";
    private static final String COMPLAINT_EDIT = "complaint-edit";
    private static final String COMPLAINT_CITIZEN_EDIT = "complaint-citizen-edit";
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private ComplaintStatusMappingService complaintStatusMappingService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private FileStoreUtils fileStoreUtils;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private ComplaintHistoryService complaintHistoryService;
    @Autowired
    private ComplaintMessagingService complaintMessagingService;
    @Autowired
    private ComplaintProcessFlowService complaintProcessFlowService;

    @ModelAttribute
    public void getComplaint(@PathVariable String crnNo, Model model) {
        Complaint complaint = this.complaintService.getComplaintByCRN(crnNo);
        model.addAttribute("complaint", (Object)complaint);
        model.addAttribute("complaintHistory", (Object)this.complaintHistoryService.getHistory(complaint));
        model.addAttribute("skippableForward", (Object)this.complaintProcessFlowService.canSendToPreviousAssignee(complaint));
        model.addAttribute("status", (Object)this.complaintStatusMappingService.getStatusByRoleAndCurrentStatus(this.securityUtils.getCurrentUser().getRoles(), complaint.getStatus()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("complaintType", (Object)this.complaintTypeService.findActiveComplaintTypes());
        model.addAttribute("ward", Collections.emptyList());
        if (complaint.getCitizenFeedback() != null) {
            model.addAttribute("citizenRating", (Object)complaint.getCitizenFeedback().ordinal());
        }
        if (complaint.getLocation() != null && complaint.getChildLocation() != null) {
            model.addAttribute("ward", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName(complaint.getLocation().getBoundaryType().getName(), "Administration"));
            model.addAttribute("location", (Object)this.crossHierarchyService.getChildBoundariesNameAndBndryTypeAndHierarchyType("Locality", "Location"));
        } else if (complaint.getLat() > 0.0 && complaint.getLng() > 0.0) {
            model.addAttribute("ward", (Object)this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName(complaint.getLocation().getBoundaryType().getName(), "Administration"));
            model.addAttribute("location", (Object)this.crossHierarchyService.findChildBoundariesByParentBoundary(complaint.getLocation().getBoundaryType().getName(), complaint.getLocation().getBoundaryType().getHierarchyType().getName(), complaint.getLocation().getName()));
        }
        if (null != complaint.getComplaintType()) {
            model.addAttribute("mailSubject", (Object)("Grievance regarding " + complaint.getComplaintType().getName()));
            model.addAttribute("mailBody", (Object)this.complaintMessagingService.getEmailBody(complaint));
        }
        if (complaint.getStatus() != null) {
            model.addAttribute("complaintStatus", (Object)complaint.getStatus().getName());
        }
    }

    @GetMapping
    public String edit() {
        return this.securityUtils.currentUserIsCitizen() ? COMPLAINT_CITIZEN_EDIT : COMPLAINT_EDIT;
    }

    @PostMapping
    public String update(@Valid @ModelAttribute Complaint complaint, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request, @RequestParam(value="files") MultipartFile[] files) {
        String result;
        this.validateUpdate(complaint, errors, request);
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null && !request.getParameter("approvalComent").trim().isEmpty()) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("citizenRating") != null && !request.getParameter("citizenRating").isEmpty()) {
            complaint.setCitizenFeedback(CitizenFeedback.values()[Integer.valueOf(request.getParameter("citizenRating"))]);
        }
        if (!errors.hasErrors()) {
            if (!this.securityUtils.currentUserType().equals((Object)UserType.CITIZEN) && files != null) {
                complaint.getSupportDocs().addAll(this.fileStoreUtils.addToFileStore(files, "PGR", false));
            }
            complaint.sendToPreviousOwner(false);
            complaint.approverComment(approvalComent);
            complaint.nextOwnerId(approvalPosition);
            this.complaintService.updateComplaint(complaint);
            redirectAttrs.addFlashAttribute("complaint", (Object)complaint);
            result = "redirect:" + complaint.getCrn() + COMPLAINT_UPDATE_SUCCESS;
        } else {
            result = this.securityUtils.currentUserType().equals((Object)UserType.CITIZEN) ? COMPLAINT_CITIZEN_EDIT : COMPLAINT_EDIT;
        }
        return result;
    }

    @GetMapping(value={"/update-success"})
    public ModelAndView successView(@ModelAttribute Complaint complaint) {
        return new ModelAndView("complaint/reg-success", "complaint", (Object)complaint);
    }

    private void validateUpdate(Complaint complaint, BindingResult errors, HttpServletRequest request) {
        if (complaint.getStatus() == null) {
            errors.rejectValue("status", "status.requried");
        }
        if (request.getParameter("approvalComent") == null || request.getParameter("approvalComent").trim().isEmpty()) {
            errors.addError(new ObjectError("approvalComent", this.messageSource.getMessage("comment.not.null", null, null)));
        }
        if (complaint.getLocation() == null && complaint.getLat() > 0.0 && complaint.getLng() > 0.0) {
            errors.rejectValue("location", "location.info.not.found");
        }
        if ((complaint.getLocation() == null || complaint.getChildLocation() == null) && complaint.getLat() <= 0.0 && complaint.getLng() <= 0.0) {
            errors.rejectValue("location", "location.info.not.found");
        }
    }
}

