/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.report.entity.contract.PendingGrievanceAdaptor;
import org.egov.pgr.service.ComplaintService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pending"})
public class PendingGrievanceController {
    private final ComplaintService complaintService;

    @Autowired
    public PendingGrievanceController(ComplaintService complaintService) {
        this.complaintService = complaintService;
    }

    @ModelAttribute
    public Complaint complaint() {
        return new Complaint();
    }

    @GetMapping(value={"grievance-list"})
    public String complaintTypeViewForm() {
        return "grievance-list";
    }

    @GetMapping(value={"ajax-grievancelist"}, produces={"application/json"})
    @ResponseBody
    public void getPendingGrievances(HttpServletResponse response) throws IOException {
        IOUtils.write((String)("{ \"data\":" + JsonUtils.toJSON((Collection)this.complaintService.getPendingGrievances(), Complaint.class, PendingGrievanceAdaptor.class) + "}"), (Writer)response.getWriter());
    }
}

