/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import org.apache.commons.lang3.StringUtils;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.report.entity.contract.DrilldownAdaptor;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.contract.GrievanceDrilldownReportAdaptor;
import org.egov.pgr.report.service.GrievanceTypewiseReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/grievancetypewise"})
public class GrievanceTypewiseReportController {
    @Autowired
    private GrievanceTypewiseReportService grievanceTypewiseReportService;

    @GetMapping
    public String grievanceTypewiseSearchForm() {
        return "complaintTypeReport-search";
    }

    @PostMapping(produces={"text/plain"})
    @ResponseBody
    public String searchGrievanceTypewiseReport(DrilldownReportRequest reportRequest) {
        if (org.egov.infra.utils.StringUtils.isNotBlank((String)reportRequest.getComplaintDateType()) && org.egov.infra.utils.StringUtils.isNotBlank((String)reportRequest.getStatus())) {
            return new DataTable(this.grievanceTypewiseReportService.pagedGrievanceTypewiseRecordsByCompalintId(reportRequest), (long)reportRequest.draw()).toJson(DrilldownAdaptor.class);
        }
        return new DataTable(this.grievanceTypewiseReportService.pagedGrievanceTypewiseRecords(reportRequest), (long)reportRequest.draw()).toJson(GrievanceDrilldownReportAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] grievanceTypewiseGrandTotal(DrilldownReportRequest reportRequest) {
        return this.grievanceTypewiseReportService.grievanceTypewiseReportGrandTotal(reportRequest);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadGrievanceTypewiseReport(DrilldownReportRequest reportCriteria) {
        ReportOutput reportOutput = StringUtils.isNotBlank((CharSequence)reportCriteria.getComplaintDateType()) && StringUtils.isNotBlank((CharSequence)reportCriteria.getStatus()) ? this.grievanceTypewiseReportService.generateGrievanceTypewiseReportByComplaintId(reportCriteria) : this.grievanceTypewiseReportService.generateGrievanceTypewiseReport(reportCriteria);
        reportOutput.setReportName("grievancetypewise_report");
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

