/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import org.apache.commons.lang3.StringUtils;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.report.entity.contract.DrilldownAdaptor;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.contract.GrievanceDrilldownReportAdaptor;
import org.egov.pgr.report.service.FunctionarywiseReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/functionarywise"})
public class FunctionarywiseReportController {
    @Autowired
    private FunctionarywiseReportService functionarywiseReportService;

    @GetMapping
    public String functionarywiseSearchForm() {
        return "functionaryWise-search";
    }

    @PostMapping(produces={"text/plain"})
    @ResponseBody
    public String searchFunctionarywiseReport(DrilldownReportRequest reportRequest) {
        if (org.egov.infra.utils.StringUtils.isNotBlank((String)reportRequest.getUsrid()) && org.egov.infra.utils.StringUtils.isNotBlank((String)reportRequest.getStatus())) {
            return new DataTable(this.functionarywiseReportService.pagedFunctionarwiseReportByCompalints(reportRequest), (long)reportRequest.draw()).toJson(DrilldownAdaptor.class);
        }
        return new DataTable(this.functionarywiseReportService.pagedFunctionarwiseRecords(reportRequest), (long)reportRequest.draw()).toJson(GrievanceDrilldownReportAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] functionarywiseGrandTotal(DrilldownReportRequest request) {
        return this.functionarywiseReportService.functionarywiseReportGrandTotal(request);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadFunctionarywiseReport(DrilldownReportRequest reportCriteria) {
        ReportOutput reportOutput = StringUtils.isNotBlank((CharSequence)reportCriteria.getUsrid()) && StringUtils.isNotBlank((CharSequence)reportCriteria.getStatus()) ? this.functionarywiseReportService.generateFunctionaryEmployeewiseReport(reportCriteria) : this.functionarywiseReportService.generateFunctionarywiseReport(reportCriteria);
        reportOutput.setReportName("functionarywise_report");
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

