/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.util.Collections;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.contract.EscalationRouterRequest;
import org.egov.pgr.entity.contract.EscalationRouterView;
import org.egov.pgr.report.entity.contract.EscalationRouterAdaptor;
import org.egov.pgr.report.service.EscalationRouterReportService;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/escalationrouter"})
public class EscalationRouterReportController {
    @Autowired
    private ComplaintTypeCategoryService complaintTypeCategoryService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private EscalationRouterReportService escalationRouterReportService;

    @ModelAttribute
    public EscalationRouterView escalationRouterView() {
        return new EscalationRouterView();
    }

    @GetMapping
    public String escalationRouterReportSearchForm(Model model) {
        model.addAttribute("categories", (Object)this.complaintTypeCategoryService.findAll());
        model.addAttribute("complaintTypes", Collections.emptyList());
        model.addAttribute("wardList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION"));
        return "routerescalation-report";
    }

    @PostMapping(produces={"text/plain"})
    @ResponseBody
    public String searchEscalationRouterReport(EscalationRouterRequest escalationRouterRequest) {
        return new DataTable(this.escalationRouterReportService.pagedEscalationRouterReport(escalationRouterRequest), (long)escalationRouterRequest.draw()).toJson(EscalationRouterAdaptor.class);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadEscalationRouterReport(EscalationRouterRequest reportCriteria) {
        ReportOutput reportOutput = this.escalationRouterReportService.generateEscalationRouterReport(reportCriteria);
        reportOutput.setReportName("escalation_router_report");
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

