/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import org.apache.commons.lang.StringUtils;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.report.entity.contract.DrilldownAdaptor;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.contract.GrievanceDrilldownReportAdaptor;
import org.egov.pgr.report.service.DrillDownReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/drilldown"})
public class DrillDownReportController {
    @Autowired
    private DrillDownReportService drillDownReportService;

    @GetMapping(value={"boundarywise"})
    public String showBoundarywiseDrilldownReportForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "drillDown-search";
    }

    @GetMapping(value={"departmentwise"})
    public String showDepartmentwiseDrilldownReportForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "drillDown-search";
    }

    @GetMapping(produces={"text/plain"})
    @ResponseBody
    public String searchDrilldownReport(DrilldownReportRequest reportRequest) {
        if (StringUtils.isNotBlank((String)reportRequest.getDeptid()) && StringUtils.isNotBlank((String)reportRequest.getComplainttypeid()) && StringUtils.isNotBlank((String)reportRequest.getSelecteduserid())) {
            return new DataTable(this.drillDownReportService.pagedDrilldownRecordsByCompalintId(reportRequest), (long)reportRequest.draw()).toJson(DrilldownAdaptor.class);
        }
        return new DataTable(this.drillDownReportService.pagedDrilldownRecords(reportRequest), (long)reportRequest.draw()).toJson(GrievanceDrilldownReportAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] drilldownReportGrandTotal(DrilldownReportRequest reportRequest) {
        return this.drillDownReportService.drilldownRecordsGrandTotal(reportRequest);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadDrilldownReport(DrilldownReportRequest reportCriteria) {
        ReportOutput reportOutput = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reportCriteria.getDeptid()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reportCriteria.getComplainttypeid()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reportCriteria.getSelecteduserid()) ? this.drillDownReportService.generateComplaintwiseDrilldownReport(reportCriteria) : this.drillDownReportService.generateDrilldownReport(reportCriteria);
        reportOutput.setReportName("drilldown_report");
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

