/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import java.util.LinkedHashMap;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.report.entity.contract.AgeingReportAdaptor;
import org.egov.pgr.report.entity.contract.AgeingReportRequest;
import org.egov.pgr.report.service.AgeingReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/ageing"})
public class AgeingReportController {
    @Autowired
    private AgeingReportService ageingReportService;

    @ModelAttribute
    public void ageingReportSearchForm(Model model) {
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        status.put("Completed", "Completed");
        status.put("Pending", "Pending");
        status.put("Rejected", "Rejected");
        model.addAttribute("status", status);
        model.addAttribute("ageingReportForm", (Object)new AgeingReportRequest());
    }

    @GetMapping(value={"boundarywise"})
    public String showBoundarywiseAgeingReportForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "ageing-search";
    }

    @GetMapping(value={"departmentwise"})
    public String showDepartmentwiseAgeingReportForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "ageing-search";
    }

    @GetMapping(produces={"text/plain"})
    @ResponseBody
    public String searchAgeingReport(AgeingReportRequest request) {
        return new DataTable(this.ageingReportService.pagedAgeingRecords(request), (long)request.draw()).toJson(AgeingReportAdaptor.class);
    }

    @GetMapping(value={"grand-total"})
    @ResponseBody
    public Object[] ageingReportGrandTotal(AgeingReportRequest request) {
        return this.ageingReportService.ageingReportGrandTotal(request);
    }

    @GetMapping(value={"download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadAgeingReport(AgeingReportRequest reportCriteria) {
        ReportOutput reportOutput = this.ageingReportService.generateAgeingReport(reportCriteria);
        reportOutput.setReportName("ageing_report");
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

